/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.wrapper;

import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.CK_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_NOTIFY;
import iaik.pkcs.pkcs11.wrapper.CK_SESSION_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_SLOT_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.File;
import java.io.IOException;

public class PKCS11Implementation
implements PKCS11 {
    private static final String PKCS11_WRAPPER = "pkcs11wrapper";
    protected static boolean linkedAndInitialized_;
    protected String pkcs11ModulePath_;

    PKCS11Implementation(String string) throws IOException {
        PKCS11Implementation.ensureLinkedAndInitialized();
        this.connect(string);
        this.pkcs11ModulePath_ = string;
    }

    PKCS11Implementation(String string, String string2) throws IOException {
        PKCS11Implementation.ensureLinkedAndInitialized(string2);
        this.connect(string);
        this.pkcs11ModulePath_ = string;
    }

    public native void C_CancelFunction(long var1) throws PKCS11Exception;

    public native void C_CloseAllSessions(long var1) throws PKCS11Exception;

    public native void C_CloseSession(long var1) throws PKCS11Exception;

    public native long C_CopyObject(long var1, long var3, CK_ATTRIBUTE[] var5) throws PKCS11Exception;

    public native long C_CreateObject(long var1, CK_ATTRIBUTE[] var3) throws PKCS11Exception;

    public native byte[] C_Decrypt(long var1, byte[] var3) throws PKCS11Exception;

    public native byte[] C_DecryptDigestUpdate(long var1, byte[] var3) throws PKCS11Exception;

    public native byte[] C_DecryptFinal(long var1) throws PKCS11Exception;

    public native void C_DecryptInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native byte[] C_DecryptUpdate(long var1, byte[] var3) throws PKCS11Exception;

    public native byte[] C_DecryptVerifyUpdate(long var1, byte[] var3) throws PKCS11Exception;

    public native long C_DeriveKey(long var1, CK_MECHANISM var3, long var4, CK_ATTRIBUTE[] var6) throws PKCS11Exception;

    public native void C_DestroyObject(long var1, long var3) throws PKCS11Exception;

    public native byte[] C_Digest(long var1, byte[] var3) throws PKCS11Exception;

    public native byte[] C_DigestEncryptUpdate(long var1, byte[] var3) throws PKCS11Exception;

    public native byte[] C_DigestFinal(long var1) throws PKCS11Exception;

    public native void C_DigestInit(long var1, CK_MECHANISM var3) throws PKCS11Exception;

    public native void C_DigestKey(long var1, long var3) throws PKCS11Exception;

    public native void C_DigestUpdate(long var1, byte[] var3) throws PKCS11Exception;

    public native byte[] C_Encrypt(long var1, byte[] var3) throws PKCS11Exception;

    public native byte[] C_EncryptFinal(long var1) throws PKCS11Exception;

    public native void C_EncryptInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native byte[] C_EncryptUpdate(long var1, byte[] var3) throws PKCS11Exception;

    public native void C_Finalize(Object var1) throws PKCS11Exception;

    public native long[] C_FindObjects(long var1, long var3) throws PKCS11Exception;

    public native void C_FindObjectsFinal(long var1) throws PKCS11Exception;

    public native void C_FindObjectsInit(long var1, CK_ATTRIBUTE[] var3) throws PKCS11Exception;

    public native long C_GenerateKey(long var1, CK_MECHANISM var3, CK_ATTRIBUTE[] var4) throws PKCS11Exception;

    public native long[] C_GenerateKeyPair(long var1, CK_MECHANISM var3, CK_ATTRIBUTE[] var4, CK_ATTRIBUTE[] var5) throws PKCS11Exception;

    public native void C_GenerateRandom(long var1, byte[] var3) throws PKCS11Exception;

    public native void C_GetAttributeValue(long var1, long var3, CK_ATTRIBUTE[] var5) throws PKCS11Exception;

    public native void C_GetFunctionStatus(long var1) throws PKCS11Exception;

    public native CK_INFO C_GetInfo() throws PKCS11Exception;

    public native CK_MECHANISM_INFO C_GetMechanismInfo(long var1, long var3) throws PKCS11Exception;

    public native long[] C_GetMechanismList(long var1) throws PKCS11Exception;

    public native long C_GetObjectSize(long var1, long var3) throws PKCS11Exception;

    public native byte[] C_GetOperationState(long var1) throws PKCS11Exception;

    public native CK_SESSION_INFO C_GetSessionInfo(long var1) throws PKCS11Exception;

    public native CK_SLOT_INFO C_GetSlotInfo(long var1) throws PKCS11Exception;

    public native long[] C_GetSlotList(boolean var1) throws PKCS11Exception;

    public native CK_TOKEN_INFO C_GetTokenInfo(long var1) throws PKCS11Exception;

    public native void C_InitPIN(long var1, char[] var3) throws PKCS11Exception;

    public native void C_InitToken(long var1, char[] var3, char[] var4) throws PKCS11Exception;

    public native void C_Initialize(Object var1) throws PKCS11Exception;

    public native void C_Login(long var1, long var3, char[] var5) throws PKCS11Exception;

    public native void C_Logout(long var1) throws PKCS11Exception;

    public native long C_OpenSession(long var1, long var3, Object var5, CK_NOTIFY var6) throws PKCS11Exception;

    public native void C_SeedRandom(long var1, byte[] var3) throws PKCS11Exception;

    public native void C_SetAttributeValue(long var1, long var3, CK_ATTRIBUTE[] var5) throws PKCS11Exception;

    public native void C_SetOperationState(long var1, byte[] var3, long var4, long var6) throws PKCS11Exception;

    public native void C_SetPIN(long var1, char[] var3, char[] var4) throws PKCS11Exception;

    public native byte[] C_Sign(long var1, byte[] var3) throws PKCS11Exception;

    public native byte[] C_SignEncryptUpdate(long var1, byte[] var3) throws PKCS11Exception;

    public native byte[] C_SignFinal(long var1) throws PKCS11Exception;

    public native void C_SignInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native byte[] C_SignRecover(long var1, byte[] var3) throws PKCS11Exception;

    public native void C_SignRecoverInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native void C_SignUpdate(long var1, byte[] var3) throws PKCS11Exception;

    public native long C_UnwrapKey(long var1, CK_MECHANISM var3, long var4, byte[] var6, CK_ATTRIBUTE[] var7) throws PKCS11Exception;

    public native void C_Verify(long var1, byte[] var3, byte[] var4) throws PKCS11Exception;

    public native void C_VerifyFinal(long var1, byte[] var3) throws PKCS11Exception;

    public native void C_VerifyInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native byte[] C_VerifyRecover(long var1, byte[] var3) throws PKCS11Exception;

    public native void C_VerifyRecoverInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native void C_VerifyUpdate(long var1, byte[] var3) throws PKCS11Exception;

    public native long C_WaitForSlotEvent(long var1, Object var3) throws PKCS11Exception;

    public native byte[] C_WrapKey(long var1, CK_MECHANISM var3, long var4, long var6) throws PKCS11Exception;

    protected synchronized native void connect(String var1) throws IOException;

    protected synchronized native void disconnect();

    public static synchronized void ensureLinkedAndInitialized() {
        if (!linkedAndInitialized_) {
            System.loadLibrary(PKCS11_WRAPPER);
            PKCS11Implementation.initializeLibrary();
            linkedAndInitialized_ = true;
        }
    }

    public static synchronized void ensureLinkedAndInitialized(String string) {
        if (!linkedAndInitialized_) {
            System.load(string);
            PKCS11Implementation.initializeLibrary();
            linkedAndInitialized_ = true;
        }
    }

    public static synchronized void ensureUnlinkedAndFinalized() {
        if (linkedAndInitialized_) {
            PKCS11Implementation.finalizeLibrary();
            linkedAndInitialized_ = false;
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        block9: {
            if (this == object) {
                bl = true;
            } else if (object instanceof PKCS11Implementation) {
                PKCS11Implementation pKCS11Implementation = (PKCS11Implementation)object;
                if (this.pkcs11ModulePath_.equals(pKCS11Implementation.pkcs11ModulePath_)) {
                    bl = true;
                } else {
                    try {
                        File file = new File(this.pkcs11ModulePath_);
                        File file2 = new File(pKCS11Implementation.pkcs11ModulePath_);
                        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        bl = false;
                    }
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    protected static synchronized native void finalizeLibrary();

    public int hashCode() {
        int n;
        try {
            File file = new File(this.pkcs11ModulePath_);
            n = file.getCanonicalPath().hashCode();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            n = this.pkcs11ModulePath_.hashCode();
        }
        return n;
    }

    protected static synchronized native void initializeLibrary();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Module Name: ");
        stringBuffer.append(this.pkcs11ModulePath_);
        return stringBuffer.toString();
    }
}

