/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class SSL3RandomDataParameters
implements Parameters {
    protected byte[] clientRandom_;
    protected byte[] serverRandom_;

    public SSL3RandomDataParameters(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"clientRandom\" must not be null.");
        }
        if (byArray2 == null) {
            throw new NullPointerException("Argument \"serverRandom\" must not be null.");
        }
        this.clientRandom_ = byArray;
        this.serverRandom_ = byArray2;
    }

    public Object clone() {
        SSL3RandomDataParameters sSL3RandomDataParameters;
        try {
            sSL3RandomDataParameters = (SSL3RandomDataParameters)super.clone();
            sSL3RandomDataParameters.clientRandom_ = (byte[])this.clientRandom_.clone();
            sSL3RandomDataParameters.serverRandom_ = (byte[])this.serverRandom_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return sSL3RandomDataParameters;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SSL3RandomDataParameters) {
            SSL3RandomDataParameters sSL3RandomDataParameters = (SSL3RandomDataParameters)object;
            bl = this == sSL3RandomDataParameters || Functions.equals(this.clientRandom_, sSL3RandomDataParameters.clientRandom_) && Functions.equals(this.serverRandom_, sSL3RandomDataParameters.serverRandom_);
        }
        return bl;
    }

    public byte[] getClientRandom() {
        return this.clientRandom_;
    }

    public Object getPKCS11ParamsObject() {
        CK_SSL3_RANDOM_DATA cK_SSL3_RANDOM_DATA = new CK_SSL3_RANDOM_DATA();
        cK_SSL3_RANDOM_DATA.pClientRandom = this.clientRandom_;
        cK_SSL3_RANDOM_DATA.pServerRandom = this.serverRandom_;
        return cK_SSL3_RANDOM_DATA;
    }

    public byte[] getServerRandom() {
        return this.serverRandom_;
    }

    public int hashCode() {
        return Functions.hashCode(this.clientRandom_) ^ Functions.hashCode(this.serverRandom_);
    }

    public void setClientRandom(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"clientRandom\" must not be null.");
        }
        this.clientRandom_ = byArray;
    }

    public void setServerRandom(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"serverRandom\" must not be null.");
        }
        this.serverRandom_ = byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append("Client Random (hex): ");
        stringBuffer.append(Functions.toHexString(this.clientRandom_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Server Random (hex): ");
        stringBuffer.append(Functions.toHexString(this.serverRandom_));
        return stringBuffer.toString();
    }
}

