/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.SSL3RandomDataParameters;
import iaik.pkcs.pkcs11.parameters.VersionParameters;
import iaik.pkcs.pkcs11.wrapper.CK_SSL3_MASTER_KEY_DERIVE_PARAMS;
import iaik.pkcs.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;
import iaik.pkcs.pkcs11.wrapper.CK_VERSION;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class SSL3MasterKeyDeriveParameters
implements Parameters {
    protected SSL3RandomDataParameters randomInfo_;
    protected VersionParameters version_;

    public SSL3MasterKeyDeriveParameters(SSL3RandomDataParameters sSL3RandomDataParameters, VersionParameters versionParameters) {
        if (sSL3RandomDataParameters == null) {
            throw new NullPointerException("Argument \"randomInfo\" must not be null.");
        }
        if (versionParameters == null) {
            throw new NullPointerException("Argument \"version\" must not be null.");
        }
        this.randomInfo_ = sSL3RandomDataParameters;
        this.version_ = versionParameters;
    }

    public Object clone() {
        SSL3MasterKeyDeriveParameters sSL3MasterKeyDeriveParameters;
        try {
            sSL3MasterKeyDeriveParameters = (SSL3MasterKeyDeriveParameters)super.clone();
            sSL3MasterKeyDeriveParameters.randomInfo_ = (SSL3RandomDataParameters)this.randomInfo_.clone();
            sSL3MasterKeyDeriveParameters.version_ = (VersionParameters)this.version_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return sSL3MasterKeyDeriveParameters;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SSL3MasterKeyDeriveParameters) {
            SSL3MasterKeyDeriveParameters sSL3MasterKeyDeriveParameters = (SSL3MasterKeyDeriveParameters)object;
            bl = this == sSL3MasterKeyDeriveParameters || this.randomInfo_.equals(sSL3MasterKeyDeriveParameters.randomInfo_) && this.version_.equals(sSL3MasterKeyDeriveParameters.version_);
        }
        return bl;
    }

    public Object getPKCS11ParamsObject() {
        CK_SSL3_MASTER_KEY_DERIVE_PARAMS cK_SSL3_MASTER_KEY_DERIVE_PARAMS = new CK_SSL3_MASTER_KEY_DERIVE_PARAMS();
        cK_SSL3_MASTER_KEY_DERIVE_PARAMS.RandomInfo = (CK_SSL3_RANDOM_DATA)this.randomInfo_.getPKCS11ParamsObject();
        cK_SSL3_MASTER_KEY_DERIVE_PARAMS.pVersion = (CK_VERSION)this.version_.getPKCS11ParamsObject();
        return cK_SSL3_MASTER_KEY_DERIVE_PARAMS;
    }

    public SSL3RandomDataParameters getRandomInfo() {
        return this.randomInfo_;
    }

    public VersionParameters getVersion() {
        return this.version_;
    }

    public int hashCode() {
        return this.randomInfo_.hashCode() ^ this.version_.hashCode();
    }

    public void setRandomInfo(SSL3RandomDataParameters sSL3RandomDataParameters) {
        if (sSL3RandomDataParameters == null) {
            throw new NullPointerException("Argument \"randomInfo\" must not be null.");
        }
        this.randomInfo_ = sSL3RandomDataParameters;
    }

    public void setVersion(VersionParameters versionParameters) {
        if (versionParameters == null) {
            throw new NullPointerException("Argument \"version\" must not be null.");
        }
        this.version_ = versionParameters;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append("Random Information:");
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append(this.randomInfo_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Version: ");
        stringBuffer.append(this.version_);
        return stringBuffer.toString();
    }
}

