/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM_INFO;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class MechanismInfo
implements Cloneable {
    protected long minKeySize_;
    protected long maxKeySize_;
    protected long flags_;

    public MechanismInfo() {
    }

    public MechanismInfo(CK_MECHANISM_INFO cK_MECHANISM_INFO) {
        if (cK_MECHANISM_INFO == null) {
            throw new NullPointerException("Argument \"ckMechanismInfo\" must not be null.");
        }
        this.minKeySize_ = cK_MECHANISM_INFO.ulMinKeySize;
        this.maxKeySize_ = cK_MECHANISM_INFO.ulMaxKeySize;
        this.flags_ = cK_MECHANISM_INFO.flags;
    }

    public MechanismInfo and(MechanismInfo mechanismInfo) {
        MechanismInfo mechanismInfo2 = new MechanismInfo();
        if (mechanismInfo != null) {
            mechanismInfo2.flags_ = this.flags_ & mechanismInfo.flags_;
            mechanismInfo2.minKeySize_ = this.minKeySize_ > mechanismInfo.minKeySize_ ? this.minKeySize_ : mechanismInfo.minKeySize_;
            mechanismInfo2.maxKeySize_ = this.maxKeySize_ < mechanismInfo.maxKeySize_ ? this.maxKeySize_ : mechanismInfo.maxKeySize_;
        }
        return mechanismInfo2;
    }

    public Object clone() {
        MechanismInfo mechanismInfo;
        try {
            mechanismInfo = (MechanismInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return mechanismInfo;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MechanismInfo) {
            MechanismInfo mechanismInfo = (MechanismInfo)object;
            bl = this == mechanismInfo || this.minKeySize_ == mechanismInfo.minKeySize_ && this.maxKeySize_ == mechanismInfo.maxKeySize_ && this.flags_ == mechanismInfo.flags_;
        }
        return bl;
    }

    public long getMaxKeySize() {
        return this.maxKeySize_;
    }

    public long getMinKeySize() {
        return this.minKeySize_;
    }

    public int hashCode() {
        return (int)(this.minKeySize_ ^ this.maxKeySize_ ^ this.flags_);
    }

    public boolean isDecrypt() {
        return (this.flags_ & 0x200L) != 0L;
    }

    public boolean isDerive() {
        return (this.flags_ & 0x80000L) != 0L;
    }

    public boolean isDigest() {
        return (this.flags_ & 0x400L) != 0L;
    }

    public boolean isEcCompress() {
        return (this.flags_ & 0x2000000L) != 0L;
    }

    public boolean isEcEcParameters() {
        return (this.flags_ & 0x400000L) != 0L;
    }

    public boolean isEcF2m() {
        return (this.flags_ & 0x200000L) != 0L;
    }

    public boolean isEcFp() {
        return (this.flags_ & 0x100000L) != 0L;
    }

    public boolean isEcNamedCurve() {
        return (this.flags_ & 0x800000L) != 0L;
    }

    public boolean isEcUncompress() {
        return (this.flags_ & 0x1000000L) != 0L;
    }

    public boolean isEncrypt() {
        return (this.flags_ & 0x100L) != 0L;
    }

    public boolean isExtension() {
        return (this.flags_ & 0x80000000L) != 0L;
    }

    public boolean isGenerate() {
        return (this.flags_ & 0x8000L) != 0L;
    }

    public boolean isGenerateKeyPair() {
        return (this.flags_ & 0x10000L) != 0L;
    }

    public boolean isHw() {
        return (this.flags_ & 1L) != 0L;
    }

    public boolean isSign() {
        return (this.flags_ & 0x800L) != 0L;
    }

    public boolean isSignRecover() {
        return (this.flags_ & 0x1000L) != 0L;
    }

    public boolean isUnwrap() {
        return (this.flags_ & 0x40000L) != 0L;
    }

    public boolean isVerify() {
        return (this.flags_ & 0x2000L) != 0L;
    }

    public boolean isVerifyRecover() {
        return (this.flags_ & 0x4000L) != 0L;
    }

    public boolean isWrap() {
        return (this.flags_ & 0x20000L) != 0L;
    }

    public MechanismInfo not() {
        MechanismInfo mechanismInfo = (MechanismInfo)this.clone();
        mechanismInfo.flags_ = this.flags_ ^ 0xFFFFFFFFFFFFFFFFL;
        return mechanismInfo;
    }

    public MechanismInfo or(MechanismInfo mechanismInfo) {
        MechanismInfo mechanismInfo2;
        if (mechanismInfo != null) {
            mechanismInfo2 = new MechanismInfo();
            mechanismInfo2.flags_ = this.flags_ | mechanismInfo.flags_;
            mechanismInfo2.minKeySize_ = this.minKeySize_ < mechanismInfo.minKeySize_ ? this.minKeySize_ : mechanismInfo.minKeySize_;
            mechanismInfo2.maxKeySize_ = this.maxKeySize_ > mechanismInfo.maxKeySize_ ? this.maxKeySize_ : mechanismInfo.maxKeySize_;
        } else {
            mechanismInfo2 = (MechanismInfo)this.clone();
        }
        return mechanismInfo2;
    }

    public void setDecrypt(boolean bl) {
        this.setFlagBit(512L, bl);
    }

    public void setDerive(boolean bl) {
        this.setFlagBit(524288L, bl);
    }

    public void setDigest(boolean bl) {
        this.setFlagBit(1024L, bl);
    }

    public void setEcCompress(boolean bl) {
        this.setFlagBit(0x2000000L, bl);
    }

    public void setEcEcParameters(boolean bl) {
        this.setFlagBit(0x400000L, bl);
    }

    public void setEcF2m(boolean bl) {
        this.setFlagBit(0x200000L, bl);
    }

    public void setEcFp(boolean bl) {
        this.setFlagBit(0x100000L, bl);
    }

    public void setEcNamedCurve(boolean bl) {
        this.setFlagBit(0x800000L, bl);
    }

    public void setEcUncompress(boolean bl) {
        this.setFlagBit(0x1000000L, bl);
    }

    public void setEncrypt(boolean bl) {
        this.setFlagBit(256L, bl);
    }

    public void setExtension(boolean bl) {
        this.setFlagBit(0x80000000L, bl);
    }

    protected void setFlagBit(long l, boolean bl) {
        this.flags_ = bl ? (this.flags_ |= l) : (this.flags_ &= l ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void setGenerate(boolean bl) {
        this.setFlagBit(32768L, bl);
    }

    public void setGenerateKeyPair(boolean bl) {
        this.setFlagBit(65536L, bl);
    }

    public void setHw(boolean bl) {
        this.setFlagBit(1L, bl);
    }

    public void setMaxKeySize(long l) {
        this.maxKeySize_ = l;
    }

    public void setMinKeySize(long l) {
        this.minKeySize_ = l;
    }

    public void setSign(boolean bl) {
        this.setFlagBit(2048L, bl);
    }

    public void setSignRecover(boolean bl) {
        this.setFlagBit(4096L, bl);
    }

    public void setUnwrap(boolean bl) {
        this.setFlagBit(262144L, bl);
    }

    public void setVerify(boolean bl) {
        this.setFlagBit(8192L, bl);
    }

    public void setVerifyRecover(boolean bl) {
        this.setFlagBit(16384L, bl);
    }

    public void setWrap(boolean bl) {
        this.setFlagBit(131072L, bl);
    }

    public boolean supports(MechanismInfo mechanismInfo) {
        if (mechanismInfo == null) {
            throw new NullPointerException("Argument \"requiredFeatures\" must not be null.");
        }
        long l = mechanismInfo.getMaxKeySize();
        if (l != 0L && l > this.maxKeySize_) {
            return false;
        }
        long l2 = mechanismInfo.getMinKeySize();
        if (l2 != 0L && l2 < this.minKeySize_) {
            return false;
        }
        return (mechanismInfo.flags_ & this.flags_) == mechanismInfo.flags_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("  ");
        stringBuffer.append("Minimum Key-Size: ");
        stringBuffer.append(this.minKeySize_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Maximum Key-Size: ");
        stringBuffer.append(this.maxKeySize_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Hardware: ");
        stringBuffer.append(this.isHw());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Encrypt: ");
        stringBuffer.append(this.isEncrypt());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Decrypt: ");
        stringBuffer.append(this.isDecrypt());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Digest: ");
        stringBuffer.append(this.isDigest());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Sign: ");
        stringBuffer.append(this.isSign());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Sign Recover: ");
        stringBuffer.append(this.isSignRecover());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Verify: ");
        stringBuffer.append(this.isVerify());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Verify Recover: ");
        stringBuffer.append(this.isVerifyRecover());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Generate: ");
        stringBuffer.append(this.isGenerate());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Generate Key-Pair: ");
        stringBuffer.append(this.isGenerateKeyPair());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Wrap: ");
        stringBuffer.append(this.isWrap());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Unwrap: ");
        stringBuffer.append(this.isUnwrap());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Derive: ");
        stringBuffer.append(this.isDerive());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("EC F(p): ");
        stringBuffer.append(this.isEcFp());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("EC F(2^m): ");
        stringBuffer.append(this.isEcF2m());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("EC Parameters: ");
        stringBuffer.append(this.isEcEcParameters());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("EC Named Curve: ");
        stringBuffer.append(this.isEcNamedCurve());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("EC Uncompress: ");
        stringBuffer.append(this.isEcUncompress());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("EC Compress: ");
        stringBuffer.append(this.isEcCompress());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Extension: ");
        stringBuffer.append(this.isExtension());
        return stringBuffer.toString();
    }
}

