/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.util;

import org.jmock.core.CoreMock;
import org.jmock.core.Formatting;
import org.jmock.core.Invocation;
import org.jmock.core.InvocationMocker;
import org.jmock.core.matcher.StatelessInvocationMatcher;
import org.jmock.core.stub.CustomStub;
import org.jmock.util.NotImplementedException;

public class Dummy {
    private Dummy() {
    }

    public static Object newDummy(Class clazz) {
        return Dummy.newDummy(clazz, "dummy" + Formatting.classShortName(clazz));
    }

    public static Object newDummy(final Class clazz, final String string) {
        CoreMock coreMock = new CoreMock(clazz, string);
        InvocationMocker invocationMocker = new InvocationMocker();
        invocationMocker.addMatcher(new StatelessInvocationMatcher(){

            public boolean matches(Invocation invocation) {
                return invocation.invokedMethod.getDeclaringClass() == clazz;
            }

            public StringBuffer describeTo(StringBuffer stringBuffer) {
                return stringBuffer.append("any invokedMethod declared in " + clazz);
            }
        });
        invocationMocker.setStub(new CustomStub("dummy invokedMethod"){

            public Object invoke(Invocation invocation) throws Throwable {
                throw new NotImplementedException(invocation.invokedMethod.getName() + "called on " + string);
            }
        });
        coreMock.addInvokable(invocationMocker);
        return coreMock.proxy();
    }

    public static Object newDummy(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }
}

