/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.expectation;

import org.jmock.expectation.AbstractExpectation;
import org.jmock.expectation.Null;

public class ExpectationValue
extends AbstractExpectation {
    private Object myExpectedValue;
    private Object myActualValue;

    public ExpectationValue(String string) {
        super(string);
        this.clearActual();
    }

    public void clearActual() {
        this.myActualValue = new Null("Nothing");
    }

    public void setActual(int n) {
        this.setActual(new Integer(n));
    }

    public void setActual(long l) {
        this.setActual(new Long(l));
    }

    public void setActual(double d) {
        this.setActual(new Double(d));
    }

    public void setActual(Object object) {
        this.myActualValue = object;
        if (this.shouldCheckImmediately()) {
            this.verify();
        }
    }

    public void setActual(boolean bl) {
        this.setActual(new Boolean(bl));
    }

    public void setExpected(int n) {
        this.setExpected(new Integer(n));
    }

    public void setExpected(long l) {
        this.setExpected(new Long(l));
    }

    public void setExpected(double d) {
        this.setExpected(new Double(d));
    }

    public void setExpected(Object object) {
        this.myExpectedValue = object;
        this.setHasExpectations();
    }

    public void setExpected(boolean bl) {
        this.setExpected(new Boolean(bl));
    }

    public void setExpectNothing() {
        this.setExpected(new Null("Nothing"));
        this.myActualValue = this.myExpectedValue;
    }

    public void verify() {
        this.assertEquals("did not receive the expected Value.", this.myExpectedValue, this.myActualValue);
    }
}

