/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import org.jmock.core.DynamicMock;

public class Formatting {
    public static String toReadableString(Object object) {
        if (object == null) {
            return "null";
        }
        if (Proxy.isProxyClass(object.getClass())) {
            return Formatting.unpackProxy(object).toString();
        }
        if (object.getClass().isArray()) {
            return Formatting.join(object, new StringBuffer()).toString();
        }
        return object.toString();
    }

    private static Object unpackProxy(Object object) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
        return invocationHandler instanceof DynamicMock ? invocationHandler : object;
    }

    public static StringBuffer join(Object object, StringBuffer stringBuffer) {
        return Formatting.join(object, stringBuffer, "[", "]");
    }

    public static StringBuffer join(Collection collection, StringBuffer stringBuffer, String string, String string2) {
        return Formatting.join(collection.toArray(), stringBuffer, string, string2);
    }

    public static StringBuffer join(Collection collection, StringBuffer stringBuffer, String string, String string2, String string3) {
        return Formatting.join(collection.toArray(), stringBuffer, string, string2, string3);
    }

    public static StringBuffer join(Object object, StringBuffer stringBuffer, String string, String string2) {
        return Formatting.join(object, stringBuffer, string, ", ", string2);
    }

    public static StringBuffer join(Object object, StringBuffer stringBuffer, String string, String string2, String string3) {
        stringBuffer.append(string);
        for (int i = 0; i < Array.getLength(object); ++i) {
            Object object2;
            if (i > 0) {
                stringBuffer.append(string2);
            }
            if (null == (object2 = Array.get(object, i))) {
                stringBuffer.append("<null>");
                continue;
            }
            if (object2.getClass().isArray()) {
                Formatting.join(object2, stringBuffer);
                continue;
            }
            stringBuffer.append("<");
            stringBuffer.append(Formatting.toReadableString(object2));
            stringBuffer.append(">");
        }
        stringBuffer.append(string3);
        return stringBuffer;
    }

    public static String classShortName(Class clazz) {
        String string = clazz.getName();
        return string.substring(Math.max(string.lastIndexOf(46), string.lastIndexOf(36)) + 1);
    }
}

