/*
 * Decompiled with CFR 0.152.
 */
package com.att.research.fenner.xmleditapp.xml2rfc;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.ComponentFactory;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.view.DocumentView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class PreRootPI
implements ComponentFactory,
ActionListener,
ListSelectionListener {
    private static final Name RFC = Name.get((String)"rfc");
    String[] columnNames = new String[]{"Instruction", "Value"};
    private Element rootElement;
    private DocumentView documentView;
    private MyTableModel tablemodel;
    private JTable table;
    private JButton delbutton;
    private ArrayList pis;
    String[] knownPIs = new String[]{"autobreaks", "background", "colonspace", "comments", "compact", "editing", "emoticonic", "footer", "header", "include", "inline", "iprnotified", "linkmailto", "linefile", "needLines", "private", "rfcedstyle", "rfcprocack", "slides", "sortrefs", "strict", "subcompact", "symrefs", "toc", "tocappendix", "tocdepth", "tocindent", "tocompact", "tocnarrow", "topblock", "typeout", "useobject"};
    String[] tooltips = new String[]{"automatically force page breaks to avoid widows and orphans (not perfect)", "when producing a html file, use this image", "put two spaces instead of one after each colon (\u201c:\u201d) in txt or nroff files", "render <cref> information", "when producing a txt/nroff file, try to conserve vertical whitespace", "insert editing marks for ease of discussing draft versions", "automatically replaces input sequences such as |*text| by, e.g., <strong>text</strong> in html output", "override the center footer string", "override the leftmost header string", "include this file", "if comments is \u201cyes\u201d, then render comments inline; otherwise render them in an \u201cEditorial Comments\u201d section", "include boilerplate from Section\u00a010.4(d) of RFC 2026 [obsolete]", "generate mailto: URL, as appropriate", "a string like \u201c35:file.xml\u201d or just \u201c35\u201d (file name then defaults to the containing file's real name or to the latest linefile specification that changed it) that will be used to override xml2rfc's reckoning of the current input position (right after this PI) for warning and error reporting purposes (line numbers are 1-based)", "an integer hint indicating how many contiguous lines are needed at this point in the output", "name of private memo rather than an RFC or Internet-Draft", "output closer to RFC-Editor style", "add a short sentence acknowledging that xml2rfc was used in the document's production to process an input XML source file in RFC-2629 format", "when producing a html file, produce multiple files for a slide show", "sort references", "try to enforce the ID-nits conventions and DTD validity", "if compact is \u201cyes\u201d, then you can make things a little less compact by setting this to \u201cno\u201d (the default value is the current value of the compact PI)", "use anchors rather than numbers for references", "generate a table-of-contents", "control whether the word \u201cAppendix\u201d appears in the table-of-content", "if toc is \u201cyes\u201d, then this determines the depth of the table-of-contents", "if toc is \u201cyes\u201d, will indent subsections in the table-of-contents", "if toc is \u201cyes\u201d, then setting this to \u201cno\u201d will make it a little less compact", "if toc is \u201cyes\u201d, then setting this to \u201cyes\u201d will conserve horizontal space in toc", "put the famous header block on the first page", "during processing pass\u00a02, print the value to standard output at that point in processing", "when producing a html file, use the <object> html element with inner replacement content instead of the <img> html element, when a source xml element includes an src attribute"};

    public Component createComponent(Element element, Style style, StyleValue[] parameters, StyledViewFactory viewFactory, boolean[] stretch) {
        Tree document = (Tree)element.document();
        this.rootElement = element;
        this.documentView = viewFactory.getDocumentView();
        this.pis = new ArrayList();
        for (Node n = document.getFirstChild(); n != null && n.compareTo((XNode)element) < 0; n = n.getNextSibling()) {
            if (n.getType() != Node.Type.PROCESSING_INSTRUCTION || n.name() != RFC) continue;
            this.pis.add(new RFCPI((ProcessingInstruction)n));
        }
        JPanel pane = new JPanel(new BorderLayout());
        pane.setBackground(style.backgroundColor);
        pane.setForeground(style.color);
        pane.setBorder(BorderFactory.createTitledBorder("<?rfc ...?> PIs"));
        this.tablemodel = new MyTableModel();
        this.table = new JTable(this.tablemodel);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        pane.add((Component)this.table.getTableHeader(), "First");
        pane.add((Component)this.table, "Center");
        TableColumn instructionColumn = this.table.getColumnModel().getColumn(0);
        JComboBox<String> comboBox = new JComboBox<String>(this.knownPIs);
        comboBox.setEditable(true);
        comboBox.setRenderer(new MyComboBoxRenderer());
        instructionColumn.setCellEditor(new DefaultCellEditor(comboBox));
        JPanel pane2 = new JPanel(new BorderLayout());
        pane2.setBackground(style.backgroundColor);
        pane2.setForeground(style.color);
        pane.add((Component)pane2, "Last");
        JButton addbutton = new JButton("Add");
        addbutton.setBackground(style.backgroundColor);
        addbutton.setForeground(style.color);
        addbutton.addActionListener(this);
        addbutton.setActionCommand("add");
        addbutton.setToolTipText("Add a new <?rfc ...?> PI to the table");
        pane2.add((Component)addbutton, "West");
        this.delbutton = new JButton("Delete");
        this.delbutton.setBackground(style.backgroundColor);
        this.delbutton.setForeground(style.color);
        this.delbutton.addActionListener(this);
        this.delbutton.setActionCommand("del");
        this.delbutton.setToolTipText("Delete the current table row");
        pane2.add((Component)this.delbutton, "East");
        this.delbutton.setEnabled(false);
        stretch[0] = true;
        return pane;
    }

    public void actionPerformed(ActionEvent e) {
        Tree document = (Tree)this.rootElement.document();
        if ("add".equals(e.getActionCommand())) {
            ProcessingInstruction pi = new ProcessingInstruction("rfc", "???=\"???\"");
            document.insertChild((Node)this.rootElement, (Node)pi);
            this.pis.add(new RFCPI(pi));
            this.tablemodel.fireTableRowsInserted(this.pis.size() - 1, this.pis.size() - 1);
        } else {
            int row = this.table.getSelectionModel().getMinSelectionIndex();
            if (row >= 0) {
                TableCellEditor ce = this.table.getCellEditor();
                if (ce != null) {
                    ce.cancelCellEditing();
                }
                RFCPI pi = (RFCPI)this.pis.get(row);
                document.removeChild((Node)pi.pi);
                this.pis.remove(row);
                this.tablemodel.fireTableRowsDeleted(row, row);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PreRootPI.this.documentView.refreshView((Node)PreRootPI.this.rootElement);
            }
        });
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel m = (ListSelectionModel)e.getSource();
        if (m.isSelectionEmpty()) {
            this.delbutton.setEnabled(false);
        } else {
            this.delbutton.setEnabled(true);
        }
    }

    class RFCPI {
        private String[] attr;
        private ProcessingInstruction pi;

        public RFCPI(ProcessingInstruction node) {
            this.pi = node;
            this.attr = this.pi.getPseudoAttributes();
            if (this.attr == null || this.attr.length < 2) {
                this.attr = new String[]{"???", "???"};
            }
        }

        private void update() {
            Tree document = (Tree)PreRootPI.this.rootElement.document();
            ProcessingInstruction newpi = new ProcessingInstruction("rfc");
            newpi.setPseudoAttributes(this.attr);
            document.replaceChild((Node)this.pi, (Node)newpi);
            this.pi = newpi;
        }

        public void setAttr(String s) {
            if (!s.equals(this.attr[0])) {
                this.attr[0] = s;
                this.update();
            }
        }

        public String getAttr() {
            return this.attr[0];
        }

        public void setValue(String s) {
            if (!s.equals(this.attr[1])) {
                this.attr[1] = s;
                this.update();
            }
        }

        public String getValue() {
            return this.attr[1];
        }
    }

    class MyComboBoxRenderer
    extends BasicComboBoxRenderer {
        MyComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    list.setToolTipText(PreRootPI.this.tooltips[index]);
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            if (PreRootPI.this.pis != null) {
                return PreRootPI.this.pis.size();
            }
            return 0;
        }

        public String getColumnName(int col) {
            return PreRootPI.this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            RFCPI pi = (RFCPI)PreRootPI.this.pis.get(row);
            if (col == 0) {
                return pi.getAttr();
            }
            return pi.getValue();
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            RFCPI pi = (RFCPI)PreRootPI.this.pis.get(row);
            if (col == 0) {
                pi.setAttr((String)value);
            } else {
                pi.setValue((String)value);
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

