/*
 * Decompiled with CFR 0.152.
 */
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleSpecsBase;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import java.awt.Color;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;

public class StyleSheetExtension
extends StyleSpecsBase {
    private static final Name LIST = Name.get((String)"list");
    private static final Name COUNTER = Name.get((String)"counter");
    private static final Name STYLE = Name.get((String)"style");
    private static final Name T = Name.get((String)"t");
    private static HashMap listToSet = new HashMap();

    public StyleSheetExtension(String[] args, StyledViewFactory viewFactory) {
    }

    public StyleValue listItemCounter(StyleValue[] args, Node contextNode, StyledViewFactory viewFactory) {
        String format = StyleSheetExtension.listFormat((Element)contextNode);
        int index = StyleSheetExtension.indexOfListItem((Element)contextNode);
        return StyleValue.createString((String)StyleSheetExtension.formatCounter(format, 1 + index));
    }

    private static String listFormat(Element listItem) {
        Element list = listItem.getParentElement();
        if (list == null || list.getName() != LIST) {
            return "";
        }
        String format = list.getTokenAttribute(STYLE, "empty");
        if ("numbers".equals(format)) {
            return "%d.";
        }
        if ("letters".equals(format)) {
            return "%c.";
        }
        if (format.length() > 7 && "format ".equals(format.substring(0, 7))) {
            return format.substring(7);
        }
        return "?" + format + "?%c";
    }

    private static String formatCounter(String format, int index) {
        int i = format.indexOf("%");
        if (i == -1 || i + 1 == format.length()) {
            return format;
        }
        String ret = format.substring(0, i);
        switch (format.charAt(i + 1)) {
            case 'd': {
                ret = ret + Integer.toString(index);
                break;
            }
            case 'c': {
                if (index > 26 && index <= 702) {
                    ret = ret + "abcdefghijklmnopqrstuvwxyz".charAt((index - 1) / 26 - 1);
                    index -= (index - 1) / 26 * 26;
                }
                if (index <= 26) {
                    ret = ret + "abcdefghijklmnopqrstuvwxyz".charAt(index - 1);
                    break;
                }
            }
            default: {
                ret = ret + "?%" + format.charAt(i + 1) + Integer.toString(index) + "?";
            }
        }
        ret = ret + format.substring(i + 2);
        return ret;
    }

    private static TreeSet setForList(Element list) {
        String format = list.getTokenAttribute(STYLE, "empty");
        format = format.length() > 7 && "format ".equals(format.substring(0, 7)) ? format.substring(7) : null;
        String counter = list.getNmtokenAttribute(COUNTER, format);
        if (counter == null) {
            return null;
        }
        TreeSet<Element> set = (TreeSet<Element>)listToSet.get(counter);
        if (set == null) {
            set = new TreeSet<Element>();
            listToSet.put(counter, set);
        }
        set.add(list);
        return set;
    }

    private static int indexOfListItem(Element listItem) {
        Element list = listItem.getParentElement();
        if (list == null || list.getName() != LIST) {
            return -1;
        }
        int index = list.indexOfChildElement(listItem);
        int offset = 0;
        TreeSet set = StyleSheetExtension.setForList(list);
        if (set != null && set.size() > 1) {
            SortedSet<Element> head = set.headSet(list);
            for (Element list2 : head) {
                Element last = list2.getLastChildElement();
                if (last == null) continue;
                offset += list2.indexOfChildElement(last) + 1;
            }
        }
        return offset + index;
    }

    public StyleValue pickcolor(StyleValue[] args, Node contextNode, StyledViewFactory viewFactory) {
        float b;
        float s;
        String cref = contextNode.attributeValue(Name.get((String)"source"));
        if (cref == null || "".equals(cref)) {
            if (args.length > 0 && "dark".equals(args[0].stringValue())) {
                return StyleValue.createColor((Color)StyleValue.parseColor((String)"black"));
            }
            return StyleValue.createColor((Color)StyleValue.parseColor((String)"yellow"));
        }
        byte[] hash = this.MD5(cref);
        float h = StyleSheetExtension.mapByteIntoRange(0.0f, 1.0f, hash[0]);
        if (args.length > 0 && "dark".equals(args[0].stringValue())) {
            s = StyleSheetExtension.mapByteIntoRange(0.45f, 0.6f, hash[1]);
            b = StyleSheetExtension.mapByteIntoRange(0.3f, 0.4f, hash[2]);
        } else {
            s = StyleSheetExtension.mapByteIntoRange(0.2f, 0.4f, hash[1]);
            b = StyleSheetExtension.mapByteIntoRange(0.92f, 0.99f, hash[2]);
        }
        return StyleValue.createColor((Color)Color.getHSBColor(h, s, b));
    }

    public byte[] MD5(String text) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
            md.update(text.getBytes("iso-8859-1"), 0, text.length());
        }
        catch (Exception e) {
            return new byte[]{0, 0, 0};
        }
        return md.digest();
    }

    public static float mapByteIntoRange(float low, float high, byte value) {
        return (low + high) / 2.0f + (float)value * (high - low) / 254.0f;
    }
}

