/* XMLPPM: an XML compressor
Copyright (C) 2003 James Cheney

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contacting the author:
James Cheney
Computer Science Department
Cornell University
Ithaca, NY 14850

jcheney@cs.cornell.edu
*/


/****************************************************************************
 *  This file is part of PPMd project                                       *
 *  Contents: 'Carryless rangecoder' by Dmitry Subbotin                     *
 *  Comments: this implementation is claimed to be a public domain          *
 ****************************************************************************/
/* Changes 1/2003 by James Cheney to interface to XMLPPM
 * Changes 3/2003 by Hedzer Westra to interface to XMill
 */
#ifndef __CODER_HPP_
#define __CODER_HPP_

class PPMDI;

struct SUBRANGE {
    DWORD LowCount, HighCount, scale;
};
const DWORD TOP=1 << 24, BOT=1 << 15;

class PPMDIData 
{
public:
   PPMDI *fp;
   SUBRANGE SubRange;
   DWORD low, code, range;
   int allocsize;

   SubAlloc *alloc;

   PPMDIData(PPMDI *fp = NULL);
   ~PPMDIData();

   void dropAlloc();

   SubAlloc *getAlloc(int size);
   SubAlloc *getAlloc();

   PPMDI *getFp();
   void setFp(PPMDI *d);

   void ariInitEncoder ();
   void ariInitDecoder ();
   void ariFlushEncoder ();
   void ariEncodeSymbol();
   void ariShiftEncodeSymbol(UINT SHIFT);
   int ariGetCurrentCount();
   UINT ariGetCurrentShiftCount(UINT SHIFT);
   void ariRemoveSubrange();
 };

#define ARI_ENC_NORMALIZE(stream) {                                         \
    while ((data->low ^ (data->low+data->range)) < TOP || data->range < BOT && \
            ((data->range= -(data->low) & (BOT-1)),1)) {                    \
        stream->_putc(data->low >> 24);                                     \
        data->range <<= 8;                                                  \
        data->low <<= 8;                                                    \
    }                                                                       \
}

/* end-of-block: EOF for the current block. decompress should be restarted after new data is loaded */
#define EOB (-2)

#endif
