/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      11/30/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//**************************************************************************
//**************************************************************************

#include "stdafx.h"

#ifdef WIN32
int _cdecl main(int argc,char **argv)
#else
int main(int argc,char **argv)
#endif
{
   int fileidx;
	XMill *xmill = new XMill("");
#ifdef XMILL
	bool compress = true;
#else
	bool compress = false;
	xmill->session->xmloutput = new XMLStringOutput(xmill->settings);
#endif
	/* PrintCompressor prints to screen */
	xmill->settings->setPrintCompressorException(FALSE);

	// We set the default file mode to 'binary'
#ifdef WIN32
   _fmode=_O_BINARY;
#endif

   if(argc==1) // No arguments for the program?
   {
      xmill->session->PrintUsage(0);
      return 0;
   }
   
#ifdef XMILL
   else
   {
      if((argc==2)&&(strcmp(argv[1],"-h")==0))
         // Is there is exactly one argument '-h' ?
      {
         xmill->session->PrintUsage(1);
         return 0;
      }
   }
#endif /* XMILL */

   // Now we start the heavy work!

   try {
#ifdef XDEMILL
		xmill->session->globaldlabeldict->Init(); // Initialize the label dictionary
#endif

#ifdef XMILL
		xmill->session->globalclabeldict->Init(); // Initialize the label dictionary

      // Initializes the FSM structures.
      // It creates two labels '#' and '@#'
      xmill->session->FSMInit();

#ifdef USE_FORWARD_DATAGUIDE
extern void InitForwardDataGuide();
      InitForwardDataGuide();
#endif

#endif /* XMILL */

      // Parse options
      fileidx=xmill->session->settings->HandleAllOptions(argv+1,argc-1)+1;

#ifdef XMILL
      // In the compressor, we append two default paths: '//#' and '/'
      // to take care of all paths
      char *pathptr="//#";
      xmill->session->cpathexprman->AddNewVPathExpr(pathptr,pathptr+strlen(pathptr));
      pathptr="/";
      xmill->session->cpathexprman->AddNewVPathExpr(pathptr,pathptr+strlen(pathptr));

      xmill->session->globalclabeldict->FinishedPredefinedLabels();
         // We remember which labels are predefined (i.e. labels defined through FSMs)
         // All labels that are inserted later will be eliminated
         // between two parses of two input files.

	   xmill->session->cpathexprman->InitWhitespaceHandling();
         // If the default white space handling for the path expression
         // is the global setting, then we replace that reference
         // by the global default value.
         // This is done after all options are parsed,
         // since the global white space options could come *after*
         // the path expressions have been inserted.
#endif /* XMILL */

      // Are there no arguments except options?
	   if (fileidx>=argc) {
		   if (!xmill->settings->usestdout) { // Did the user specify '-c' for using 'stdout'?
            throw new XMillException (XMILL_ERR_ARGUMENTS, "No input file specified! Specify '-c' to use stdin/stdout");
         }
#ifdef XMILL
            xmill->Compress(NULL,NULL);
#endif
#ifdef XDEMILL
            xmill->Uncompress(NULL,NULL);
#endif
		   return 0;
	   }

      // Let's look at all files
      do
      {
         xmill->settings->HandleFileArg(xmill, argv[fileidx], compress);
         if(xmill->settings->skip_all_files)
            break;
         fileidx++;
      } while (fileidx<argc);
   } catch (XMillException *e) {
      // An error occurred
		e->PrintErrorMsg();
      delete e;
      return 1;
   }

   return 0;
}
