/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//**************************************************************************
//**************************************************************************

// This module implements 'Compressor' and 'Uncompressor' -
// the interfaces to the ZLIB (either gzip or bzip) libary

#include "stdafx.h"

Zipper* Zipper::NewZipper(char ziptype, int idx, bool iscomp)
{
	switch (ziptype) {
		case XMILL_GPC_BZIP:
			return new BZip(idx, iscomp);
		case XMILL_GPC_GZIP:
			return new GZip(idx, iscomp);
		case XMILL_GPC_NONE:
			return new NoZip(idx, iscomp);
		case XMILL_GPC_PPMDI:
			return new PPMDI(idx, iscomp);
	}
	return NULL;
}

Zipper::Zipper(int i, bool iscomp)
{
	idx = i;
	is_compressing = iscomp;
}

Zipper::~Zipper() 
{
	if (is_compressing) {
		endCompress();
	}
}

void Zipper::resetCompress() 
{
	endCompress();
}

bool Zipper::needsReInit()
{
	return false;
}

