/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import xjavadoc.AbstractProgramElement;
import xjavadoc.Util;
import xjavadoc.XClass;
import xjavadoc.XConstructor;
import xjavadoc.XField;
import xjavadoc.XJavaDoc;
import xjavadoc.XMember;
import xjavadoc.XMethod;
import xjavadoc.XPackage;
import xjavadoc.XProgramElement;
import xjavadoc.XTagFactory;

public abstract class AbstractClass
extends AbstractProgramElement
implements XClass {
    private List _declaredInterfaces;
    private List _allInterfaces;
    private List _importedClasses;
    private List _importedClassNames;
    private List _importedPackages;
    private List _constructors;
    private Map _namedConstructors;
    private List _methods;
    private HashMap _namedMethods;
    private List _fields;
    private List _innerClasses;
    private XPackage _containingPackage;
    private boolean _isInterface;
    private boolean _isAnonymous = false;
    private XClass _superclass;
    private int _hash = Integer.MIN_VALUE;
    private List _directSubclasses;
    private List _allSubclasses;
    private List _implementingClasses;
    private List _extendingInterfaces;
    private String _name;
    private String _transformedName;
    private String _qualifiedName;
    private String _transformedQualifiedName;

    protected AbstractClass(AbstractClass containingClass, XTagFactory tagFactory) {
        super(containingClass, tagFactory);
    }

    protected AbstractClass(XJavaDoc xJavaDoc, XTagFactory tagFactory) {
        super(xJavaDoc, tagFactory);
    }

    public final boolean isInterface() {
        return this._isInterface;
    }

    public final boolean isA(String full_qualified_type_name) {
        return this.isA(full_qualified_type_name, true);
    }

    public final boolean isA(String full_qualified_type_name, boolean superclasses) {
        boolean sameClass = this.getQualifiedName().equals(full_qualified_type_name);
        boolean subClass = this.isSubclassOf(full_qualified_type_name, superclasses);
        boolean implementz = this.isImplementingInterface(full_qualified_type_name, superclasses);
        return sameClass || subClass || implementz;
    }

    public final XMethod getMethod(String methodNameWithSignature) {
        return this.getMethod(methodNameWithSignature, false);
    }

    public final XMethod getMethod(String methodNameWithSignature, boolean superclasses) {
        XClass superclass;
        XMethod result = null;
        this.initializeNamedMethodsHashMap();
        if (this._namedMethods != null) {
            result = (XMethod)this._namedMethods.get(methodNameWithSignature);
        }
        if (result == null && superclasses && (superclass = this.getSuperclass()) != null) {
            result = superclass.getMethod(methodNameWithSignature, true);
        }
        return result;
    }

    public final XConstructor getConstructor(String constructorNameWithSignature) {
        this.initializeNamedConstructorsHashMap();
        if (this._namedConstructors != null) {
            return (XConstructor)this._namedConstructors.get(constructorNameWithSignature);
        }
        return null;
    }

    public final XField getField(String fieldName) {
        if (this._fields == null) {
            return null;
        }
        for (int i = 0; i < this._fields.size(); ++i) {
            XField field = (XField)this._fields.get(i);
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public final List getImportedClasses() {
        return this._importedClasses == null ? AbstractProgramElement.EMPTY_LIST : Collections.unmodifiableList(this._importedClasses);
    }

    public final List getImportedPackages() {
        return this._importedPackages == null ? AbstractProgramElement.EMPTY_LIST : Collections.unmodifiableList(this._importedPackages);
    }

    public final List getMethods() {
        return this.getMethods(false);
    }

    public final List getMethods(Predicate predicate, boolean superclasses) {
        return Collections.unmodifiableList(new ArrayList(CollectionUtils.select((Collection)this.getMethods(superclasses), (Predicate)predicate)));
    }

    public final List getFields(Predicate predicate, boolean superclasses) {
        return Collections.unmodifiableList(new ArrayList(CollectionUtils.select((Collection)this.getFields(superclasses), (Predicate)predicate)));
    }

    public final List getMethods(boolean superclasses) {
        return this.getMembers(superclasses, false);
    }

    public final List getFields(boolean superclasses) {
        return this.getMembers(superclasses, true);
    }

    public final List getFields() {
        return this._fields == null ? AbstractProgramElement.EMPTY_LIST : Collections.unmodifiableList(this._fields);
    }

    public final List getConstructors() {
        return this._constructors == null ? AbstractProgramElement.EMPTY_LIST : Collections.unmodifiableList(this._constructors);
    }

    public final boolean isSubclassOf(String full_qualified_type_name) {
        return this.isSubclassOf(full_qualified_type_name, true);
    }

    public final boolean isImplementingInterface(String full_qualified_type_name) {
        return this.isImplementingInterface(full_qualified_type_name, true);
    }

    public String getType() {
        return this.getQualifiedName() + ".class";
    }

    public boolean isInner() {
        boolean hasContainingClass = this.getContainingClass() != null;
        return hasContainingClass;
    }

    public boolean isSubclassOf(String full_qualified_type_name, boolean superclasses) {
        XClass superclass = this.getSuperclass();
        if (superclass == null) {
            return false;
        }
        do {
            if (superclass.getQualifiedName().equals(full_qualified_type_name)) {
                return true;
            }
            superclass = superclass.getSuperclass();
        } while (superclasses && superclass != null);
        return false;
    }

    public boolean isImplementingInterface(String full_qualified_type_name, boolean superclasses) {
        XClass cur_class = this;
        do {
            Iterator iterator = cur_class.getInterfaces().iterator();
            while (iterator.hasNext()) {
                XClass intf = (XClass)iterator.next();
                if (!intf.getQualifiedName().equals(full_qualified_type_name) && !intf.isImplementingInterface(full_qualified_type_name, superclasses)) continue;
                return true;
            }
            cur_class = cur_class.getSuperclass();
        } while (superclasses && cur_class != null);
        return false;
    }

    public String getName() {
        return this._name;
    }

    public String getQualifiedName() {
        return this._qualifiedName;
    }

    public String getTransformedName() {
        return this._transformedName;
    }

    public String getTransformedQualifiedName() {
        return this._transformedQualifiedName;
    }

    public List getInterfaces() {
        if (this._allInterfaces == null) {
            HashSet allInterfaces = new HashSet();
            if (this._declaredInterfaces != null) {
                allInterfaces.addAll(this._declaredInterfaces);
                Iterator i = this._declaredInterfaces.iterator();
                while (i.hasNext()) {
                    XClass intf = (XClass)i.next();
                    allInterfaces.addAll(intf.getInterfaces());
                }
            }
            for (XClass superclass = this.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
                allInterfaces.addAll(superclass.getInterfaces());
            }
            this._allInterfaces = Arrays.asList(allInterfaces.toArray());
        }
        return this._allInterfaces;
    }

    public Collection getDeclaredInterfaces() {
        return this._declaredInterfaces != null ? this._declaredInterfaces : AbstractProgramElement.EMPTY_LIST;
    }

    public XClass getSuperclass() {
        return this._superclass;
    }

    public List getDirectSubclasses() {
        if (this.isInterface()) {
            throw new UnsupportedOperationException("Should never ask for directSubclasses of interfaces. Ask for implementingClasses or extendingInterfaces instead");
        }
        if (this._directSubclasses == null) {
            this._directSubclasses = new LinkedList();
            Iterator classes = this.getXJavaDoc().getSourceClasses().iterator();
            while (classes.hasNext()) {
                XClass clazz = (XClass)classes.next();
                if (clazz.getSuperclass() != this) continue;
                this._directSubclasses.add(clazz);
            }
        }
        return Collections.unmodifiableList(this._directSubclasses);
    }

    public List getAllSubclasses() {
        if (this.isInterface()) {
            throw new UnsupportedOperationException("Should never ask for allSubclasses of interfaces. Ask for implementingClasses or extendingInterfaces instead");
        }
        if (this._allSubclasses == null) {
            this._allSubclasses = new LinkedList();
            Iterator classes = this.getXJavaDoc().getSourceClasses().iterator();
            block0: while (classes.hasNext()) {
                for (XClass clazz = (XClass)classes.next(); clazz != null; clazz = clazz.getSuperclass()) {
                    if (clazz.getSuperclass() != this) continue;
                    this._allSubclasses.add(clazz);
                    continue block0;
                }
            }
        }
        return Collections.unmodifiableList(this._allSubclasses);
    }

    public List getImplementingClasses() {
        if (!this.isInterface()) {
            throw new UnsupportedOperationException("Should never ask for implementingClasses of classes. Ask for directSubclasses or allSubclasses instead");
        }
        if (this._implementingClasses == null) {
            this._implementingClasses = new LinkedList();
            Iterator classes = this.getXJavaDoc().getSourceClasses().iterator();
            while (classes.hasNext()) {
                List interfaces;
                XClass clazz = (XClass)classes.next();
                if (clazz.isInterface() || !(interfaces = clazz.getInterfaces()).contains(this)) continue;
                this._implementingClasses.add(clazz);
            }
        }
        return Collections.unmodifiableList(this._implementingClasses);
    }

    public List getExtendingInterfaces() {
        if (!this.isInterface()) {
            throw new UnsupportedOperationException("Should never ask for extendingInterfaces of classes. Ask for directSubclasses or allSubclasses instead");
        }
        if (this._extendingInterfaces == null) {
            this._extendingInterfaces = new LinkedList();
            Iterator classes = this.getXJavaDoc().getSourceClasses().iterator();
            while (classes.hasNext()) {
                List interfaces;
                XClass clazz = (XClass)classes.next();
                if (!clazz.isInterface() || !(interfaces = clazz.getInterfaces()).contains(this)) continue;
                this._extendingInterfaces.add(clazz);
            }
        }
        return Collections.unmodifiableList(this._extendingInterfaces);
    }

    public XPackage getContainingPackage() {
        if (this._containingPackage == null) {
            this._containingPackage = this.getXJavaDoc().addPackageMaybe("");
        }
        return this._containingPackage;
    }

    public List getInnerClasses() {
        return this._innerClasses == null ? AbstractProgramElement.EMPTY_LIST : Collections.unmodifiableList(this._innerClasses);
    }

    public XProgramElement getSuperElement() {
        return this.getSuperclass();
    }

    public List getSuperInterfaceElements() {
        return this.getInterfaces();
    }

    public boolean isAnonymous() {
        return this._isAnonymous;
    }

    public List getMethodTags(String tagName, boolean superclasses) {
        HashSet result = new HashSet();
        Iterator methods = this.getMethods(superclasses).iterator();
        while (methods.hasNext()) {
            XMethod method = (XMethod)methods.next();
            result.addAll(method.getDoc().getTags(tagName, superclasses));
        }
        return new ArrayList(result);
    }

    public final int compareTo(Object o) {
        XClass other = (XClass)o;
        return this.getQualifiedName().compareTo(other.getQualifiedName());
    }

    public final String toString() {
        return this.getQualifiedName();
    }

    public String save(File rootDir) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XClass)) {
            return false;
        }
        XClass other_clazz = (XClass)obj;
        return this.getQualifiedName().equals(other_clazz.getQualifiedName());
    }

    public int hashCode() {
        if (this._hash == Integer.MIN_VALUE) {
            this._hash += this.getQualifiedName().hashCode();
        }
        return this._hash;
    }

    public XClass qualify(String unqualifiedClassName) {
        return this.getXJavaDoc().getXClass(unqualifiedClassName);
    }

    public long lastModified() {
        return Long.MIN_VALUE;
    }

    public void updateDoc() {
        super.updateDoc();
        Iterator i = this.getFields().iterator();
        while (i.hasNext()) {
            ((XField)i.next()).updateDoc();
        }
        i = this.getMethods().iterator();
        while (i.hasNext()) {
            ((XMethod)i.next()).updateDoc();
        }
        i = this.getConstructors().iterator();
        while (i.hasNext()) {
            ((XConstructor)i.next()).updateDoc();
        }
        i = this.getInnerClasses().iterator();
        while (i.hasNext()) {
            ((XClass)i.next()).updateDoc();
        }
    }

    protected final boolean hasImportedClasses() {
        return this._importedClasses != null;
    }

    protected final boolean hasInnerClasses() {
        return this._innerClasses != null;
    }

    protected final boolean hasImportedPackages() {
        return this._importedPackages != null;
    }

    protected void addInnerClass(XClass clazz) {
        if (this._innerClasses == null) {
            this._innerClasses = new LinkedList();
        }
        this._innerClasses.add(clazz);
    }

    final void setQualifiedName(String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("qualifiedName can't be null!");
        }
        if (qualifiedName.startsWith(".")) {
            throw new IllegalArgumentException("qualifiedName can't start with a dot! " + qualifiedName);
        }
        if (this._qualifiedName != null) {
            throw new IllegalStateException("Setting qualified name " + qualifiedName + " from " + this._qualifiedName + " 2nd time!");
        }
        if (this.isInner()) {
            throw new IllegalStateException("Don't call setQualifiedName for inner classes. Call setName instead. (" + qualifiedName + ")");
        }
        this._qualifiedName = qualifiedName;
        this._transformedQualifiedName = qualifiedName;
        this._transformedName = this._name = Util.classNameFromQualifiedClassName(this._qualifiedName);
    }

    final void setContainingPackage(String containingPackage) {
        this._containingPackage = this.getXJavaDoc().addPackageMaybe(containingPackage);
    }

    final void setInterface(boolean flag) {
        this._isInterface = flag;
        this._superclass = null;
    }

    final void setSuperclass(String superclass) {
        this._superclass = this.qualify(superclass);
    }

    final void setRealised(String clazz) {
        this._isAnonymous = true;
        XClass realised = this.qualify(clazz);
        if (realised.isInterface()) {
            this.addInterface(clazz);
            this.setSuperclass("java.lang.Object");
        } else {
            this.setSuperclass(clazz);
        }
    }

    void setName(String name) {
        if (!this.isInner()) {
            throw new IllegalStateException("Don't call setName for outer classes. Call setQualifiedName instead. (" + name + ")");
        }
        if (name == null) {
            throw new IllegalStateException("name can't be null!");
        }
        String realName = this.getContainingClass().getName() + '.' + name;
        String transformedName = this.getContainingClass().getTransformedName() + '$' + name;
        if (this._name != null && !this._name.equals(realName)) {
            throw new IllegalStateException("Setting name 2nd time with a different value! 1st time: '" + this._name + "', 2nd time: '" + name + "'");
        }
        this._name = realName;
        this._transformedName = transformedName;
        if (this.getContainingPackage().getName().equals("")) {
            this._qualifiedName = this._name;
            this._transformedQualifiedName = this._transformedName;
        } else {
            this._qualifiedName = this.getContainingPackage().getName() + '.' + this._name;
            this._transformedQualifiedName = this.getContainingPackage().getName() + '.' + this._transformedName;
        }
        if (this._qualifiedName.startsWith(".")) {
            throw new IllegalStateException("qualifiedName can't start with a dot! " + this._qualifiedName);
        }
    }

    final void addInterface(String interfaceName) {
        if (this._declaredInterfaces == null) {
            this._declaredInterfaces = new LinkedList();
        }
        XClass qualifiedInterface = this.qualify(interfaceName);
        this._declaredInterfaces.add(qualifiedInterface);
    }

    void resolveImportedClasses() {
        if (this._importedClassNames == null) {
            return;
        }
        if (this._importedClasses == null) {
            this._importedClasses = new ArrayList(this._importedClassNames.size());
            Iterator i = this._importedClassNames.iterator();
            while (i.hasNext()) {
                String importedClassName = (String)i.next();
                this._importedClasses.add(this.qualify(importedClassName));
            }
        }
    }

    void addImportedClass(String importedClass) {
        if (this._importedClassNames == null) {
            this._importedClassNames = new LinkedList();
        }
        this._importedClassNames.add(importedClass);
    }

    void addImportedPackage(String importedPackage) {
        if (this._importedPackages == null) {
            this._importedPackages = new LinkedList();
        }
        XPackage pakkage = this.getXJavaDoc().addPackageMaybe(importedPackage);
        this._importedPackages.add(pakkage);
    }

    void addConstructor(XConstructor constructor) {
        this.validate(constructor);
        if (this._constructors == null) {
            this._constructors = new LinkedList();
        }
        this._constructors.add(constructor);
    }

    void addField(XField field) {
        this.validate(field);
        if (this._fields == null) {
            this._fields = new LinkedList();
        }
        this._fields.add(field);
    }

    void addMethod(XMethod method) {
        this.validate(method);
        if (this._methods == null) {
            this._methods = new LinkedList();
        }
        this._methods.add(method);
    }

    void reset() {
        super.reset();
        this._declaredInterfaces = null;
        this._allInterfaces = null;
        this._importedClasses = null;
        this._importedClassNames = null;
        this._importedPackages = null;
        this._constructors = null;
        this._namedConstructors = null;
        this._methods = null;
        this._namedMethods = null;
        this._fields = null;
        this._innerClasses = null;
    }

    private final List getMembers(boolean superclasses, boolean forFields) {
        AbstractClass superclass;
        if (!superclasses) {
            if (forFields) {
                return this._fields == null ? AbstractProgramElement.EMPTY_LIST : Collections.unmodifiableList(this._fields);
            }
            return this._methods == null ? AbstractProgramElement.EMPTY_LIST : Collections.unmodifiableList(this._methods);
        }
        LinkedList<XMember> members = new LinkedList<XMember>();
        if (forFields) {
            if (this._fields != null) {
                members.addAll(this._fields);
            }
        } else if (this._methods != null) {
            members.addAll(this._methods);
        }
        if ((superclass = (AbstractClass)this.getSuperclass()) != null) {
            List superMembers = superclass.getMembers(true, forFields);
            Iterator m = superMembers.iterator();
            while (m.hasNext()) {
                XMember superMember = (XMember)m.next();
                if (superMember.isPrivate() || members.contains(superMember)) continue;
                members.add(superMember);
            }
        }
        List interfaces = this.getInterfaces();
        Iterator i = interfaces.iterator();
        while (i.hasNext()) {
            AbstractClass interfaze = (AbstractClass)i.next();
            List interfaceMembers = interfaze.getMembers(false, forFields);
            Iterator m = interfaceMembers.iterator();
            while (m.hasNext()) {
                XMember interfaceMember = (XMember)m.next();
                if (members.contains(interfaceMember)) continue;
                members.add(interfaceMember);
            }
        }
        return Collections.unmodifiableList(members);
    }

    private final void validate(XMember member) throws IllegalStateException {
        if (member.getName() == null) {
            throw new IllegalStateException("Trying to add a member with no name:" + member.getClass().getName() + ":" + this.hashCode());
        }
    }

    private void initializeNamedMethodsHashMap() {
        if (this._namedMethods != null || this._methods == null) {
            return;
        }
        this._namedMethods = new HashMap();
        for (int i = 0; i < this._methods.size(); ++i) {
            XMethod method = (XMethod)this._methods.get(i);
            this._namedMethods.put(method.getNameWithSignature(false), method);
        }
    }

    private void initializeNamedConstructorsHashMap() {
        if (this._namedConstructors != null || this._constructors == null) {
            return;
        }
        this._namedConstructors = new HashMap();
        for (int i = 0; i < this._constructors.size(); ++i) {
            XConstructor constructor = (XConstructor)this._constructors.get(i);
            this._namedConstructors.put(constructor.getNameWithSignature(false), constructor);
        }
    }

    public abstract /* synthetic */ boolean saveNeeded();

    public abstract /* synthetic */ void setDirty();

    public abstract /* synthetic */ boolean isWriteable();

    public abstract /* synthetic */ boolean isPrimitive();
}

