/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class NotificationBroadcasterSupport
implements NotificationBroadcaster {
    private Hashtable handbackTable = new Hashtable();
    private Hashtable filterTable = new Hashtable();

    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Listener can't be null");
        }
        Vector<Object> vector = (Vector<Object>)this.handbackTable.get(notificationListener);
        Vector<NotificationFilter> vector2 = (Vector<NotificationFilter>)this.filterTable.get(notificationListener);
        if (vector == null) {
            vector = new Vector<Object>();
            vector2 = new Vector<NotificationFilter>();
            this.handbackTable.put(notificationListener, vector);
            this.filterTable.put(notificationListener, vector2);
        }
        vector.addElement(object);
        vector2.addElement(notificationFilter);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        Vector vector = (Vector)this.handbackTable.get(notificationListener);
        Vector vector2 = (Vector)this.filterTable.get(notificationListener);
        if (vector == null) {
            throw new ListenerNotFoundException("listener");
        }
        this.handbackTable.remove(notificationListener);
        this.filterTable.remove(notificationListener);
    }

    public synchronized void sendNotification(Notification notification) {
        Enumeration enumeration = this.handbackTable.keys();
        while (enumeration.hasMoreElements()) {
            NotificationListener notificationListener = (NotificationListener)enumeration.nextElement();
            Vector vector = (Vector)this.handbackTable.get(notificationListener);
            Vector vector2 = (Vector)this.filterTable.get(notificationListener);
            Enumeration enumeration2 = vector2.elements();
            Enumeration enumeration3 = vector.elements();
            while (enumeration3.hasMoreElements()) {
                Object e = enumeration3.nextElement();
                NotificationFilter notificationFilter = (NotificationFilter)enumeration2.nextElement();
                if (notificationFilter != null && (notificationFilter == null || !notificationFilter.isNotificationEnabled(notification))) continue;
                notificationListener.handleNotification(notification, e);
            }
        }
    }
}

