/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.jdo;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.types.EnumeratedAttribute;
import xdoclet.XDocletException;
import xdoclet.XmlSubTask;
import xdoclet.modules.jdo.JdoDocletTask;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.template.TemplateException;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xjavadoc.XPackage;

public class JdoXmlMetadataSubTask
extends XmlSubTask {
    private static String DEFAULT_TEMPLATE_FILE = "resources/jdo_xml.xdt";
    private static String PACKAGE_GENERATED_FILE_NAME = "{0}.jdo";
    private static String CLASS_GENERATED_FILE_NAME = "{0}.jdo";
    private static String JDOXML_PUBLICID_1_0 = "-//Sun Microsystems, Inc.//DTD Java Data Objects Metadata 1.0//EN";
    private static String JDOXML_SYSTEMID_1_0 = "http://java.sun.com/dtd/jdo_1_0.dtd";
    private static String JDOXML_DTD_FILE_NAME_1_0 = "resources/jdo_1_0.dtd";
    private static String JDOXML_PUBLICID_2_0 = "-//Sun Microsystems, Inc.//DTD Java Data Objects Metadata 2.0//EN";
    private static String JDOXML_SYSTEMID_2_0 = "http://java.sun.com/dtd/jdo_2_0.dtd";
    private static String JDOXML_DTD_FILE_NAME_2_0 = "resources/jdo_2_0.dtd";
    private String jdoSpec = null;
    private String generation = "class";
    private boolean forceGenerationPerPackage;
    private String project = "metadata";
    static /* synthetic */ Class class$xdoclet$modules$jdo$JdoXmlMetadataSubTask;
    static /* synthetic */ Class class$xdoclet$XDocletMessages;

    public JdoXmlMetadataSubTask() {
        this.setTemplateURL(((Object)((Object)this)).getClass().getResource(DEFAULT_TEMPLATE_FILE));
    }

    public String getJdoSpec() {
        if (this.jdoSpec != null) {
            return this.jdoSpec;
        }
        return (String)this.getContext().getConfigParam("jdospec");
    }

    public String getGeneration() {
        return this.generation;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public void setGeneration(GenerationOptionTypes value) {
        this.generation = value.getValue();
    }

    public void setJdoSpec(JdoDocletTask.JdoSpecVersion jdoSpec) {
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$jdo$JdoXmlMetadataSubTask == null ? (class$xdoclet$modules$jdo$JdoXmlMetadataSubTask = JdoXmlMetadataSubTask.class$("xdoclet.modules.jdo.JdoXmlMetadataSubTask")) : class$xdoclet$modules$jdo$JdoXmlMetadataSubTask), (String)"setJdoSpec");
        log.info((Object)("new jdoSpec: " + jdoSpec.getValue()));
        this.jdoSpec = jdoSpec.getValue();
    }

    public void validateOptions() throws XDocletException {
    }

    public void execute() throws XDocletException {
        String jdoSpec = this.getJdoSpec();
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$jdo$JdoXmlMetadataSubTask == null ? (class$xdoclet$modules$jdo$JdoXmlMetadataSubTask = JdoXmlMetadataSubTask.class$("xdoclet.modules.jdo.JdoXmlMetadataSubTask")) : class$xdoclet$modules$jdo$JdoXmlMetadataSubTask), (String)"execute");
        log.info((Object)("Using jdospec \"" + jdoSpec + "\"."));
        if ("2.0".equals(jdoSpec)) {
            this.setPublicId(JDOXML_PUBLICID_2_0);
            this.setSystemId(JDOXML_SYSTEMID_2_0);
            this.setDtdURL(((Object)((Object)this)).getClass().getResource(JDOXML_DTD_FILE_NAME_2_0));
        } else {
            this.setPublicId(JDOXML_PUBLICID_1_0);
            this.setSystemId(JDOXML_SYSTEMID_1_0);
            this.setDtdURL(((Object)((Object)this)).getClass().getResource(JDOXML_DTD_FILE_NAME_1_0));
        }
        if (this.isGenerationPerClass()) {
            this.setDestinationFile(CLASS_GENERATED_FILE_NAME);
        } else if (this.isGenerationPerPackage()) {
            this.setDestinationFile(PACKAGE_GENERATED_FILE_NAME);
        } else {
            this.setDestinationFile(this.getProject() + ".jdo");
        }
        this.startProcess();
    }

    public void startProcess() throws XDocletException {
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$jdo$JdoXmlMetadataSubTask == null ? (class$xdoclet$modules$jdo$JdoXmlMetadataSubTask = JdoXmlMetadataSubTask.class$("xdoclet.modules.jdo.JdoXmlMetadataSubTask")) : class$xdoclet$modules$jdo$JdoXmlMetadataSubTask), (String)"startProcess");
        if (log.isDebugEnabled()) {
            log.debug((Object)("destDir.toString()=" + this.getDestDir()));
            log.debug((Object)("getTemplateURL()=" + this.getTemplateURL()));
            log.debug((Object)("getDestinationfile()=" + this.getDestinationFile()));
            log.debug((Object)("getOfType()=" + this.getOfType()));
            log.debug((Object)("getExtent()=" + this.getExtent()));
            log.debug((Object)("getHavingClassTag()=" + this.getHavingClassTag()));
        }
        if (this.isGenerationPerClass()) {
            this.startProcessPerClass();
        } else if (this.isGenerationPerPackage()) {
            this.startProcessPerPackage();
        } else {
            this.startProcessForAll();
        }
    }

    protected boolean isForceGenerationPerPackage() {
        return this.forceGenerationPerPackage;
    }

    protected boolean isGenerationPerClass() {
        return "class".equals(this.generation);
    }

    protected boolean isGenerationPerPackage() {
        return "package".equals(this.generation);
    }

    protected String getGeneratedFileName(XPackage pak) throws XDocletException {
        int lastSlash;
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$jdo$JdoXmlMetadataSubTask == null ? (class$xdoclet$modules$jdo$JdoXmlMetadataSubTask = JdoXmlMetadataSubTask.class$("xdoclet.modules.jdo.JdoXmlMetadataSubTask")) : class$xdoclet$modules$jdo$JdoXmlMetadataSubTask), (String)"getGeneratedFileName");
        String package_structure = null;
        if (this.isPrefixWithPackageStructure() && (lastSlash = (package_structure = PackageTagsHandler.packageNameAsPathFor((XPackage)pak)).lastIndexOf(47)) != -1) {
            package_structure = package_structure.substring(0, lastSlash);
        }
        String packageName = this.isPackageSubstitutionInheritanceSupported() ? package_structure : null;
        String qualifiedName = pak.getName();
        int lastDot = qualifiedName.lastIndexOf(46);
        String name = qualifiedName.substring(lastDot + 1);
        String destinationFile = MessageFormat.format(this.getDestinationFile(), name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("pak=" + pak));
            log.debug((Object)("packageName=" + packageName));
            log.debug((Object)("destinationFile=" + destinationFile));
        }
        return new File(packageName, destinationFile).toString();
    }

    protected void setForceGenerationPerPackage(boolean value) {
        this.forceGenerationPerPackage = value;
    }

    protected void startProcessPerPackage() throws XDocletException {
        Log log = LogUtil.getLog((Class)(class$xdoclet$modules$jdo$JdoXmlMetadataSubTask == null ? (class$xdoclet$modules$jdo$JdoXmlMetadataSubTask = JdoXmlMetadataSubTask.class$("xdoclet.modules.jdo.JdoXmlMetadataSubTask")) : class$xdoclet$modules$jdo$JdoXmlMetadataSubTask), (String)"startProcessPerPackage");
        if (log.isDebugEnabled()) {
            log.debug((Object)"Per package.");
        }
        Collection packages = this.getXJavaDoc().getSourcePackages();
        Iterator i = packages.iterator();
        while (i.hasNext()) {
            XPackage pakkage = (XPackage)i.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Working on " + pakkage));
            }
            this.generateForPackage(pakkage);
        }
    }

    protected void generateForPackage(XPackage pkg) throws XDocletException {
        Log log = LogUtil.getLog(((Object)((Object)this)).getClass(), (String)"generateForClass");
        String generatedFileName = this.getGeneratedFileName(pkg);
        File file = new File(this.getDestDir().toString(), generatedFileName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("destDir.toString()=" + this.getDestDir().toString()));
            log.debug((Object)("getGeneratedFileName()=" + generatedFileName));
            log.debug((Object)("file=" + file));
        }
        if (file.exists()) {
            log.debug((Object)"File exists.");
            boolean isGenerationNeeded = true;
            if (!isGenerationNeeded) {
                return;
            }
        }
        file.getParentFile().mkdirs();
        try {
            this.setCurrentPackage(pkg);
            this.startEngine(this.getTemplateURL(), new File(this.getDestDir(), generatedFileName));
        }
        catch (TemplateException e) {
            if (e instanceof XDocletException) {
                throw (XDocletException)e;
            }
            log.debug((Object)"generateForClass()");
            throw new XDocletException((Exception)((Object)e), Translator.getString((Class)(class$xdoclet$XDocletMessages == null ? (class$xdoclet$XDocletMessages = JdoXmlMetadataSubTask.class$("xdoclet.XDocletMessages")) : class$xdoclet$XDocletMessages), (String)"RUNNING_FAILED"));
        }
    }

    protected void engineStarted() throws XDocletException {
        String generatedFileName = this.getDestinationFile();
        if (this.isGenerationPerClass()) {
            generatedFileName = this.getGeneratedFileName(this.getCurrentClass());
        } else if (this.isGenerationPerPackage()) {
            generatedFileName = this.getGeneratedFileName(this.getCurrentPackage());
        }
        System.out.println(Translator.getString((Class)(class$xdoclet$XDocletMessages == null ? (class$xdoclet$XDocletMessages = JdoXmlMetadataSubTask.class$("xdoclet.XDocletMessages")) : class$xdoclet$XDocletMessages), (String)"GENERATING_SOMETHING", (String[])new String[]{generatedFileName}));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class GenerationOptionTypes
    extends EnumeratedAttribute {
        public static final String CLASS = "class";
        public static final String PACKAGE = "package";
        public static final String PROJECT = "project";

        public String[] getValues() {
            return new String[]{CLASS, PACKAGE, PROJECT};
        }
    }
}

