/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.mockobjects.util;

import com.mockobjects.Verifiable;
import java.util.Vector;
import junit.framework.Assert;

public class ReturnObjectList
implements Verifiable {
    private final Vector myObjects = new Vector();
    private final String myName;
    private boolean myReuseLast = false;
    private Object myLastObject;

    public ReturnObjectList(String aName) {
        this.myName = aName;
    }

    public void setReuseLast(boolean reuseLast) {
        this.myReuseLast = reuseLast;
    }

    public void add(Object anObjectToReturn) {
        this.myObjects.add(anObjectToReturn);
        if (null == this.myLastObject) {
            this.myLastObject = anObjectToReturn;
        }
    }

    public void add(boolean aBooleanToReturn) {
        this.myObjects.add(new Boolean(aBooleanToReturn));
        if (null == this.myLastObject) {
            this.myLastObject = new Boolean(aBooleanToReturn);
        }
    }

    public void add(int anIntegerToReturn) {
        this.myObjects.add(new Integer(anIntegerToReturn));
        if (null == this.myLastObject) {
            this.myLastObject = new Integer(anIntegerToReturn);
        }
    }

    public boolean hasNext() {
        return this.myReuseLast || this.myObjects.size() > 0;
    }

    public Object next() {
        if (this.myReuseLast && this.myObjects.size() == 0) {
            return this.myLastObject;
        }
        Assert.assertTrue((String)(this.myName + " has run out of objects."), (this.myObjects.size() > 0 ? 1 : 0) != 0);
        return this.myObjects.remove(0);
    }

    public void clear() {
        this.myObjects.clear();
        this.myLastObject = null;
        this.myReuseLast = false;
    }

    public void verify() {
        Assert.assertEquals((String)(this.myName + " has un-used objects."), (int)0, (int)this.myObjects.size());
    }
}

