/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.render;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;

public abstract class Renderer {
    public boolean getRendersChildren() {
        return false;
    }

    public void decode(FacesContext context, UIComponent component) {
        if (null == context || null == component) {
            throw new NullPointerException();
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (null == context || null == component) {
            throw new NullPointerException();
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.encodeBegin(context);
            if (kid.getRendersChildren()) {
                kid.encodeChildren(context);
            }
            kid.encodeEnd(context);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (null == context || null == component) {
            throw new NullPointerException();
        }
    }

    public String convertClientId(FacesContext context, String clientId) {
        if (context == null || clientId == null) {
            throw new NullPointerException();
        }
        return clientId;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        return submittedValue;
    }
}

