/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class ResultSetDataModel
extends DataModel {
    private int current = -1;
    private int index = -1;
    private ResultSetMetaData metadata = null;
    private ResultSet resultSet = null;
    private boolean updated = false;

    public int getRowCount() {
        return -1;
    }

    public int getRowIndex() {
        return this.index;
    }

    public ResultSetDataModel() {
        this(null);
    }

    private void updated() {
        this.updated = true;
    }

    public boolean isRowAvailable() {
        if (this.resultSet == null) {
            return false;
        }
        if (this.index < 0) {
            return false;
        }
        try {
            return this.resultSet.absolute(this.index + 1);
        }
        catch (SQLException e) {
            throw new FacesException(e);
        }
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        if (this.updated && this.resultSet != null) {
            try {
                this.resultSet.updateRow();
                this.updated = false;
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.resultSet == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent(this, this.index, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    public Object getRowData() {
        if (this.resultSet == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        try {
            this.getMetaData();
            return new ResultSetMap(String.CASE_INSENSITIVE_ORDER);
        }
        catch (SQLException e) {
            throw new FacesException(e);
        }
    }

    public Object getWrappedData() {
        return this.resultSet;
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.metadata = null;
            this.resultSet = null;
            this.setRowIndex(-1);
        } else {
            this.metadata = null;
            this.resultSet = (ResultSet)data;
            this.index = -1;
            this.setRowIndex(0);
        }
    }

    public ResultSetDataModel(ResultSet resultSet) {
        this.setWrappedData(resultSet);
    }

    private ResultSetMetaData getMetaData() {
        if (this.metadata == null) {
            try {
                this.metadata = this.resultSet.getMetaData();
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }
        return this.metadata;
    }

    private class ResultSetEntries
    extends AbstractSet {
        private ResultSetMap map;

        public int size() {
            return this.map.size();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if (!this.map.containsKey(k)) {
                return false;
            }
            if (v == null) {
                return this.map.get(k) == null;
            }
            return v.equals(this.map.get(k));
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new ResultSetEntriesIterator(this.map);
        }

        public ResultSetEntries(ResultSetMap map) {
            this.map = map;
        }
    }

    private class ResultSetEntriesIterator
    implements Iterator {
        private ResultSetMap map = null;
        private Iterator keys = null;

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            Object key = this.keys.next();
            return new ResultSetEntry(this.map, key);
        }

        public ResultSetEntriesIterator(ResultSetMap map) {
            this.map = map;
            this.keys = map.keySet().iterator();
        }
    }

    private class ResultSetEntry
    implements Map.Entry {
        private ResultSetMap map;
        private Object key;

        public int hashCode() {
            Object value = this.map.get(this.key);
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.map.get(this.key);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (this.key == null ? e.getKey() != null : !this.key.equals(e.getKey())) {
                return false;
            }
            Object v = this.map.get(this.key);
            return !(v == null ? e.getValue() != null : !v.equals(e.getValue()));
        }

        public Object setValue(Object value) {
            Object previous = this.map.get(this.key);
            this.map.put(this.key, value);
            return previous;
        }

        public ResultSetEntry(ResultSetMap map, Object key) {
            this.map = map;
            this.key = key;
        }
    }

    private class ResultSetKeys
    extends AbstractSet {
        private ResultSetMap map;

        public int size() {
            return this.map.size();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new ResultSetKeysIterator(this.map);
        }

        public ResultSetKeys(ResultSetMap map) {
            this.map = map;
        }
    }

    private class ResultSetKeysIterator
    implements Iterator {
        private ResultSetMap map = null;
        private Iterator keys = null;

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            return this.keys.next();
        }

        public ResultSetKeysIterator(ResultSetMap map) {
            this.map = map;
            this.keys = map.realKeys();
        }
    }

    private class ResultSetMap
    extends TreeMap {
        private int index;

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object value) {
            Iterator keys = this.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                Object contained = this.get(key);
                if (!(value == null ? contained == null : value.equals(contained))) continue;
                return true;
            }
            return false;
        }

        public Collection values() {
            return new ResultSetValues(this);
        }

        Iterator realKeys() {
            return super.keySet().iterator();
        }

        public void putAll(Map map) {
            Iterator keys = map.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                this.put(key, map.get(key));
            }
        }

        public Set entrySet() {
            return new ResultSetEntries(this);
        }

        public Set keySet() {
            return new ResultSetKeys(this);
        }

        public Object get(Object key) {
            if (!this.containsKey(key)) {
                return null;
            }
            try {
                ResultSetDataModel.this.resultSet.absolute(this.index + 1);
                return ResultSetDataModel.this.resultSet.getObject((String)this.realKey(key));
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }

        Object realKey(Object key) {
            return super.get(key);
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public ResultSetMap(Comparator comparator) throws SQLException {
            super(comparator);
            this.index = ResultSetDataModel.this.index;
            ResultSetDataModel.this.resultSet.absolute(this.index + 1);
            int n = ResultSetDataModel.this.metadata.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                super.put(ResultSetDataModel.this.metadata.getColumnName(i), ResultSetDataModel.this.metadata.getColumnName(i));
            }
        }

        public Object put(Object key, Object value) {
            if (!this.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            if (!(key instanceof String)) {
                throw new IllegalArgumentException();
            }
            try {
                ResultSetDataModel.this.resultSet.absolute(this.index + 1);
                Object previous = ResultSetDataModel.this.resultSet.getObject((String)this.realKey(key));
                if (previous == null && value == null) {
                    return previous;
                }
                if (previous != null && value != null && previous.equals(value)) {
                    return previous;
                }
                ResultSetDataModel.this.resultSet.updateObject((String)this.realKey(key), value);
                ResultSetDataModel.this.updated();
                return previous;
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }
    }

    private class ResultSetValues
    extends AbstractCollection {
        private ResultSetMap map;

        public int size() {
            return this.map.size();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object value) {
            return this.map.containsValue(value);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new ResultSetValuesIterator(this.map);
        }

        public ResultSetValues(ResultSetMap map) {
            this.map = map;
        }
    }

    private class ResultSetValuesIterator
    implements Iterator {
        private ResultSetMap map;
        private Iterator keys;

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            return this.map.get(this.keys.next());
        }

        public ResultSetValuesIterator(ResultSetMap map) {
            this.map = map;
            this.keys = map.keySet().iterator();
        }
    }
}

