/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.tiles.util;

import java.lang.reflect.InvocationTargetException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;
import org.apache.struts.tiles.FactoryNotFoundException;
import org.apache.struts.tiles.NoSuchDefinitionException;

public class TagUtils {
    public static final boolean debug = true;

    public static int getScope(String scopeName, int defaultValue) throws JspException {
        if (scopeName == null) {
            return defaultValue;
        }
        if (scopeName.equals("request")) {
            return 2;
        }
        if (scopeName.equals("page")) {
            return 1;
        }
        if (scopeName.equals("session")) {
            return 3;
        }
        if (scopeName.equals("application")) {
            return 4;
        }
        if (scopeName.equals("component")) {
            return 8;
        }
        if (scopeName.equals("template")) {
            return 8;
        }
        if (scopeName.equals("tile")) {
            return 8;
        }
        throw new JspException("Error - scope translation tag : unrecognized scope '" + scopeName + "'");
    }

    public static Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return PropertyUtils.getProperty((Object)bean, (String)name);
    }

    public static Object retrieveBean(String beanName, String scopeName, PageContext pageContext) throws JspException {
        if (scopeName == null) {
            return TagUtils.findAttribute(beanName, pageContext);
        }
        int scope = TagUtils.getScope(scopeName, 1);
        return TagUtils.getAttribute(beanName, scope, pageContext);
    }

    public static Object findAttribute(String beanName, PageContext pageContext) {
        Object attribute;
        ComponentContext compContext = ComponentContext.getContext(pageContext.getRequest());
        if (compContext != null && (attribute = compContext.findAttribute(beanName, pageContext)) != null) {
            return attribute;
        }
        return pageContext.findAttribute(beanName);
    }

    public static Object getAttribute(String beanName, int scope, PageContext pageContext) {
        if (scope == 8) {
            ComponentContext compContext = ComponentContext.getContext(pageContext.getRequest());
            return compContext.getAttribute(beanName);
        }
        return pageContext.getAttribute(beanName, scope);
    }

    public static Object getRealValueFromBean(String beanName, String beanProperty, String beanScope, PageContext pageContext) throws JspException {
        try {
            Object bean = TagUtils.retrieveBean(beanName, beanScope, pageContext);
            Object realValue = bean != null && beanProperty != null ? TagUtils.getProperty(bean, beanProperty) : bean;
            return realValue;
        }
        catch (NoSuchMethodException ex) {
            throw new JspException("Error - component.PutAttributeTag : Error while retrieving value from bean '" + beanName + "' with property '" + beanProperty + "' in scope '" + beanScope + "'. (exception : " + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            throw new JspException("Error - component.PutAttributeTag : Error while retrieving value from bean '" + beanName + "' with property '" + beanProperty + "' in scope '" + beanScope + "'. (exception : " + ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new JspException("Error - component.PutAttributeTag : Error while retrieving value from bean '" + beanName + "' with property '" + beanProperty + "' in scope '" + beanScope + "'. (exception : " + ex.getMessage());
        }
    }

    public static void setAttribute(PageContext pageContext, String name, Object value, String scope) throws JspException {
        if (scope == null) {
            pageContext.setAttribute(name, value, 2);
        } else if (scope.equalsIgnoreCase("page")) {
            pageContext.setAttribute(name, value, 1);
        } else if (scope.equalsIgnoreCase("request")) {
            pageContext.setAttribute(name, value, 2);
        } else if (scope.equalsIgnoreCase("session")) {
            pageContext.setAttribute(name, value, 3);
        } else if (scope.equalsIgnoreCase("application")) {
            pageContext.setAttribute(name, value, 4);
        } else {
            throw new JspException("Error - bad scope name '" + scope + "'");
        }
    }

    public static void setAttribute(PageContext pageContext, String name, Object beanValue) throws JspException {
        pageContext.setAttribute(name, beanValue, 2);
    }

    public static void saveException(PageContext pageContext, Throwable exception) {
        pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)exception, 2);
    }

    public static ComponentDefinition getComponentDefinition(String name, PageContext pageContext) throws JspException {
        try {
            return DefinitionsUtil.getDefinition(name, pageContext);
        }
        catch (NoSuchDefinitionException ex) {
            throw new JspException("Error : Can't get component definition for '" + name + "'. Check if this name exist in component definitions.");
        }
        catch (FactoryNotFoundException ex) {
            throw new JspException(ex.getMessage());
        }
        catch (DefinitionsFactoryException ex) {
            ex.printStackTrace();
            TagUtils.saveException(pageContext, ex);
            throw new JspException(ex.getMessage());
        }
    }

    static {
        debug = true;
    }
}

