/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.NDC;
import webwork.config.Configuration;
import webwork.view.taglib.PageResponse;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;

public class IncludeTag
extends WebWorkBodyTagSupport
implements ParamTag.Parametric {
    private static String encoding;
    private static boolean encodingDefined;
    protected String pageAttr;
    protected String valueAttr;
    protected Map params;

    static {
        encodingDefined = true;
    }

    public void addParameter(String name, Object value) {
        if (value != null) {
            ArrayList<Object> currentValues = (ArrayList<Object>)this.params.get(name);
            if (currentValues == null) {
                currentValues = new ArrayList<Object>();
                this.params.put(name, currentValues);
            }
            currentValues.add(value);
        }
    }

    public int doEndTag() throws JspException {
        String page = this.valueAttr != null ? (String)this.findValue(this.valueAttr) : this.pageAttr;
        StringBuffer urlBuf = new StringBuffer();
        urlBuf.append(page);
        if (this.params.size() > 0) {
            urlBuf.append('?');
            String concat = "";
            Iterator iterator = this.params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object name = entry.getKey();
                List values = (List)entry.getValue();
                int i = 0;
                while (i < values.size()) {
                    urlBuf.append(concat);
                    urlBuf.append(name);
                    urlBuf.append('=');
                    urlBuf.append(URLEncoder.encode(values.get(i).toString()));
                    concat = "&";
                    ++i;
                }
            }
        }
        this.params = null;
        String result = urlBuf.toString();
        try {
            IncludeTag.include(result, ((TagSupport)this).pageContext);
        }
        catch (Exception e) {
            throw new JspTagException(this.toString(e));
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        this.params = new HashMap();
        return super.doStartTag();
    }

    public static String getContextRelativePath(ServletRequest request, String relativePath) {
        if (relativePath.startsWith("/")) {
            return relativePath;
        }
        if (!(request instanceof HttpServletRequest)) {
            return relativePath;
        }
        HttpServletRequest hrequest = (HttpServletRequest)request;
        String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (uri == null) {
            uri = hrequest.getServletPath();
        }
        return String.valueOf(uri.substring(0, uri.lastIndexOf(47))) + '/' + relativePath;
    }

    private static String getEncoding() {
        block2: {
            if (!encodingDefined) break block2;
            try {
                encoding = Configuration.getString("webwork.i18n.encoding");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                encoding = System.getProperty("file.encoding");
                encodingDefined = false;
            }
        }
        return encoding;
    }

    public static void include(String aResult, PageContext aContext) throws ServletException, IOException {
        block4: {
            String resourcePath = IncludeTag.getContextRelativePath(aContext.getRequest(), aResult);
            RequestDispatcher rd = aContext.getRequest().getRequestDispatcher(resourcePath);
            if (rd == null) {
                throw new ServletException("Not a valid resource path:" + resourcePath);
            }
            try {
                NDC.push((String)resourcePath);
                PageResponse pageResponse = new PageResponse((HttpServletResponse)aContext.getResponse());
                rd.include((ServletRequest)((HttpServletRequest)aContext.getRequest()), (ServletResponse)pageResponse);
                String encoding = IncludeTag.getEncoding();
                if (encoding != null) {
                    aContext.getOut().write(new String(pageResponse.getContent(), encoding));
                    break block4;
                }
                aContext.getOut().write(new String(pageResponse.getContent()));
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                NDC.pop();
                throw throwable;
            }
        }
        Object var5_6 = null;
        NDC.pop();
    }

    public void setPage(String aPage) {
        this.pageAttr = aPage;
    }

    public void setValue(String aName) {
        this.valueAttr = aName;
    }
}

