/*
 * Decompiled with CFR 0.152.
 */
package webwork.util;

import java.util.HashMap;
import java.util.Map;
import webwork.util.QuerySegment;

public class Query {
    static Map queries = new HashMap();
    private static final char LPAREN = '(';
    private static final char RPAREN = ')';
    private static final char RBRACE = '}';
    private static final char LBRACE = '{';
    private static final char LBRACKET = '[';
    private static final char RBRACKET = ']';
    private static final char PARAM = '$';
    private static final char ATTR = '@';
    private static final char SLASH = '/';
    private static final char SQUOTE = '\'';
    private static final char PERIOD = '.';
    private static final char COMMA = ',';
    private QuerySegment[] segments = new QuerySegment[5];
    private int segmentsIdx = 0;
    private String queryString;

    private Query(String queryString) {
        this.queryString = queryString;
        char[] query = this.queryString.toCharArray();
        if (query[0] == '.' && query.length == 1) {
            this.add(new QuerySegment(3));
            return;
        }
        if (query[0] == '\'') {
            if (query[query.length - 1] != '\'') {
                this.throwIllegalArgumentException(query, "missing matching end quote");
            }
            String id = new String(query, 1, query.length - 2);
            this.add(new QuerySegment(id, 0));
            return;
        }
        if (query[0] == '$') {
            String id = new String(query, 1, query.length - 1);
            this.add(new QuerySegment(id, 7));
            return;
        }
        if (query.length == 4 && query[0] == 't' && query[1] == 'r' && query[2] == 'u' && query[3] == 'e') {
            this.add(new QuerySegment(1));
            return;
        }
        if (query.length == 5 && query[0] == 'f' && query[1] == 'a' && query[2] == 'l' && query[3] == 's' && query[4] == 'e') {
            this.add(new QuerySegment(2));
            return;
        }
        if (query[0] < ':' && query[0] > '/' || query[0] == '-' || query[0] == '.') {
            try {
                String s = new String(query, 0, query.length);
                Number val = s.indexOf(46) > 0 ? (Number)new Double(s) : (Number)new Integer(s);
                QuerySegment qs = new QuerySegment(12);
                qs.addValue(val);
                this.add(qs);
                return;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int queryIdx = -1;
        if (query[0] == '@') {
            queryIdx = 1;
            while (queryIdx < query.length && query[queryIdx] != '/' && query[queryIdx] != ']') {
                ++queryIdx;
            }
            String id = new String(query, 1, queryIdx - 1);
            this.add(new QuerySegment(id, 6));
            if (queryIdx == query.length) {
                return;
            }
        } else if (query[0] == '/') {
            queryIdx = 0;
        }
        int[] paramIdxs = new int[10];
        do {
            int lastExprIdx = queryIdx;
            int begParenIdx = -1;
            int begBracketIdx = -1;
            int endBracketIdx = -1;
            int begBraceIdx = -1;
            int endBraceIdx = -1;
            paramIdxs[0] = -1;
            paramIdxs[1] = -1;
            paramIdxs[2] = -1;
            paramIdxs[3] = -1;
            paramIdxs[4] = -1;
            paramIdxs[5] = -1;
            paramIdxs[6] = -1;
            paramIdxs[7] = -1;
            paramIdxs[8] = -1;
            paramIdxs[9] = -1;
            int commaNbr = 0;
            int parenDepth = 0;
            int braceDepth = 0;
            int bracketDepth = 0;
            int squoteDepth = 0;
            while (++queryIdx != query.length) {
                if (query[queryIdx] == '/') {
                    if (parenDepth > 0 || braceDepth > 0 || bracketDepth > 0 || squoteDepth > 0) continue;
                    if (queryIdx != 0) break;
                    this.add(new QuerySegment(5));
                    lastExprIdx = 0;
                    continue;
                }
                if (query[queryIdx] == '(') {
                    ++parenDepth;
                    if (begParenIdx >= 0 || braceDepth != 0 || bracketDepth != 0 || squoteDepth != 0) continue;
                    begParenIdx = queryIdx;
                    continue;
                }
                if (query[queryIdx] == ')') {
                    --parenDepth;
                    paramIdxs[commaNbr] = queryIdx;
                    continue;
                }
                if (query[queryIdx] == '[') {
                    ++bracketDepth;
                    if (begBracketIdx >= 0 || parenDepth != 0 || braceDepth != 0 || squoteDepth != 0) continue;
                    begBracketIdx = queryIdx;
                    continue;
                }
                if (query[queryIdx] == ']') {
                    --bracketDepth;
                    endBracketIdx = queryIdx;
                    continue;
                }
                if (query[queryIdx] == '{') {
                    ++braceDepth;
                    if (begBraceIdx >= 0 || parenDepth != 0 || bracketDepth != 0 || squoteDepth != 0) continue;
                    begBraceIdx = queryIdx;
                    continue;
                }
                if (query[queryIdx] == '}') {
                    --braceDepth;
                    endBraceIdx = queryIdx;
                    continue;
                }
                if (query[queryIdx] == '\'') {
                    if (squoteDepth < 1) {
                        ++squoteDepth;
                        continue;
                    }
                    --squoteDepth;
                    continue;
                }
                if (query[queryIdx] != ',' || parenDepth != 1 || squoteDepth != 0) continue;
                paramIdxs[commaNbr] = queryIdx;
                ++commaNbr;
            }
            if (squoteDepth > 0) {
                this.throwIllegalArgumentException(query, "missing matching end quote");
            }
            if (begBraceIdx > -1) {
                if (endBraceIdx < 0) {
                    this.throwIllegalArgumentException(query, "missing matching brace");
                }
                String id = new String(query, begBraceIdx + 1, endBraceIdx - (begBraceIdx + 1));
                this.add(new QuerySegment(id, 11));
            } else if (begParenIdx > -1) {
                if (paramIdxs[0] < 0) {
                    this.throwIllegalArgumentException(query, "missing matching parenthesis");
                }
                String id = new String(query, lastExprIdx + 1, begParenIdx - (lastExprIdx + 1));
                QuerySegment qs = new QuerySegment(id, 10);
                int paramStart = begParenIdx + 1;
                commaNbr = -1;
                while (paramIdxs[++commaNbr] > -1) {
                    int paramEnd = paramIdxs[commaNbr] - 1;
                    while (paramStart < paramEnd && query[paramStart] <= ' ') {
                        ++paramStart;
                    }
                    while (paramStart < paramEnd && query[paramEnd] <= ' ') {
                        --paramStart;
                    }
                    String parameter = new String(query, paramStart, paramEnd - paramStart + 1);
                    qs.addValue(parameter);
                    paramStart = paramIdxs[commaNbr] + 1;
                }
                this.add(qs);
            } else if (lastExprIdx + 2 < query.length && query[lastExprIdx + 1] == '.' && query[lastExprIdx + 2] == '.') {
                this.add(new QuerySegment(4));
            } else if (lastExprIdx + 1 != begBracketIdx) {
                int propertyEnd = begBracketIdx > -1 ? begBracketIdx : queryIdx;
                String id = new String(query, lastExprIdx + 1, propertyEnd - (lastExprIdx + 1));
                this.add(new QuerySegment(id, 8));
            }
            if (begBracketIdx <= -1) continue;
            if (endBracketIdx < 0) {
                this.throwIllegalArgumentException(query, "missing matching bracket");
            }
            String key = new String(query, begBracketIdx + 1, endBracketIdx - (begBracketIdx + 1));
            this.add(new QuerySegment(key, 9));
        } while (queryIdx < query.length);
    }

    private void add(QuerySegment qs) {
        if (this.segmentsIdx == this.segments.length - 1) {
            QuerySegment[] resize = new QuerySegment[this.segments.length + 5];
            System.arraycopy(this.segments, 0, resize, 0, this.segments.length);
            this.segments = resize;
        }
        this.segments[this.segmentsIdx++] = qs;
    }

    public static Query getQuery(String queryString) {
        Query query = (Query)queries.get(queryString);
        if (query == null) {
            query = new Query(queryString);
            queries.put(queryString, query);
        }
        return query;
    }

    public QuerySegment[] getSegments() {
        return this.segments;
    }

    private Object throwIllegalArgumentException(char[] query, String message) {
        throw new IllegalArgumentException(String.valueOf(message) + " for query: " + new String(query));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("query=\"");
        sb.append(this.queryString);
        sb.append("\"");
        sb.append("\nsegment(s) {");
        int i = 0;
        while (i < this.segments.length) {
            QuerySegment segment = this.segments[i];
            if (segment != null) {
                if (i != 0) {
                    sb.append("\n");
                }
                sb.append(segment);
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }
}

