#ifndef _WIZD_SKIN_H_
#define _WIZD_SKIN_H_

#include "wizd.h"

#define MAX_SKIN_FILESIZE (1024*16)

// ****************
// SKIN_T
// ****************
typedef struct _skin_t {
	char *buffer;
	unsigned long buffer_size;
} SKIN_T;


typedef struct _skin_mapping {
	int filetype;
	char *skin_filename;
} SKIN_MAPPING_T;


// ִѥǡʥХ
typedef struct  {
	unsigned char	current_path_name[WIZD_FILENAME_MAX];	// ѥ ɽ(ʸĴѤ)

	unsigned char	recv_host[256];
	unsigned char	current_directory_name[WIZD_FILENAME_MAX];	// ǥ쥯ȥ ɽ(ʸĴѤ)
	unsigned char	current_directory_link[WIZD_FILENAME_MAX];	// ǥ쥯ȥ LinkѡURI󥳡ɺѤߡ
	unsigned char	current_directory_absolute[FILENAME_MAX];	// ǥ쥯ȥLinkѡURI󥳡ɺѤߡ
	unsigned char	current_directory_link_no_param[WIZD_FILENAME_MAX];	// ǥ쥯ȥ LinkѡURI󥳡ɺѤߡ
	unsigned char	current_directory_link_no_sort[WIZD_FILENAME_MAX];
	unsigned char	current_directory_link_no_option[WIZD_FILENAME_MAX];
	unsigned char	current_directory_link_no_dvdopt[WIZD_FILENAME_MAX];

	unsigned char	parent_directory_name[WIZD_FILENAME_MAX];	// ƥǥ쥯ȥɽ
	unsigned char	parent_directory_link[WIZD_FILENAME_MAX];	// ƥǥ쥯ȥLinkѡURI󥳡ɺѤߡ

	unsigned char	file_num_str[16];	// ǥ쥯ȥΥեɽ
	unsigned char	now_page_str[16];	// ߤΥڡֹɽ
	unsigned char	max_page_str[16];	// ڡֹɽ

	unsigned char	start_file_num_str[16];	// ߥڡɽϥեֹɽ
	unsigned char	end_file_num_str[16];	// ߥڡɽϥեֹɽ

	unsigned char	next_page_str[16];	// Υڡ(̵max_page)ɽ
	unsigned char	prev_page_str[16];	// Υڡ̵ 1)ɽ

	unsigned char	focus[64];			// BODY onloadset="$focus"

	unsigned char	default_photolist[WIZD_FILENAME_MAX];
	unsigned char	default_musiclist[WIZD_FILENAME_MAX];

	int		filename_length_max;

	int		stream_files;	// ǽե
	int		photo_files;
	int		music_files;
	int		stream_dirs;

	int		columns;
	int		items_per_page;
	int		now_page;		// Present page
	int		max_page;		// ڡֹ
	int		now_page_line;	// number of lines
	int		start_file_num;	// start file number of the page
	int		end_file_num;	// ߥڡɽλեֹ

	int		next_page;		// next page if not max page
	int		prev_page;		// Υڡ̵ 1)

	int		delete_mode;		// When true, allow deleting files from client

	// ǥ쥯ȥ
	unsigned char	secret_dir_link_html[512];

	// 饤ȤPCɤ
	int		flag_pc;

	// True when the client is using HD resolution
	int		flag_hd;

	char		default_dir_type[32];
	unsigned char 	request_uri[WIZD_FILENAME_MAX];

} SKIN_REPLASE_GLOBAL_DATA_T;


// ִѥǡʥե
typedef struct  {
	int				menu_file_type;			// եμ

	unsigned char	file_name[255];			// ե̾ɽ(ʸĴѤ)
	unsigned char	file_name_no_ext[255];	// ĥ̵ե̾ɽ(ʸĴѤ)
	unsigned char	file_extension[16];	// ĥҤΤ(ʸĴѤ)

	unsigned char	file_uri_link[WIZD_FILENAME_MAX];	// եؤLink(URI󥳡ɺѤ)
	unsigned char	chapter_link[WIZD_FILENAME_MAX];
	unsigned char	chapter_str[WIZD_FILENAME_MAX];

	unsigned char	file_timestamp[32];		// ॹɽ
	unsigned char	file_timestamp_date[32];	// ॹɽ դΤ
	unsigned char	file_timestamp_time[32];	// ॹɽ Τ
	unsigned char	file_duration[32];	// ॹɽ Τ

	unsigned char	file_size_string[32];	// ե륵ɽ

	unsigned char	svi_info_data[SVI_INFO_LENGTH];	// SVI ե
	unsigned char	svi_rec_time_data[32];			// SVIϿ

	unsigned char	tvid_string[16];	// TVIDɽ
	unsigned char	vod_string[32];		// vod="0" or vod="playlist"  ɬפ˱դ
	int				row_num;		// ֹ

	unsigned char	image_width[16];	// ǡ 
	unsigned char	image_height[16];	// ǡ ⤵


	// MP3 ID3v1 
	unsigned char	mp3_id3v1_flag;			// MP3  ¸ߥե饰
	unsigned char	mp3_id3v1_title[128];	// MP3 ̾
	unsigned char	mp3_id3v1_album[128];	// MP3 Х̾
	unsigned char	mp3_id3v1_artist[128];	// MP3 ƥ
	unsigned char	mp3_id3v1_year[128];		// MP3 ǯ
	unsigned char	mp3_id3v1_comment[128];	// MP3 

	unsigned char	mp3_id3v1_title_info[128*4];			// MP3 ̾[Х̾/ƥ] ޤȤɽ
	unsigned char	mp3_id3v1_title_info_limited[128*4];	// MP3 ̾[Х̾/ƥ] ޤȤɽ(¤)

	unsigned char	mp3_id3v1_genre[128];
	unsigned char	mp3_id3v1_bitrate[128];
	unsigned char	mp3_id3v1_stereo[128];
	unsigned char	mp3_id3v1_frequency[128];
	unsigned char	mp3_id3v1_track[128];

	unsigned char	avi_fps[16];
	unsigned char	avi_duration[32];
	unsigned char	avi_vcodec[128];
	unsigned char	avi_acodec[128];
	unsigned char	avi_hvcodec[128];
	unsigned char	avi_hacodec[128];
	unsigned char	avi_is_interleaved[32];

	/* XXX */
	char			file_image[255];
	/* XXX */

	int				is_current_page;
	unsigned char	info_link[WIZD_FILENAME_MAX];
	unsigned char	html_link[WIZD_FILENAME_MAX];

} SKIN_REPLASE_LINE_DATA_T;



// ImageViewer ִѥǡ
typedef struct  {

	unsigned char	current_uri_name[WIZD_FILENAME_MAX];	// URI ɽ(ʸĴѤ)
	unsigned char	current_uri_link[WIZD_FILENAME_MAX];	// URI LinkѡURI󥳡ɺѤߡ

	unsigned char	parent_directory_link[WIZD_FILENAME_MAX];	// ƥǥ쥯ȥLinkѡURI󥳡ɺѤߡ

	unsigned char	now_page_str[16];	// ߤΥڡֹɽ

	unsigned char	file_timestamp[32];			// ॹɽ()
	unsigned char	file_timestamp_date[32];	// ॹɽ(դΤ)
	unsigned char	file_timestamp_time[32];		// ॹɽ(Τ)
	unsigned char	file_size_string[32];		// ե륵ɽ

	unsigned char	image_width[16];			// ǡ 
	unsigned char	image_height[16];			// ǡ ⤵

	unsigned char	image_viewer_width[16];		// ǡ ɽ
	unsigned char	image_viewer_height[16];	// ǡ ɽ⤵

	unsigned char	image_viewer_mode[16];		// ɽ⡼

} SKIN_REPLASE_IMAGE_VIEWER_DATA_T;

void replase_skin_grobal_data(unsigned char *menu_work_p, int menu_work_buf_size, SKIN_REPLASE_GLOBAL_DATA_T *skin_rep_data_global_p);
void replase_skin_line_data(unsigned char *menu_work_p, int menu_work_buf_size, SKIN_REPLASE_LINE_DATA_T *skin_rep_data_line_p);

SKIN_T *skin_open(char *filename);
void skin_close(SKIN_T *skin);
void skin_read_config(char *filename);
unsigned char* skin_get_string(SKIN_T *skin);
void skin_direct_replace_string(SKIN_T *skin, unsigned char *orig, unsigned char *str);
void skin_direct_replace_format(SKIN_T *skin, unsigned char *orig, unsigned char *fmt, ...);
void skin_direct_replace_global(SKIN_T *skin, SKIN_REPLASE_GLOBAL_DATA_T *rep_p);
void skin_direct_cut_enclosed_words(SKIN_T *skin, unsigned char *s, unsigned char *e);
int skin_direct_send(int fd, SKIN_T *skin);
;
void replase_skin_grobal_data(unsigned char *menu_work_p, int menu_work_buf_size, SKIN_REPLASE_GLOBAL_DATA_T *skin_rep_data_global_p);
void replase_skin_line_data(unsigned char *menu_work_p, int menu_work_buf_size, SKIN_REPLASE_LINE_DATA_T *skin_rep_data_line_p);

void skin_direct_replace_image_viewer(SKIN_T *skin, SKIN_REPLASE_IMAGE_VIEWER_DATA_T *image_viewer_info_p);
SKIN_REPLASE_GLOBAL_DATA_T *skin_create_global_data(HTTP_RECV_INFO *http_recv_info_p, int file_num);

// --------------------------------------------------------------------------

#define		SKIN_MENU_CONF						"wizd_skin.conf"

#define		SKIN_MENU_HEAD_HTML					"head.html"
#define		SKIN_MENU_TAIL_HTML					"tail.html"

#define		SKIN_MENU_THUMB_HEAD_HTML				"thumb_head.html"
#define		SKIN_MENU_THUMB_TAIL_HTML				"thumb_tail.html"

#define     SKIN_MENU_MIDHEAD_HTML                  "midhead.html"
#define     SKIN_MENU_THUMB_MIDHEAD_HTML            "thumb_midhead.html"
#define     SKIN_MENU_MID_LINE_HTML                 "line_middle.html"
#define     SKIN_MENU_MIDTAIL_HTML                  "midtail.html"
#define     SKIN_MENU_THUMB_MIDTAIL_HTML            "thumb_midtail.html"

#define     SKIN_MENU_NAVHEAD_HTML                  "navhead.html"
#define     SKIN_MENU_NAV_LINE_HTML            		"line_nav.html"
#define     SKIN_MENU_NAVTAIL_HTML            		"navtail.html"

#define		SKIN_DELETE_HEAD_HTML					"delete_head.html"
#define		SKIN_DELETE_TAIL_HTML					"delete_tail.html"
#define		SKIN_DELETE_CONFIRM_HTML				"delete_confirm.html"

#define     SKIN_MENU_ALBUM_HTML            		"line_album.html"

#ifdef NEED_SKIN_MAPPING_DEFINITION
SKIN_MAPPING_T skin_mapping[] = {
	{TYPE_UNKNOWN,		"unknown"},
	{TYPE_DIRECTORY,	"dir"},
	{TYPE_VIDEO_TS,	"videots"},
	{TYPE_PSEUDO_DIR,	"pseudo"},
	{TYPE_MOVIE,		"movie"},
	{TYPE_PLAYLIST,		"playlist"},
	{TYPE_MUSIC,		"music"},
	{TYPE_MUSICLIST,	"musiclist"},
	{TYPE_IMAGE,		"image"},
	{TYPE_DOCUMENT,		"document"},
	{TYPE_SVI,		"svi"},
	{TYPE_JPEG,		"jpeg"},
	{TYPE_URL,		"url"},
	{TYPE_ISO,		"iso"},
	{TYPE_DELETE,		"delete"},
	{TYPE_CHAPTER,		"chapter"},
	{TYPE_ROW,		"row"},
	{TYPE_MP3INFO,		"mp3info"},
	{TYPE_AVIINFO,		"aviinfo"},
	{-1,			NULL},
};
#else
extern SKIN_MAPPING_T skin_mapping[];
// extern, but never be used? :p
#endif

#define		SKIN_KEYWORD_SERVER_ADDRESS		"<!--WIZD_INSERT_SERVER_ADDRESS-->"
#define		SKIN_KEYWORD_SERVER_NAME		"<!--WIZD_INSERT_SERVER_NAME-->"		// ̾Сɽ
#define		SKIN_KEYWORD_CURRENT_PATH		"<!--WIZD_INSERT_CURRENT_PATH-->"		// PATHɽ
#define		SKIN_KEYWORD_CURRENT_DIR_NAME	"<!--WIZD_INSERT_CURRENT_DIR_NAME-->"		// ǥ쥯ȥ̾ɽ
#define		SKIN_KEYWORD_CURRENT_DATE		"<!--WIZD_INSERT_CURRENT_DATE-->"				// ɽ
#define		SKIN_KEYWORD_CURRENT_TIME		"<!--WIZD_INSERT_CURRENT_TIME-->"				// ɽ

#define		SKIN_KEYWORD_PARLENT_DIR_LINK	"<!--WIZD_INSERT_PARENT_DIR_LINK-->"	// ƥǥ쥯ȥꡣLINK URI󥳡ɺѤ
#define		SKIN_KEYWORD_PARLENT_DIR_NAME	"<!--WIZD_INSERT_PARENT_DIR_NANE-->"	// ƥǥ쥯ȥꡣɽ

#define		SKIN_KEYWORD_CURRENT_PATH_LINK	"<!--WIZD_INSERT_CURRENT_PATH_LINK-->"	// PATHLINKѡURI󥳡ɺѤ
#define		SKIN_KEYWORD_CURRENT_PATH_FULL_LINK	"<!--WIZD_INSERT_CURRENT_PATH_FULL_LINK-->"
#define		SKIN_KEYWORD_CURRENT_PATH_LINK_NO_PARAM	"<!--WIZD_INSERT_CURRENT_PATH_LINK_NO_PARAM-->"	// PATHLINKѡURI󥳡ɺѤ
#define		SKIN_KEYWORD_CURRENT_PATH_LINK_NO_SORT		"<!--WIZD_INSERT_CURRENT_PATH_LINK_NO_SORT-->"
#define		SKIN_KEYWORD_CURRENT_PATH_LINK_DVDOPT		"<!--WIZD_INSERT_CURRENT_PATH_LINK_DVDOPT-->"
#define		SKIN_KEYWORD_CURRENT_PATH_LINK_NO_DVDOPT	"<!--WIZD_INSERT_CURRENT_PATH_LINK_NO_DVDOPT-->"
#define		SKIN_KEYWORD_CURRENT_PATH_LINK_NO_OPTION	"<!--WIZD_INSERT_CURRENT_PATH_LINK_NO_OPTION-->"
#define		SKIN_KEYWORD_CURRENT_REQUEST_URI	"<!--WIZD_INSERT_CURRENT_URI-->"


#define		SKIN_KEYWORD_CURRENT_PAGE		"<!--WIZD_INSERT_CURRENT_PAGE-->"		// ߤΥڡ
#define		SKIN_KEYWORD_MAX_PAGE			"<!--WIZD_INSERT_MAX_PAGE-->"			// ڡ
#define		SKIN_KEYWORD_NEXT_PAGE			"<!--WIZD_INSERT_NEXT_PAGE-->"			// Υڡ
#define		SKIN_KEYWORD_PREV_PAGE			"<!--WIZD_INSERT_PREV_PAGE-->"			// Υڡ
#define		SKIN_KEYWORD_FILE_NUM			"<!--WIZD_INSERT_FILE_NUM-->"			// ǥ쥯ȥ¸ߥե
#define		SKIN_KEYWORD_START_FILE_NUM		"<!--WIZD_INSERT_START_FILE_NUM-->"		// Υڡ
#define		SKIN_KEYWORD_END_FILE_NUM		"<!--WIZD_INSERT_END_FILE_NUM-->"		// Υڡ

#define		SKIN_KEYWORD_ONLOADSET_FOCUS		"<!--WIZD_INSERT_ONLOADSET_FOCUS-->"		// BODY onloadset="$focus"

#define		SKIN_KEYWORD_CLIENT_CHARSET		"<!--WIZD_INSERT_CLIENT_CHARSET-->"		// 饤Ȥδ

#define		SKIN_KEYWORD_DEFAULT_PHOTOLIST	"<!--WIZD_INSERT_DEFAULT_PHOTOLIST-->"
#define		SKIN_KEYWORD_DEFAULT_MUSICLIST	"<!--WIZD_INSERT_DEFAULT_MUSICLIST-->"


#define		SKIN_KEYWORD_LINE_FILE_NAME			"<!--WIZD_INSERT_LINE_FILE_NAME-->"			// ե̾ ɽ
#define		SKIN_KEYWORD_LINE_FILE_NAME_NO_EXT	"<!--WIZD_INSERT_LINE_FILE_NAME_NO_EXT-->"	// ե̾(ĥ̵) ɽ
#define		SKIN_KEYWORD_LINE_FILE_EXT			"<!--WIZD_INSERT_LINE_FILE_EXT-->"			// եĥ ɽ
#define		SKIN_KEYWORD_LINE_FILE_LINK			"<!--WIZD_INSERT_LINE_FILE_LINK-->"			// ե̾  URI󥳡
#define		SKIN_KEYWORD_LINE_CHAPTER_LINK		"<!--WIZD_INSERT_LINE_CHAPTER_LINK-->"
#define		SKIN_KEYWORD_LINE_CHAPTER_STR		"<!--WIZD_INSERT_LINE_CHAPTER_STR-->"
/* XXX */
#define		SKIN_KEYWORD_LINE_FILE_IMAGE		"<!--WIZD_INSERT_LINE_FILE_IMAGE-->"			// ե̾ ɽ

#define		SKIN_KEYWORD_LINE_INFO_LINK		    "<!--WIZD_INSERT_LINE_INFO_LINK-->"			// ե̾ ɽ

#define		SKIN_KEYWORD_LINE_HTML_LINK		    "<!--WIZD_INSERT_LINE_HTML_LINK-->"			// ե̾ ɽ
/* XXX */

#define		SKIN_KEYWORD_LINE_TIMESTAMP		"<!--WIZD_INSERT_LINE_TIMESTAMP-->"		// ॹ (YYYY/MM/DD HH:MM) ɽ

#define		SKIN_KEYWORD_LINE_FILE_DATE		"<!--WIZD_INSERT_LINE_FILE_DATE-->"		// ॹ դΤ(YYYY/MM/DD) ɽ
#define		SKIN_KEYWORD_LINE_FILE_TIME		"<!--WIZD_INSERT_LINE_FILE_TIME-->"		// ॹ Τ(HH:MM) ɽ
#define		SKIN_KEYWORD_LINE_FILE_DURATION		"<!--WIZD_INSERT_LINE_FILE_DURATION-->"		// ॹ Τ(HH:MM) ɽ


#define		SKIN_KEYWORD_LINE_COLUMN_NUM	"<!--WIZD_INSERT_LINE_COLUMN_NUM-->"	// ֹ
#define		SKIN_KEYWORD_LINE_ROW_NUM	"<!--WIZD_INSERT_LINE_ROW_NUM-->"	// ֹ

#define		SKIN_KEYWORD_LINE_TVID			"<!--WIZD_INSERT_LINE_TVID-->"			// TVID

#define		SKIN_KEYWORD_LINE_FILE_VOD		"<!--WIZD_INSERT_LINE_FILE_VOD-->"		// vod="0"  ɬפ˱դ
#define		SKIN_KEYWORD_LINE_FILE_SIZE		"<!--WIZD_INSERT_LINE_FILE_SIZE-->"		// ե륵 ɽ

#define		SKIN_KEYWORD_LINE_SVI_INFO		"<!--WIZD_INSERT_LINE_SVI_INFO-->"		// SVIե뤫ɤ ɽ
#define		SKIN_KEYWORD_LINE_SVI_REC_TIME	"<!--WIZD_INSERT_LINE_SVI_REC_TIME-->"	// SVIեϿ

#define		SKIN_KEYWORD_LINE_IMAGE_WIDTH	"<!--WIZD_INSERT_LINE_IMAGE_WIDTH-->"	// β
#define		SKIN_KEYWORD_LINE_IMAGE_HEIGHT	"<!--WIZD_INSERT_LINE_IMAGE_HEIGHT-->"	// ι⤵

#define		SKIN_KEYWORD_SECRET_DIR_LINK	"<!--WIZD_INSERT_SECRET_DIR_LINK-->"	// ǥ쥯ȥ


#define		SKIN_KEYWORD_LINE_MP3TAG_TITLE		"<!--WIZD_INSERT_LINE_MP3TAG_TITLE-->"		// MP3 ȥ
#define		SKIN_KEYWORD_LINE_MP3TAG_ALBUM		"<!--WIZD_INSERT_LINE_MP3TAG_ALBUM-->"		// MP3 Х̾
#define		SKIN_KEYWORD_LINE_MP3TAG_ARTIST		"<!--WIZD_INSERT_LINE_MP3TAG_ARTIST-->"		// MP3 ƥ
#define		SKIN_KEYWORD_LINE_MP3TAG_YEAR		"<!--WIZD_INSERT_LINE_MP3TAG_YEAR-->"		// MP3 ǯ
#define		SKIN_KEYWORD_LINE_MP3TAG_COMMENT	"<!--WIZD_INSERT_LINE_MP3TAG_COMMENT-->"	// MP3 

#define		SKIN_KEYWORD_LINE_MP3TAG_GENRE	    "<!--WIZD_INSERT_LINE_MP3TAG_GENRE-->"	// MP3 
#define		SKIN_KEYWORD_LINE_MP3TAG_BITRATE	"<!--WIZD_INSERT_LINE_MP3TAG_BITRATE-->"	// MP3 
#define		SKIN_KEYWORD_LINE_MP3TAG_STEREO		"<!--WIZD_INSERT_LINE_MP3TAG_STEREO-->"	// MP3 
#define		SKIN_KEYWORD_LINE_MP3TAG_FREQ		"<!--WIZD_INSERT_LINE_MP3TAG_FREQ-->"	// MP3 
#define		SKIN_KEYWORD_LINE_MP3TAG_TRACK		"<!--WIZD_INSERT_LINE_MP3TAG_TRACK-->"	// MP3 

#define		SKIN_KEYWORD_LINE_MP3TAG_TITLE_INFO	"<!--WIZD_INSERT_LINE_MP3TAG_TITLE_INFO-->"	// MP3 ȥ[Х̾/ƥ] ɽ(menu_filename_length_maxˤ¤)

#define		SKIN_KEYWORD_LINE_MP3TAG_TITLE_INFO_LIMITED	"<!--WIZD_INSERT_LINE_MP3TAG_TITLE_INFO_LIMITED-->"

#define		SKIN_KEYWORD_LINE_AVI_FPS		"<!--WIZD_INSERT_LINE_AVI_FPS-->"	// AVIFPS

#define		SKIN_KEYWORD_LINE_AVI_DURATION	"<!--WIZD_INSERT_LINE_AVI_DURATION-->"	// AVIκ

#define		SKIN_KEYWORD_LINE_AVI_VCODEC	"<!--WIZD_INSERT_LINE_AVI_VCODEC-->"	// AVIư襳ǥå

#define		SKIN_KEYWORD_LINE_AVI_ACODEC	"<!--WIZD_INSERT_LINE_AVI_ACODEC-->"	// AVIβǥå

#define		SKIN_KEYWORD_LINE_AVI_HVCODEC	"<!--WIZD_INSERT_LINE_AVI_HVCODEC-->"	// AVIư襳ǥå(in the avi stream header)

#define		SKIN_KEYWORD_LINE_AVI_HACODEC	"<!--WIZD_INSERT_LINE_AVI_HACODEC-->"	// AVIβǥå(in the avi stream header)

#define		SKIN_KEYWORD_LINE_AVI_IS_INTERLEAVED	"<!--WIZD_INSERT_LINE_AVI_IS_INTERLEAVED-->"	// AVI󥿡꡼֤Ƥ뤫


// ʲΥɤǶޤ줿ꥢϡפȤ˺롣

// 롼ȥǥ쥯ȥξ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_ROOTDIR				"<!--WIZD_DELETE_IS_ROOTDIR-->"
#define		SKIN_KEYWORD_DEL_IS_ROOTDIR_E			"<!--/WIZD_DELETE_IS_ROOTDIR-->"

/* ߴ */
// ڡ¸ߤʤ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_NO_PAGE_PREV		"<!--WIZD_DELETE_IS_NO_PAGE_PREV-->"
#define		SKIN_KEYWORD_DEL_IS_NO_PAGE_PREV_E		"<!--/WIZD_DELETE_IS_NO_PAGE_PREV-->"

// ڡ¸ߤʤ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_NO_PAGE_NEXT		"<!--WIZD_DELETE_IS_NO_PAGE_NEXT-->"
#define		SKIN_KEYWORD_DEL_IS_NO_PAGE_NEXT_E		"<!--/WIZD_DELETE_IS_NO_PAGE_NEXT-->"

// ǽե뤬¸ߤʤ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_NO_STREAM_FILES		"<!--WIZD_DELETE_IS_NO_STREAM_FILES-->"
#define		SKIN_KEYWORD_DEL_IS_NO_STREAM_FILES_E	"<!--/WIZD_DELETE_IS_NO_STREAM_FILES-->"

#define		SKIN_KEYWORD_DEL_IS_NO_MUSIC_FILES		"<!--WIZD_DELETE_IS_NO_MUSIC_FILES-->"
#define		SKIN_KEYWORD_DEL_IS_NO_MUSIC_FILES_E	"<!--/WIZD_DELETE_IS_NO_MUSIC_FILES-->"

#define		SKIN_KEYWORD_DEL_IS_NO_PHOTO_FILES		"<!--WIZD_DELETE_IS_NO_PHOTO_FILES-->"
#define		SKIN_KEYWORD_DEL_IS_NO_PHOTO_FILES_E	"<!--/WIZD_DELETE_IS_NO_PHOTO_FILES-->"

#define		SKIN_KEYWORD_DEL_CAN_DELETE		"<!--WIZD_CAN_DELETE-->"
#define		SKIN_KEYWORD_DEL_CAN_DELETE_E		"<!--/WIZD_CAN_DELETE-->"

/* , DELETE (IF THERE) IS NO... ɤ */
// ڡ¸ߤʤ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_NO_PAGE_PREV2		"<!--WIZD_IF_PAGE_PREV-->"
#define		SKIN_KEYWORD_DEL_IS_NO_PAGE_PREV2_E		"<!--/WIZD_IF_PAGE_PREV-->"

// ڡ¸ߤʤ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_NO_PAGE_NEXT2		"<!--WIZD_IF_PAGE_NEXT-->"
#define		SKIN_KEYWORD_DEL_IS_NO_PAGE_NEXT2_E		"<!--/WIZD_IF_PAGE_NEXT-->"

// ǽե뤬¸ߤʤ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_NO_STREAM_FILES2	"<!--WIZD_IF_STREAM_FILES-->"
#define		SKIN_KEYWORD_DEL_IS_NO_STREAM_FILES2_E	"<!--/WIZD_IF_STREAM_FILES-->"

#define		SKIN_KEYWORD_DEL_IS_NO_MUSIC_FILES2		"<!--WIZD_IF_MUSIC_FILES-->"
#define		SKIN_KEYWORD_DEL_IS_NO_MUSIC_FILES2_E	"<!--/WIZD_IF_MUSIC_FILES-->"

#define		SKIN_KEYWORD_DEL_IS_NO_PHOTO_FILES2		"<!--WIZD_IF_PHOTO_FILES-->"
#define		SKIN_KEYWORD_DEL_IS_NO_PHOTO_FILES2_E	"<!--/WIZD_IF_PHOTO_FILES-->"

// ڡ¸ߤ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_PAGE_PREV		"<!--WIZD_IF_NO_PAGE_PREV-->"
#define		SKIN_KEYWORD_DEL_IS_PAGE_PREV_E		"<!--/WIZD_IF_NO_PAGE_PREV-->"

// ڡ¸ߤ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_PAGE_NEXT		"<!--WIZD_IF_NO_PAGE_NEXT-->"
#define		SKIN_KEYWORD_DEL_IS_PAGE_NEXT_E		"<!--/WIZD_IF_NO_PAGE_NEXT-->"

// ǽե뤬¸ߤ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_STREAM_FILES	"<!--WIZD_IF_NO_STREAM_FILES-->"
#define		SKIN_KEYWORD_DEL_IS_STREAM_FILES_E	"<!--/WIZD_IF_NO_STREAM_FILES-->"

#define		SKIN_KEYWORD_DEL_IS_MUSIC_FILES		"<!--WIZD_IF_NO_MUSIC_FILES-->"
#define		SKIN_KEYWORD_DEL_IS_MUSIC_FILES_E	"<!--/WIZD_IF_NO_MUSIC_FILES-->"

#define		SKIN_KEYWORD_DEL_IS_PHOTO_FILES		"<!--WIZD_IF_NO_PHOTO_FILES-->"
#define		SKIN_KEYWORD_DEL_IS_PHOTO_FILES_E	"<!--/WIZD_IF_NO_PHOTO_FILES-->"

// MP3¸ߤʤȤ (LINEΤ)
#define		SKIN_KEYWORD_DEL_IS_NO_MP3_TAGS			"<!--WIZD_DELETE_IS_NO_MP3_TAGS-->"
#define		SKIN_KEYWORD_DEL_IS_NO_MP3_TAGS_E		"<!--/WIZD_DELETE_IS_NO_MP3_TAGS-->"

// MP3¸ߤȤ (LINEΤ)
#define		SKIN_KEYWORD_DEL_IS_HAVE_MP3_TAGS		"<!--WIZD_DELETE_IS_HAVE_MP3_TAGS-->"
#define		SKIN_KEYWORD_DEL_IS_HAVE_MP3_TAGS_E		"<!--/WIZD_DELETE_IS_HAVE_MP3_TAGS-->"

// MP3¸ߤȤ (LINEΤ)
#define		SKIN_KEYWORD_DEL_IS_NOT_HAVE_AVI_TAGS		"<!--WIZD_DELETE_IS_NOT_HAVE_AVI_TAGS-->"
#define		SKIN_KEYWORD_DEL_IS_NOT_HAVE_AVI_TAGS_E		"<!--/WIZD_DELETE_IS_NOT_HAVE_AVI_TAGS-->"
#define		SKIN_KEYWORD_DEL_IS_HAVE_AVI_TAGS		"<!--WIZD_DELETE_IS_HAVE_AVI_TAGS-->"
#define		SKIN_KEYWORD_DEL_IS_HAVE_AVI_TAGS_E		"<!--/WIZD_DELETE_IS_HAVE_AVI_TAGS-->"


// Ԥ/ΤȤ (LINEΤ)
#define		SKIN_KEYWORD_DEL_IF_LINE_IS_ODD			"<!--WIZD_IF_LINE_IS_EVEN-->"	// ԤΤȤ
#define		SKIN_KEYWORD_DEL_IF_LINE_IS_ODD_E		"<!--/WIZD_IF_LINE_IS_EVEN-->"	// ԤΤȤ

#define		SKIN_KEYWORD_DEL_IF_LINE_IS_EVEN		"<!--WIZD_IF_LINE_IS_ODD-->"	// ԤΤȤ
#define		SKIN_KEYWORD_DEL_IF_LINE_IS_EVEN_E		"<!--/WIZD_IF_LINE_IS_ODD-->"	// ԤΤȤ


// 饤ȤPCΤȤ
#define		SKIN_KEYWORD_DEL_IF_CLIENT_IS_NOT_PC		"<!--WIZD_IF_CLIENT_IS_NOT_PC-->"
#define		SKIN_KEYWORD_DEL_IF_CLIENT_IS_NOT_PC_E		"<!--/WIZD_IF_CLIENT_IS_NOT_PC-->"

// 饤ȤPCǤϤʤȤ
#define		SKIN_KEYWORD_DEL_IF_CLIENT_IS_PC		"<!--WIZD_IF_CLIENT_IS_PC-->"
#define		SKIN_KEYWORD_DEL_IF_CLIENT_IS_PC_E		"<!--/WIZD_IF_CLIENT_IS_PC-->"

// Skin sections which depend on whether or not the client is using HD resolution
#define		SKIN_KEYWORD_DEL_IF_CLIENT_IS_HD		"<!--WIZD_IF_CLIENT_IS_HD-->"
#define		SKIN_KEYWORD_DEL_IF_CLIENT_IS_HD_E		"<!--/WIZD_IF_CLIENT_IS_HD-->"

#define		SKIN_KEYWORD_DEL_IF_CLIENT_IS_NOT_HD		"<!--WIZD_IF_CLIENT_IS_NOT_HD-->"
#define		SKIN_KEYWORD_DEL_IF_CLIENT_IS_NOT_HD_E		"<!--/WIZD_IF_CLIENT_IS_NOT_HD-->"

// focus ꤵƤȤ
#define		SKIN_KEYWORD_DEL_IF_FOCUS_IS_SPECIFIED		"<!--WIZD_IF_FOCUS_IS_NOT_SPECIFIED-->"
#define		SKIN_KEYWORD_DEL_IF_FOCUS_IS_SPECIFIED_E	"<!--/WIZD_IF_FOCUS_IS_NOT_SPECIFIED-->"

// focus ꤵƤʤȤ
#define		SKIN_KEYWORD_DEL_IF_FOCUS_IS_NOT_SPECIFIED		"<!--WIZD_IF_FOCUS_IS_SPECIFIED-->"
#define		SKIN_KEYWORD_DEL_IF_FOCUS_IS_NOT_SPECIFIED_E	"<!--/WIZD_IF_FOCUS_IS_SPECIFIED-->"

// dvdopt
#define		SKIN_KEYWORD_DVD_OPTIONS	"<!--WIZD_INSERT_DVD_OPTIONS-->"


#define		SKIN_IMAGE_VIEWER_HTML 	"image_viewer.html"	// ImageViewerΥ
#define		SKIN_JPEG_IMAGE_VIEWER_HTML 	"jpeg_image_viewer.html"	// ImageViewerΥ
#define		SKIN_OPTION_MENU_HTML 	"option_menu.html"


#define		SKIN_KEYWORD_IMAGE_VIEWER_WIDTH		"<!--WIZD_INSERT_IMAGE_VIEWER_WIDTH-->"		// ImageViewerɽ
#define		SKIN_KEYWORD_IMAGE_VIEWER_HEIGHT	"<!--WIZD_INSERT_IMAGE_VIEWER_HEIGHT-->"	// ImageViewerɽ⤵
#define		SKIN_KEYWORD_IMAGE_VIEWER_MODE		"<!--WIZD_INSERT_IMAGE_VIEWER_MODE-->"		// ImageViewerθߤΥ⡼



// FIT⡼ɤλʲϰϤ
#define		SKIN_KEYWORD_DEL_IS_FIT_MODE	"<!--WIZD_DELETE_IS_FIT_MODE-->"
#define		SKIN_KEYWORD_DEL_IS_FIT_MODE_E	"<!--/WIZD_DELETE_IS_FIT_MODE-->"


// FIT⡼ɰʳλʲϰϤ
#define		SKIN_KEYWORD_DEL_IS_NO_FIT_MODE		"<!--WIZD_DELETE_IS_NO_FIT_MODE-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FIT_MODE_E	"<!--/WIZD_DELETE_IS_NO_FIT_MODE-->"

// ڡ¸ߤʤ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_CURRENT_PAGE		"<!--WIZD_DELETE_IS_CURRENT_PAGE-->"
#define		SKIN_KEYWORD_DEL_IS_CURRENT_PAGE_E		"<!--/WIZD_DELETE_IS_CURRENT_PAGE-->"

// ڡ¸ߤʤ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_NOT_CURRENT_PAGE		"<!--WIZD_DELETE_IS_NOT_CURRENT_PAGE-->"
#define		SKIN_KEYWORD_DEL_IS_NOT_CURRENT_PAGE_E		"<!--/WIZD_DELETE_IS_NOT_CURRENT_PAGE-->"

// setup the 10 favorites tests
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES1		"<!--WIZD_DELETE_IS_NO_FAVORITES1-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES1_E		"<!--/WIZD_DELETE_IS_NO_FAVORITES1-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES2		"<!--WIZD_DELETE_IS_NO_FAVORITES2-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES2_E		"<!--/WIZD_DELETE_IS_NO_FAVORITES2-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES3		"<!--WIZD_DELETE_IS_NO_FAVORITES3-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES3_E		"<!--/WIZD_DELETE_IS_NO_FAVORITES3-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES4		"<!--WIZD_DELETE_IS_NO_FAVORITES4-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES4_E		"<!--/WIZD_DELETE_IS_NO_FAVORITES4-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES5		"<!--WIZD_DELETE_IS_NO_FAVORITES5-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES5_E		"<!--/WIZD_DELETE_IS_NO_FAVORITES5-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES6		"<!--WIZD_DELETE_IS_NO_FAVORITES6-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES6_E		"<!--/WIZD_DELETE_IS_NO_FAVORITES6-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES7		"<!--WIZD_DELETE_IS_NO_FAVORITES7-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES7_E		"<!--/WIZD_DELETE_IS_NO_FAVORITES7-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES8		"<!--WIZD_DELETE_IS_NO_FAVORITES8-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES8_E		"<!--/WIZD_DELETE_IS_NO_FAVORITES8-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES9		"<!--WIZD_DELETE_IS_NO_FAVORITES9-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES9_E		"<!--/WIZD_DELETE_IS_NO_FAVORITES9-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES10		"<!--WIZD_DELETE_IS_NO_FAVORITES10-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FAVORITES10_E		"<!--/WIZD_DELETE_IS_NO_FAVORITES10-->"

// define 10 favorites variables
#define		SKIN_KEYWORD_FAVORITES1		    "<!--WIZD_FAVORITES1-->"
#define		SKIN_KEYWORD_FAVORITES2		    "<!--WIZD_FAVORITES2-->"
#define		SKIN_KEYWORD_FAVORITES3		    "<!--WIZD_FAVORITES3-->"
#define		SKIN_KEYWORD_FAVORITES4		    "<!--WIZD_FAVORITES4-->"
#define		SKIN_KEYWORD_FAVORITES5		    "<!--WIZD_FAVORITES5-->"
#define		SKIN_KEYWORD_FAVORITES6		    "<!--WIZD_FAVORITES6-->"
#define		SKIN_KEYWORD_FAVORITES7		    "<!--WIZD_FAVORITES7-->"
#define		SKIN_KEYWORD_FAVORITES8		    "<!--WIZD_FAVORITES8-->"
#define		SKIN_KEYWORD_FAVORITES9		    "<!--WIZD_FAVORITES9-->"
#define		SKIN_KEYWORD_FAVORITES10		    "<!--WIZD_FAVORITES10-->"

// for html movie info files
#define		SKIN_KEYWORD_DEL_IF_NO_HTML_LINK		"<!--WIZD_IF_NO_HTML_LINK-->"
#define		SKIN_KEYWORD_DEL_IF_NO_HTML_LINK_E	"<!--/WIZD_IF_NO_HTML_LINK-->"
#define		SKIN_KEYWORD_DEL_IF_HAVE_HTML_LINK		"<!--WIZD_IF_HAVE_HTML_LINK-->"
#define		SKIN_KEYWORD_DEL_IF_HAVE_HTML_LINK_E	"<!--/WIZD_IF_HAVE_HTML_LINK-->"

//
#define		SKIN_KEYWORD_DEFAULT_TYPE		"<!--WIZD_DEFAULT_TYPE-->"
#define		SKIN_KEYWORD_ALIAS_SEARCH		"<!--WIZD_ALIAS_SEARCH-->"
#define		SKIN_KEYWORD_SEARCH_STR		    "<!--WIZD_SEARCH_STR-->"
#define		SKIN_KEYWORD_DEFAULT_SEARCH_ALIAS		    "<!--WIZD_SEARCH_ALIAS-->"

#endif
