/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class PropertyPath
implements RevisionHandler {
    public static PropertyContainer find(Object src, Path path) {
        PropertyContainer result;
        PropertyDescriptor desc;
        PathElement part = path.get(0);
        try {
            desc = new PropertyDescriptor(part.getName(), src.getClass());
        }
        catch (Exception e) {
            desc = null;
            e.printStackTrace();
        }
        if (desc == null) {
            return null;
        }
        if (path.size() == 1) {
            result = new PropertyContainer(desc, src);
        } else {
            try {
                Method method = desc.getReadMethod();
                Object methodResult = method.invoke(src, (Object[])null);
                Object newSrc = part.hasIndex() ? Array.get(methodResult, part.getIndex()) : methodResult;
                result = PropertyPath.find(newSrc, path.subpath(1));
            }
            catch (Exception e) {
                result = null;
                e.printStackTrace();
            }
        }
        return result;
    }

    public static PropertyDescriptor getPropertyDescriptor(Object src, Path path) {
        PropertyContainer cont = PropertyPath.find(src, path);
        if (cont == null) {
            return null;
        }
        return cont.getDescriptor();
    }

    public static PropertyDescriptor getPropertyDescriptor(Object src, String path) {
        return PropertyPath.getPropertyDescriptor(src, new Path(path));
    }

    public static Object getValue(Object src, Path path) {
        Object result = null;
        PropertyContainer cont = PropertyPath.find(src, path);
        if (cont == null) {
            return null;
        }
        try {
            PathElement part = path.get(path.size() - 1);
            Method method = cont.getDescriptor().getReadMethod();
            Object methodResult = method.invoke(cont.getObject(), (Object[])null);
            result = part.hasIndex() ? Array.get(methodResult, part.getIndex()) : methodResult;
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public static Object getValue(Object src, String path) {
        return PropertyPath.getValue(src, new Path(path));
    }

    public static boolean setValue(Object src, Path path, Object value) {
        boolean result = false;
        PropertyContainer cont = PropertyPath.find(src, path);
        if (cont == null) {
            return result;
        }
        try {
            PathElement part = path.get(path.size() - 1);
            Method methodRead = cont.getDescriptor().getReadMethod();
            Method methodWrite = cont.getDescriptor().getWriteMethod();
            if (part.hasIndex()) {
                Object methodResult = methodRead.invoke(cont.getObject(), (Object[])null);
                Array.set(methodResult, part.getIndex(), value);
                methodWrite.invoke(cont.getObject(), methodResult);
            } else {
                methodWrite.invoke(cont.getObject(), value);
            }
            result = true;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public static void setValue(Object src, String path, Object value) {
        PropertyPath.setValue(src, new Path(path), value);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4742 $");
    }

    public static void main(String[] args) throws Exception {
        Path path = new Path("hello.world[2].nothing");
        System.out.println("Path: " + path);
        System.out.println(" -size: " + path.size());
        System.out.println(" -elements:");
        for (int i = 0; i < path.size(); ++i) {
            System.out.println("  " + i + ". " + path.get(i).getName() + " -> " + path.get(i).getIndex());
        }
    }

    protected static class PropertyContainer
    implements RevisionHandler {
        protected PropertyDescriptor m_Descriptor;
        protected Object m_Object;

        public PropertyContainer(PropertyDescriptor desc, Object obj) {
            this.m_Descriptor = desc;
            this.m_Object = obj;
        }

        public PropertyDescriptor getDescriptor() {
            return this.m_Descriptor;
        }

        public Object getObject() {
            return this.m_Object;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 4742 $");
        }
    }

    public static class Path
    implements RevisionHandler {
        protected Vector m_Elements = new Vector();

        protected Path() {
        }

        public Path(String path) {
            this();
            this.m_Elements = this.breakUp(path);
        }

        public Path(Vector elements) {
            this();
            for (int i = 0; i < elements.size(); ++i) {
                this.m_Elements.add(((PathElement)elements.get(i)).clone());
            }
        }

        public Path(String[] elements) {
            this();
            for (int i = 0; i < elements.length; ++i) {
                this.m_Elements.add(new PathElement(elements[i]));
            }
        }

        protected Vector breakUp(String path) {
            Vector<PathElement> result = new Vector<PathElement>();
            StringTokenizer tok = new StringTokenizer(path, ".");
            while (tok.hasMoreTokens()) {
                result.add(new PathElement(tok.nextToken()));
            }
            return result;
        }

        public PathElement get(int index) {
            return (PathElement)this.m_Elements.get(index);
        }

        public int size() {
            return this.m_Elements.size();
        }

        public static Path parsePath(String path) {
            return new Path(path);
        }

        public Path subpath(int startIndex) {
            return this.subpath(startIndex, this.size());
        }

        public Path subpath(int startIndex, int endIndex) {
            Vector<PathElement> list = new Vector<PathElement>();
            for (int i = startIndex; i < endIndex; ++i) {
                list.add(this.get(i));
            }
            return new Path(list);
        }

        public String toString() {
            String result = "";
            for (int i = 0; i < this.m_Elements.size(); ++i) {
                if (i > 0) {
                    result = result + ".";
                }
                result = result + this.m_Elements.get(i);
            }
            return result;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 4742 $");
        }
    }

    public static class PathElement
    implements Cloneable,
    RevisionHandler {
        protected String m_Name;
        protected int m_Index;

        public PathElement(String property) {
            if (property.indexOf("[") > -1) {
                this.m_Name = property.replaceAll("\\[.*$", "");
                this.m_Index = Integer.parseInt(property.replaceAll(".*\\[", "").replaceAll("\\].*", ""));
            } else {
                this.m_Name = property;
                this.m_Index = -1;
            }
        }

        public Object clone() {
            return new PathElement(this.toString());
        }

        public String getName() {
            return this.m_Name;
        }

        public boolean hasIndex() {
            return this.getIndex() > -1;
        }

        public int getIndex() {
            return this.m_Index;
        }

        public String toString() {
            String result = this.getName();
            if (this.hasIndex()) {
                result = result + "[" + this.getIndex() + "]";
            }
            return result;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 4742 $");
        }
    }
}

