<?php
/**
 * Module help text.
 *
 * This file is included from the application help_text.php script.
 * It simply needs to set $title and $text for the help topic $help_topic
 *
 * webtrees: Web based Family History software
 * Copyright (C) 2010 webtrees development team.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @version $Id: help_text.php 9372 2010-09-06 23:01:43Z stephen $
 */

if (!defined('WT_WEBTREES') || !defined('WT_SCRIPT_NAME') || WT_SCRIPT_NAME!='help_text.php') {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

switch ($help) {
case 'upcoming_events':
	$title=i18n::translate('Upcoming events block');
	$text=i18n::translate('This block shows you anniversaries of events that are coming up in the near future.<br /><br />The administrator determines how far ahead the block will look.  You can further refine the block\'s display of upcoming events through several configuration options.');
	$text.='<ul><li>';
	$text.=i18n::translate('Number of days to show: This is the number of days that <b>webtrees</b> should use when searching for events');
	$text.=' (<i>'.i18n::plural('maximum %d day', 'maximum %d days', 30, 30).'</i>).';
	$text.='</li><li>';
	$text.=i18n::translate('Show only events of living people?: Choose to show events of all people, or just those still living.');
	$text.='</li><li>';
	$text.=i18n::translate('Show only births, deaths and marriages?: This option lets you eliminate some dated events.  For example, Divorce, Cremation, Graduation, Bar Mitzvah, First Communion, etc. should all be dated. When you select "Yes", only Births, Deaths, and Marriages will be shown. When you select "No", all dated events will be shown.');
	$text.='</li><li>';
	$text.=i18n::translate('Presentation style: Either a simple text "List" or a "Table" format.');
	$text.='</li><li>';
	$text.=i18n::translate('Sort style: "Alphabetically", or "By Anniversary" showing results in date order with the most recent first.');
	$text.='</li></ul>';
	break;
}
?>