/*
 * Decompiled with CFR 0.152.
 */
package org.openamf.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.openamf.AMFBody;
import org.openamf.AMFMessage;
import org.openamf.io.AMFDeserializer;
import org.openamf.io.AMFSerializer;
import org.openamf.test.Foo;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class AMFSerializerTest
extends TestCase {
    static /* synthetic */ Class class$org$openamf$io$AMFSerializerTest;

    public AMFSerializerTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(class$org$openamf$io$AMFSerializerTest == null ? (class$org$openamf$io$AMFSerializerTest = AMFSerializerTest.class$("org.openamf.io.AMFSerializerTest")) : class$org$openamf$io$AMFSerializerTest);
        return suite;
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testSerializeMessage() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AMFSerializer serializer = new AMFSerializer(new DataOutputStream(output));
        AMFMessage message = this.getTestMessage();
        serializer.serializeMessage(message);
        AMFSerializerTest.assertTrue((output.size() > 0 ? 1 : 0) != 0);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        DataInputStream dis = new DataInputStream(in);
        AMFDeserializer deserializer = new AMFDeserializer(dis);
        AMFMessage deserializedMessage = deserializer.getAMFMessage();
        AMFSerializerTest.assertNotNull((Object)deserializedMessage);
        AMFSerializerTest.assertNotNull((Object)deserializedMessage.getBodies());
        AMFSerializerTest.assertEquals((int)message.getHeaderCount(), (int)deserializedMessage.getHeaderCount());
        AMFSerializerTest.assertEquals((int)message.getBodyCount(), (int)deserializedMessage.getBodyCount());
        AMFSerializerTest.assertEquals((int)message.getVersion(), (int)deserializedMessage.getVersion());
    }

    public void testSerializeLargeStringMessage() throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AMFSerializer serializer = new AMFSerializer(new DataOutputStream(output));
        AMFMessage message = this.getLargeStringTestMessage(65536);
        serializer.serializeMessage(message);
        AMFSerializerTest.assertTrue((output.size() > 0 ? 1 : 0) != 0);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        DataInputStream dis = new DataInputStream(in);
        AMFDeserializer deserializer = new AMFDeserializer(dis);
        AMFMessage deserializedMessage = deserializer.getAMFMessage();
        AMFSerializerTest.assertNotNull((Object)deserializedMessage);
        AMFSerializerTest.assertNotNull((Object)deserializedMessage.getBodies());
        AMFSerializerTest.assertEquals((int)message.getHeaderCount(), (int)deserializedMessage.getHeaderCount());
        AMFSerializerTest.assertEquals((int)message.getBodyCount(), (int)deserializedMessage.getBodyCount());
        AMFSerializerTest.assertEquals((int)message.getVersion(), (int)deserializedMessage.getVersion());
        AMFBody sentBody = message.getBody(0);
        String sentString = (String)sentBody.getValue();
        AMFBody receivedBody = deserializedMessage.getBody(0);
        String receivedString = (String)receivedBody.getValue();
        AMFSerializerTest.assertEquals((String)sentString, (String)receivedString);
    }

    private AMFMessage getTestMessage() throws Exception {
        AMFMessage message = new AMFMessage();
        message.addHeader("testKey", true, "testValue");
        message.addBody("someService.someMethod", "someResponse", "body value", (byte)2);
        AMFBody bodyWithDate = new AMFBody("someService.someMethod", "someResponse", new Date(), 11);
        message.addBody(bodyWithDate);
        AMFBody bodyWithBoolean = new AMFBody("someService.someMethod", "someResponse", Boolean.TRUE, 1);
        message.addBody(bodyWithBoolean);
        AMFBody bodyWithCharacter = new AMFBody("someService.someMethod", "someResponse", new Character('v'), 2);
        message.addBody(bodyWithCharacter);
        AMFBody bodyWithIntegerNumber = new AMFBody("someService.someMethod", "someResponse", new Integer(387), 0);
        message.addBody(bodyWithIntegerNumber);
        HashMap<String, String> foo = new HashMap<String, String>();
        foo.put("key1", "value1");
        foo.put("key2", "value2");
        foo.put("3", "value3");
        AMFBody bodyWithMap = new AMFBody("someService.someMethod", "someResponse", foo, 8);
        message.addBody(bodyWithMap);
        AMFBody bodyWithDoubleNumber = new AMFBody("someService.someMethod", "someResponse", new Double(387.582), 0);
        message.addBody(bodyWithDoubleNumber);
        AMFBody bodyWithObject = new AMFBody("someService.someMethod", "someResponse", new Foo(), 3);
        message.addBody(bodyWithObject);
        AMFBody bodyWithXML = new AMFBody("someService.someMethod", "someResponse", this.getXMLDocument(), 15);
        message.addBody(bodyWithXML);
        return message;
    }

    private AMFMessage getLargeStringTestMessage(int stringSize) {
        StringBuffer buf = new StringBuffer(stringSize);
        for (int i = 0; i < stringSize; ++i) {
            buf.append("x");
        }
        AMFMessage message = new AMFMessage();
        message.addHeader("testKey", true, "testValue");
        message.addBody("someService.someMethod", "someResponse", buf.toString(), (byte)2);
        return message;
    }

    private Document getXMLDocument() throws Exception {
        String strXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo><bar>Hello \u00a3</bar></foo>";
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.parse(new InputSource(new StringReader(strXML)));
        return document;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

