/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.owasp.webscarab.util.Diff;
import org.owasp.webscarab.util.swing.NoWrapEditorKit;

public class DiffPanel
extends JPanel {
    private static final long serialVersionUID = 1604132435765855634L;
    public static final String SIDE_BY_SIDE = "SIDEBYSIDE";
    public static final String COMBINED = "COMBINED";
    private static final NoWrapEditorKit noWrapEditorKit = new NoWrapEditorKit();
    private String displayLayout = "";
    private JTextPane srcTextPane = null;
    private Document srcDoc = null;
    private JTextPane dstTextPane = null;
    private Document dstDoc = null;
    private JTextPane combinedTextPane = null;
    private Document combinedDoc = null;
    private CharSequence src = null;
    private CharSequence dst = null;
    private List edits = null;
    private Color changedColor;
    private Color addedColor;
    private Color deletedColor;
    private SimpleAttributeSet unchanged;
    private SimpleAttributeSet changed;
    private SimpleAttributeSet added;
    private SimpleAttributeSet deleted;
    private CardLayout layout;
    private JPanel combinedPanel;
    private JPanel bothPanel;

    public DiffPanel() {
        this(SIDE_BY_SIDE);
    }

    public DiffPanel(String displayLayout) {
        this.getPreferences();
        this.createAttributes();
        this.createComponents();
        this.addKeyMappings();
        this.setDisplayLayout(displayLayout);
    }

    private void getPreferences() {
        int colorSpec;
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        if (this.changedColor == null) {
            colorSpec = prefs.getInt("changed", Color.YELLOW.getRGB());
            this.changedColor = new Color(colorSpec);
        }
        if (this.addedColor == null) {
            colorSpec = prefs.getInt("added", Color.GREEN.getRGB());
            this.addedColor = new Color(colorSpec);
        }
        if (this.deletedColor == null) {
            colorSpec = prefs.getInt("deleted", Color.PINK.getRGB());
            this.deletedColor = new Color(colorSpec);
        }
    }

    private void addKeyMappings() {
        this.getActionMap().put("TOGGLELAYOUT", new AbstractAction(){
            private static final long serialVersionUID = 1558804946998494321L;

            public void actionPerformed(ActionEvent event) {
                DiffPanel.this.layout.next(DiffPanel.this);
                DiffPanel.this.requestFocusInWindow();
            }
        });
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(76, 2), "TOGGLELAYOUT");
    }

    private void createAttributes() {
        this.unchanged = new SimpleAttributeSet();
        this.changed = new SimpleAttributeSet();
        this.changed.addAttribute(StyleConstants.Background, this.changedColor);
        this.added = new SimpleAttributeSet();
        this.added.addAttribute(StyleConstants.Background, this.addedColor);
        this.deleted = new SimpleAttributeSet();
        this.deleted.addAttribute(StyleConstants.Background, this.deletedColor);
    }

    private void createComponents() {
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        this.combinedPanel = new JPanel(new BorderLayout());
        this.combinedTextPane = new JTextPane();
        this.combinedTextPane.setEditorKit(noWrapEditorKit);
        this.combinedTextPane.setFont(new Font("Monospaced", 0, 12));
        this.combinedTextPane.setEditable(false);
        this.combinedPanel.add(new JScrollPane(this.combinedTextPane));
        this.srcTextPane = new JTextPane();
        this.srcTextPane.setEditorKit(noWrapEditorKit);
        this.srcTextPane.setFont(new Font("Monospaced", 0, 12));
        this.srcTextPane.setEditable(false);
        this.dstTextPane = new JTextPane();
        this.dstTextPane.setEditorKit(noWrapEditorKit);
        this.dstTextPane.setFont(new Font("Monospaced", 0, 12));
        this.dstTextPane.setEditable(false);
        JScrollPane srcScrollPane = new JScrollPane(this.srcTextPane);
        srcScrollPane.setHorizontalScrollBarPolicy(31);
        srcScrollPane.setVerticalScrollBarPolicy(21);
        JScrollPane dstScrollPane = new JScrollPane(this.dstTextPane);
        dstScrollPane.setHorizontalScrollBarPolicy(31);
        dstScrollPane.setVerticalScrollBarPolicy(21);
        JScrollBar horizontalScrollBar = new JScrollBar(0);
        JScrollBar verticalScrollBar = new JScrollBar(1);
        srcScrollPane.getHorizontalScrollBar().setModel(horizontalScrollBar.getModel());
        srcScrollPane.getVerticalScrollBar().setModel(verticalScrollBar.getModel());
        dstScrollPane.getHorizontalScrollBar().setModel(horizontalScrollBar.getModel());
        dstScrollPane.getVerticalScrollBar().setModel(verticalScrollBar.getModel());
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(srcScrollPane);
        panel.add(dstScrollPane);
        this.bothPanel = new JPanel(new BorderLayout());
        this.bothPanel.add((Component)panel, "Center");
        this.bothPanel.add((Component)horizontalScrollBar, "South");
        this.bothPanel.add((Component)verticalScrollBar, "East");
        this.add(COMBINED, this.combinedPanel);
        this.add(SIDE_BY_SIDE, this.bothPanel);
    }

    public void setDisplayLayout(String displayLayout) {
        if (!displayLayout.equals(this.displayLayout)) {
            this.displayLayout = displayLayout;
            this.layout.show(this, displayLayout);
        }
    }

    public String getDisplayLayout() {
        return this.displayLayout;
    }

    public void clear() {
        this.combinedTextPane.setText("");
        this.srcTextPane.setText("");
        this.dstTextPane.setText("");
    }

    public void showDifferences(CharSequence src, CharSequence dst, List edits) {
        this.src = src;
        this.dst = dst;
        this.edits = edits;
        this.deleteDocuments();
        this.createDocuments();
    }

    private void deleteDocuments() {
        this.dstDoc = null;
        this.srcDoc = null;
        this.combinedDoc = null;
        if (this.combinedTextPane != null) {
            this.combinedTextPane.setText("");
        }
        if (this.srcTextPane != null) {
            this.srcTextPane.setText("");
        }
        if (this.dstTextPane != null) {
            this.dstTextPane.setText("");
        }
    }

    private void createDocuments() {
        this.combinedDoc = new DefaultStyledDocument();
        this.srcDoc = new DefaultStyledDocument();
        this.dstDoc = new DefaultStyledDocument();
        Iterator it = this.edits.iterator();
        int srcLast = 0;
        int dstLast = 0;
        try {
            while (it.hasNext()) {
                String s;
                Diff.Edit edit = (Diff.Edit)it.next();
                if (edit.getSrcLocation() > srcLast) {
                    s = ((Object)this.src.subSequence(srcLast, edit.getSrcLocation())).toString();
                    this.combinedDoc.insertString(this.combinedDoc.getLength(), s, this.unchanged);
                    this.srcDoc.insertString(this.srcDoc.getLength(), s, this.unchanged);
                }
                if (edit.getDstLocation() > dstLast) {
                    String d = ((Object)this.dst.subSequence(dstLast, edit.getDstLocation())).toString();
                    this.dstDoc.insertString(this.dstDoc.getLength(), d, this.unchanged);
                }
                s = ((Object)edit.getSrc()).toString();
                String d = ((Object)edit.getDst()).toString();
                if (edit.getSrc().length() > 0 && edit.getDst().length() > 0) {
                    int i;
                    String cr;
                    this.combinedDoc.insertString(this.combinedDoc.getLength(), s, this.deleted);
                    this.combinedDoc.insertString(this.combinedDoc.getLength(), d, this.added);
                    this.srcDoc.insertString(this.srcDoc.getLength(), s, this.changed);
                    this.dstDoc.insertString(this.dstDoc.getLength(), d, this.changed);
                    int v = this.countLines(s) - this.countLines(d);
                    if (v > 0) {
                        cr = "";
                        for (i = 0; i < v; ++i) {
                            cr = cr + "\n";
                        }
                        this.dstDoc.insertString(this.dstDoc.getLength(), cr, this.changed);
                    } else if (v < 0) {
                        v = -v;
                        cr = "";
                        for (i = 0; i < v; ++i) {
                            cr = cr + "\n";
                        }
                        this.srcDoc.insertString(this.srcDoc.getLength(), cr, this.changed);
                    }
                } else if (edit.getSrc().length() > 0) {
                    this.combinedDoc.insertString(this.combinedDoc.getLength(), s, this.deleted);
                    this.srcDoc.insertString(this.srcDoc.getLength(), s, this.added);
                    this.dstDoc.insertString(this.dstDoc.getLength(), s.replaceAll("[^\n]", " "), this.deleted);
                } else if (edit.getDst().length() > 0) {
                    this.combinedDoc.insertString(this.combinedDoc.getLength(), d, this.added);
                    this.srcDoc.insertString(this.srcDoc.getLength(), d.replaceAll("[^\n]", " "), this.deleted);
                    this.dstDoc.insertString(this.dstDoc.getLength(), d, this.added);
                }
                srcLast = edit.getSrcLocation() + s.length();
                dstLast = edit.getDstLocation() + d.length();
            }
            if (srcLast < this.src.length()) {
                String s = ((Object)this.src.subSequence(srcLast, this.src.length())).toString();
                this.combinedDoc.insertString(this.combinedDoc.getLength(), s, this.unchanged);
                this.srcDoc.insertString(this.srcDoc.getLength(), s, this.unchanged);
            }
            if (dstLast < this.dst.length()) {
                String d = ((Object)this.dst.subSequence(dstLast, this.dst.length())).toString();
                this.dstDoc.insertString(this.dstDoc.getLength(), d, this.unchanged);
            }
            this.combinedTextPane.setDocument(this.combinedDoc);
            this.srcTextPane.setDocument(this.srcDoc);
            this.dstTextPane.setDocument(this.dstDoc);
        }
        catch (BadLocationException ble) {
            this.combinedTextPane.setText(ble.toString());
        }
    }

    private int countLines(String string) {
        int lines = 0;
        int last = -1;
        while ((last = string.indexOf("\n", last + 1)) > -1) {
            ++lines;
        }
        return lines;
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("Diff");
        frame.setDefaultCloseOperation(3);
        DiffPanel panel = new DiffPanel(SIDE_BY_SIDE);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)panel, "Center");
        frame.setBounds(200, 100, 1000, 700);
        frame.setVisible(true);
        String src = "abc\ndef\nghi\nqrs\nxyz\n";
        String dst = "def\nghi\njkl\nmno\nxyz\nlmn\n";
        if (args.length == 2) {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(args[0]));
            StringBuffer buff = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                buff.append(line).append("\n");
            }
            reader.close();
            src = buff.toString();
            reader = new BufferedReader(new FileReader(args[1]));
            buff = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                buff.append(line).append("\n");
            }
            reader.close();
            dst = buff.toString();
        }
        List edits = Diff.getEdits(src, dst, '\n');
        System.out.println("Distance: " + Diff.getDistance(edits));
        edits = Diff.refine(src, dst, edits);
        System.out.println("Distance: " + Diff.getDistance(edits));
        panel.showDifferences(src, dst, edits);
    }
}

