/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util;

import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.Iterator;

public class ReentrantReaderPreferenceReadWriteLock
extends ReentrantWriterPreferenceReadWriteLock {
    private Sync _writeLock = new LoggingLock(super.writeLock());

    protected boolean allowReader() {
        return this.activeWriter_ == null || this.activeWriter_ == Thread.currentThread();
    }

    public void debug() {
        Iterator it = this.readers_.keySet().iterator();
        System.err.println("Readers:");
        while (it.hasNext()) {
            Object key = it.next();
            Object value = this.readers_.get(key);
            System.err.println(key + " : " + value);
        }
        System.err.println("Done");
        System.err.println("Writer thread:");
        System.err.println(this.activeWriter_.getName());
        System.err.println("Stack Trace:");
        Thread.dumpStack();
    }

    public Sync writeLock() {
        return this._writeLock;
    }

    private class LoggingLock
    implements Sync {
        private Sync _sync;

        public LoggingLock(Sync sync) {
            this._sync = sync;
        }

        public void acquire() throws InterruptedException {
            while (!this._sync.attempt(5000L)) {
                ReentrantReaderPreferenceReadWriteLock.this.debug();
            }
        }

        public boolean attempt(long msecs) throws InterruptedException {
            try {
                boolean result = this._sync.attempt(msecs);
                if (!result) {
                    System.err.println(Thread.currentThread().getName() + "sync attempt unsuccessful");
                }
                return result;
            }
            catch (InterruptedException ie) {
                System.err.println(Thread.currentThread().getName() + " interrupted");
                throw ie;
            }
        }

        public void release() {
            this._sync.release();
        }
    }
}

