/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Diff {
    private static final CharSequence DELETE = new String();

    private Diff() {
    }

    public static List getEdits(CharSequence src, CharSequence dst) {
        return Diff.getEdits(0, src.length(), src, 0, dst.length(), dst);
    }

    private static List getEdits(int srcStart, int srcEnd, CharSequence src, int dstStart, int dstEnd, CharSequence dst) {
        LinkedList<Edit> edits = new LinkedList<Edit>();
        while (srcStart < srcEnd && dstStart < dstEnd && src.charAt(srcStart) == dst.charAt(dstStart)) {
            ++srcStart;
            ++dstStart;
        }
        while (srcStart < srcEnd && dstStart < dstEnd && src.charAt(srcEnd - 1) == dst.charAt(dstEnd - 1)) {
            --srcEnd;
            --dstEnd;
        }
        if (srcStart == srcEnd && dstStart == dstEnd) {
            return edits;
        }
        if (srcStart == srcEnd) {
            edits.add(new Edit(srcStart, DELETE, dstStart, dst.subSequence(dstStart, dstEnd)));
            return edits;
        }
        if (dstStart == dstEnd) {
            edits.add(new Edit(srcStart, src.subSequence(srcStart, srcEnd), dstStart, DELETE));
            return edits;
        }
        LCS lcs = Diff.lcs(srcStart, srcEnd, src, dstStart, dstEnd, dst);
        if (lcs.getLength() > 0) {
            edits.addAll(Diff.getEdits(srcStart, lcs.getSrcLocation(), src, dstStart, lcs.getDstLocation(), dst));
            srcStart = lcs.getSrcLocation() + lcs.getLength();
            dstStart = lcs.getDstLocation() + lcs.getLength();
            edits.addAll(Diff.getEdits(srcStart, srcEnd, src, dstStart, dstEnd, dst));
        } else {
            edits.add(new Edit(srcStart, src.subSequence(srcStart, srcEnd), dstStart, dst.subSequence(dstStart, dstEnd)));
        }
        return edits;
    }

    public static CharSequence[] split(CharSequence orig, char boundary) {
        int index;
        LinkedList<CharSequence> list = new LinkedList<CharSequence>();
        int previous = 0;
        for (index = 0; index < orig.length(); ++index) {
            if (orig.charAt(index) != boundary) continue;
            list.add(orig.subSequence(previous, index + 1));
            previous = index + 1;
        }
        if (index > previous) {
            list.add(orig.subSequence(previous, index));
        }
        return list.toArray(new CharSequence[list.size()]);
    }

    public static List getEdits(CharSequence src, CharSequence dst, char boundary) {
        CharSequence[] srcArray = Diff.split(src, boundary);
        CharSequence[] dstArray = Diff.split(dst, boundary);
        List edits = Diff.getEdits(srcArray, dstArray);
        return Diff.convertArrayToOriginal(srcArray, dstArray, edits);
    }

    public static List convertArrayToOriginal(CharSequence[] src, CharSequence[] dst, List arrayEdits) {
        LinkedList<Edit> edits = new LinkedList<Edit>();
        Iterator it = arrayEdits.iterator();
        int srcLast = 0;
        int dstLast = 0;
        int srcOffset = 0;
        int dstOffset = 0;
        while (it.hasNext()) {
            ArrayEdit edit = (ArrayEdit)it.next();
            while (srcLast < edit.getSrcStart()) {
                srcOffset += src[srcLast++].length();
            }
            while (dstLast < edit.getDstStart()) {
                dstOffset += dst[dstLast++].length();
            }
            int srcStart = srcOffset;
            int dstStart = dstOffset;
            StringBuffer srcEdit = new StringBuffer();
            StringBuffer dstEdit = new StringBuffer();
            while (srcLast < edit.getSrcEnd()) {
                srcEdit.append(src[srcLast++]);
            }
            while (dstLast < edit.getDstEnd()) {
                dstEdit.append(dst[dstLast++]);
            }
            srcOffset += srcEdit.length();
            dstOffset += dstEdit.length();
            edits.add(new Edit(srcStart, srcEdit.toString(), dstStart, dstEdit.toString()));
        }
        return edits;
    }

    public static List getEdits(CharSequence[] src, CharSequence[] dst) {
        return Diff.getEdits(0, src.length, src, 0, dst.length, dst);
    }

    private static List getEdits(int srcStart, int srcEnd, CharSequence[] src, int dstStart, int dstEnd, CharSequence[] dst) {
        LinkedList<ArrayEdit> edits = new LinkedList<ArrayEdit>();
        while (srcStart < srcEnd && dstStart < dstEnd && src[srcStart].equals(dst[dstStart])) {
            ++srcStart;
            ++dstStart;
        }
        while (srcStart < srcEnd && dstStart < dstEnd && src[srcEnd - 1].equals(dst[dstEnd - 1])) {
            --srcEnd;
            --dstEnd;
        }
        if (srcStart == srcEnd && dstStart == dstEnd) {
            return edits;
        }
        if (srcStart == srcEnd || dstStart == dstEnd) {
            edits.add(new ArrayEdit(srcStart, srcEnd, dstStart, dstEnd));
            return edits;
        }
        LCS lcs = Diff.lcs(srcStart, srcEnd, src, dstStart, dstEnd, dst);
        if (lcs.getLength() > 0) {
            edits.addAll(Diff.getEdits(srcStart, lcs.getSrcLocation(), src, dstStart, lcs.getDstLocation(), dst));
            srcStart = lcs.getSrcLocation() + lcs.getLength();
            dstStart = lcs.getDstLocation() + lcs.getLength();
            edits.addAll(Diff.getEdits(srcStart, srcEnd, src, dstStart, dstEnd, dst));
        } else {
            edits.add(new ArrayEdit(srcStart, srcEnd, dstStart, dstEnd));
        }
        return edits;
    }

    public static List refine(CharSequence src, CharSequence dst, List edits) {
        LinkedList refined = new LinkedList();
        Iterator it = edits.iterator();
        while (it.hasNext()) {
            Edit edit = (Edit)it.next();
            int srcStart = edit.getSrcLocation();
            int srcEnd = srcStart + edit.getSrc().length();
            int dstStart = edit.getDstLocation();
            int dstEnd = dstStart + edit.getDst().length();
            refined.addAll(Diff.getEdits(srcStart, srcEnd, src, dstStart, dstEnd, dst));
        }
        return refined;
    }

    public static int getDistance(List edits) {
        int distance = 0;
        for (int i = 0; i < edits.size(); ++i) {
            Edit edit = (Edit)edits.get(i);
            distance += edit.getSrc().length() + edit.getDst().length();
        }
        return distance;
    }

    public static String apply(CharSequence src, List edits) {
        Iterator it = edits.iterator();
        StringBuffer buff = new StringBuffer();
        int last = 0;
        while (it.hasNext()) {
            Edit edit = (Edit)it.next();
            if (edit.getSrcLocation() > last) {
                buff.append(src.subSequence(last, edit.getSrcLocation()));
            }
            if (edit.getDst().length() > 0) {
                buff.append(edit.getDst());
            }
            last = edit.getSrcLocation() + edit.getSrc().length();
        }
        if (last < src.length()) {
            buff.append(src.subSequence(last, src.length()));
        }
        return buff.toString();
    }

    public static String revert(CharSequence dst, List edits) {
        Iterator it = edits.iterator();
        StringBuffer buff = new StringBuffer();
        int last = 0;
        while (it.hasNext()) {
            Edit edit = (Edit)it.next();
            if (edit.getDstLocation() > last) {
                buff.append(dst.subSequence(last, edit.getDstLocation()));
            }
            if (edit.getSrc().length() > 0) {
                buff.append(edit.getSrc());
            }
            last = edit.getDstLocation() + edit.getDst().length();
        }
        if (last < dst.length()) {
            buff.append(dst.subSequence(last, dst.length()));
        }
        return buff.toString();
    }

    private static LCS lcs(int srcStart, int srcEnd, CharSequence src, int dstStart, int dstEnd, CharSequence dst) {
        LCS lcs = new LCS(0, 0, 0);
        for (int i = srcStart; i < srcEnd; ++i) {
            for (int j = dstStart; j < dstEnd; ++j) {
                int len;
                int max = Math.min(srcEnd - i, dstEnd - j);
                for (len = 0; len < max && src.charAt(i + len) == dst.charAt(j + len); ++len) {
                }
                if (len <= lcs.getLength()) continue;
                lcs = new LCS(i, j, len);
            }
        }
        return lcs;
    }

    private static LCS lcs(int srcStart, int srcEnd, CharSequence[] src, int dstStart, int dstEnd, CharSequence[] dst) {
        LCS lcs = new LCS(0, 0, 0);
        for (int i = srcStart; i < srcEnd; ++i) {
            for (int j = dstStart; j < dstEnd; ++j) {
                int len;
                int max = Math.min(srcEnd - i, dstEnd - j);
                for (len = 0; len < max && src[i + len].equals(dst[j + len]); ++len) {
                }
                if (len <= lcs.getLength()) continue;
                lcs = new LCS(i, j, len);
            }
        }
        return lcs;
    }

    private static void test(String src, String dst) {
        List edits = Diff.getEdits(src, dst, ' ');
        String result = Diff.apply(src, edits);
        if (!result.equals(dst)) {
            System.err.println("Failed applying edits! '" + result + "' != '" + dst + "'");
        } else {
            System.err.println("Success applying!!");
        }
        result = Diff.revert(dst, edits);
        if (!result.equals(src)) {
            System.err.println("Failed reverting edits! '" + result + "' != '" + src + "'");
        } else {
            System.err.println("Success reverting!!");
        }
    }

    public static void main(String[] args) {
        Diff.test("cith", "ttttcithbbbb");
        Diff.test("quicklyquicish", "quincequickish");
        Diff.test("the cat in the hat box", "cat in the hat");
    }

    public static class ArrayEdit {
        private int srcStart;
        private int srcEnd;
        private int dstStart;
        private int dstEnd;

        public ArrayEdit(int srcStart, int srcEnd, int dstStart, int dstEnd) {
            if (srcStart < 0) {
                throw new IllegalArgumentException("Src Start may not be negative! " + srcStart);
            }
            if (dstStart < 0) {
                throw new IllegalArgumentException("Dst Start may not be negative! " + dstStart);
            }
            this.srcStart = srcStart;
            this.srcEnd = srcEnd;
            this.dstStart = dstStart;
            this.dstEnd = dstEnd;
        }

        public int getDstEnd() {
            return this.dstEnd;
        }

        public int getDstStart() {
            return this.dstStart;
        }

        public int getSrcEnd() {
            return this.srcEnd;
        }

        public int getSrcStart() {
            return this.srcStart;
        }

        public String toString() {
            return this.srcStart + "-" + this.srcEnd + ", " + this.dstStart + "-" + this.dstEnd;
        }
    }

    public static class Edit {
        private int srcLocation;
        private int dstLocation;
        private CharSequence src;
        private CharSequence dst;

        public Edit(int srcLocation, CharSequence src, int dstLocation, CharSequence dst) {
            if (srcLocation < 0) {
                throw new IllegalArgumentException("Src Start may not be negative! " + srcLocation);
            }
            if (dstLocation < 0) {
                throw new IllegalArgumentException("Dst Start may not be negative! " + dstLocation);
            }
            this.srcLocation = srcLocation;
            this.src = src;
            this.dstLocation = dstLocation;
            this.dst = dst;
        }

        public CharSequence getSrc() {
            return this.src;
        }

        public int getSrcLocation() {
            return this.srcLocation;
        }

        public CharSequence getDst() {
            return this.dst;
        }

        public int getDstLocation() {
            return this.dstLocation;
        }

        public String toString() {
            return this.srcLocation + "- '" + this.src + "', " + this.dstLocation + "- '" + this.dst + "'";
        }
    }

    private static class LCS {
        private int srcLocation;
        private int dstLocation;
        private int length;

        public LCS(int srcLocation, int dstLocation, int len) {
            this.srcLocation = srcLocation;
            this.dstLocation = dstLocation;
            this.length = len;
        }

        public int getDstLocation() {
            return this.dstLocation;
        }

        public int getLength() {
            return this.length;
        }

        public int getSrcLocation() {
            return this.srcLocation;
        }

        public String toString() {
            return "(" + this.srcLocation + "," + this.dstLocation + "," + this.length + ")";
        }
    }
}

