/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ccil.cowan.tagsoup.Parser;
import org.owasp.webscarab.ui.swing.editors.ByteArrayEditor;
import org.owasp.webscarab.util.DOMHandler;
import org.owasp.webscarab.util.swing.DOMTreeModel;
import org.owasp.webscarab.util.swing.MultiLineTreeCellRenderer;
import org.owasp.webscarab.util.swing.TreeUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class XMLPanel
extends JPanel
implements ByteArrayEditor {
    private static final long serialVersionUID = -244729718376716387L;
    private boolean _editable = false;
    private boolean _modified = false;
    private byte[] _data = new byte[0];
    private JScrollPane treeScrollPane;
    private JTree xmlTree;

    public XMLPanel() {
        this.initComponents();
        this.setName("XML");
        this.xmlTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("No content")));
        this.xmlTree.setCellRenderer(new XMLTreeNodeRenderer());
    }

    public void setEditable(boolean editable) {
    }

    public void setBytes(String contentType, byte[] bytes) {
        block8: {
            this._data = bytes;
            if (bytes != null) {
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                Element rootElement = null;
                try {
                    Document document = null;
                    if (contentType.matches("text/xml.*")) {
                        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                        builderFactory.setIgnoringElementContentWhitespace(true);
                        DocumentBuilder builder = builderFactory.newDocumentBuilder();
                        document = builder.parse(is);
                    } else if (contentType.matches("text/html.*")) {
                        DOMHandler domHandler = new DOMHandler();
                        Parser parser = new Parser();
                        parser.setContentHandler((ContentHandler)domHandler);
                        parser.parse(new InputSource(is));
                        document = domHandler.getDocument();
                    }
                    if (document != null) {
                        document.getDocumentElement().normalize();
                        rootElement = document.getDocumentElement();
                        DOMTreeModel tm = new DOMTreeModel(rootElement);
                        this.xmlTree.setModel(tm);
                        break block8;
                    }
                    this.xmlTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Invalid content")));
                }
                catch (Exception e) {
                    this.xmlTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Error: " + e.getMessage())));
                    e.printStackTrace();
                }
            } else {
                this.xmlTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("No elements")));
            }
        }
        TreeUtil.expandAll(this.xmlTree, true);
    }

    public boolean isModified() {
        return this._editable && this._modified;
    }

    public byte[] getBytes() {
        return this._data;
    }

    private void initComponents() {
        this.treeScrollPane = new JScrollPane();
        this.xmlTree = new JTree();
        this.setLayout(new BorderLayout());
        this.treeScrollPane.setViewportView(this.xmlTree);
        this.add((Component)this.treeScrollPane, "Center");
    }

    public static void main(String[] args) throws Exception {
        byte[] bytes;
        JFrame top = new JFrame("XML Editor");
        top.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        if (args.length > 0) {
            int got;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileInputStream is = new FileInputStream(args[0]);
            byte[] buff = new byte[1024];
            while ((got = ((InputStream)is).read(buff)) > 0) {
                baos.write(buff, 0, got);
            }
            bytes = baos.toByteArray();
        } else {
            bytes = "<b>NOTE: For security reasons, using the administration webapp\n        is restricted to users with role \"admin\". The manager webapp\nis restricted to users with role \"manager\".</b>".getBytes();
        }
        XMLPanel xp = new XMLPanel();
        top.getContentPane().add(xp);
        top.setBounds(100, 100, 600, 400);
        try {
            xp.setBytes("text/xml", bytes);
            xp.setEditable(true);
            top.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class XMLTreeNodeRenderer
    extends MultiLineTreeCellRenderer {
        private static final long serialVersionUID = 4591128488009949423L;

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof Node) {
                Node node = (Node)value;
                String text = value.toString();
                short type = node.getNodeType();
                switch (type) {
                    case 2: {
                        text = "ATTRIBUTE_NODE";
                        break;
                    }
                    case 4: {
                        text = "CDATA_SECTION_NODE";
                        break;
                    }
                    case 8: {
                        text = "COMMENT_NODE";
                        break;
                    }
                    case 1: {
                        text = "<" + node.getNodeName();
                        NamedNodeMap nnm = node.getAttributes();
                        if (nnm.getLength() > 0) {
                            StringBuffer buff = new StringBuffer();
                            Node attr = nnm.item(0);
                            buff.append(attr.getNodeName()).append("=\"").append(attr.getNodeValue()).append("\"");
                            for (int i = 1; i < nnm.getLength(); ++i) {
                                attr = nnm.item(i);
                                buff.append(" ").append(attr.getNodeName()).append("=\"").append(attr.getNodeValue()).append("\"");
                            }
                            text = text + " " + buff.toString();
                        }
                        text = text + ">";
                        break;
                    }
                    case 3: {
                        text = node.getNodeValue();
                        break;
                    }
                    default: {
                        value = "Type: " + node.getNodeType() + node.toString();
                    }
                }
                value = text.trim();
            }
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }
}

