/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractCellEditor;
import javax.swing.CellEditor;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.owasp.webscarab.util.swing.JTreeTable;
import org.owasp.webscarab.util.swing.treetable.DefaultTreeTableModel;

public class ObjectPanel
extends JPanel {
    private static final long serialVersionUID = -1149080437965386611L;
    private JTreeTable _tt;
    private ObjectTreeTableModel _ottm;
    private boolean _editable = false;
    private JButton deleteButton;
    private JScrollPane ttScrollPane;
    private JButton childButton;
    private JButton insertButton;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;

    public ObjectPanel() {
        this.initComponents();
        this.setName("Object");
        this._ottm = new ObjectTreeTableModel();
        this._tt = new JTreeTable(this._ottm){
            private static final long serialVersionUID = -6733180628013589307L;

            public TableCellRenderer getCellRenderer(int row, int column) {
                Object o;
                if (column == 2 && (o = ((ObjectTreeNode)this.getValueAt(row, 0)).getUserObject()) != null) {
                    return this.getDefaultRenderer(o.getClass());
                }
                return super.getCellRenderer(row, column);
            }

            public TableCellEditor getCellEditor(int row, int column) {
                Object o;
                if (column == 2 && (o = ((ObjectTreeNode)this.getValueAt(row, 0)).getUserObject()) != null) {
                    return this.getDefaultEditor(o.getClass());
                }
                return super.getCellEditor(row, column);
            }
        };
        this._tt.setDefaultRenderer(Date.class, new DateRenderer());
        ArrayRenderer ar = new ArrayRenderer();
        this._tt.setDefaultRenderer([B.class, ar);
        this._tt.setDefaultEditor(Date.class, new DateEditor());
        this._tt.setCellSelectionEnabled(true);
        this.ttScrollPane.setViewportView(this._tt);
        this.setEditable(false);
    }

    public void setObject(Object object) {
        this._ottm.setObject(object);
    }

    private void stopEditing() {
        Component comp = this._tt.getEditorComponent();
        if (comp != null && comp instanceof CellEditor) {
            ((CellEditor)((Object)comp)).stopCellEditing();
        }
    }

    public Object getObject() {
        if (this._editable) {
            this.stopEditing();
        }
        return this._ottm.getObject();
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        this._ottm.setEditable(editable);
        this.insertButton.setVisible(editable);
        this.childButton.setVisible(editable);
        this.deleteButton.setVisible(editable);
        this.revalidate();
        this.repaint();
    }

    public boolean isModified() {
        if (this._editable) {
            this.stopEditing();
        }
        return this._editable && this._ottm.isModified();
    }

    private void initComponents() {
        this.ttScrollPane = new JScrollPane();
        this.insertButton = new JButton();
        this.childButton = new JButton();
        this.deleteButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.ttScrollPane.setMinimumSize(new Dimension(300, 200));
        this.ttScrollPane.setPreferredSize(new Dimension(300, 200));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.ttScrollPane, gridBagConstraints);
        this.insertButton.setText("Insert");
        this.insertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectPanel.this.insertButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.insertButton, gridBagConstraints);
        this.childButton.setText("New Child");
        this.childButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectPanel.this.childButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.childButton, gridBagConstraints);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ObjectPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.deleteButton, gridBagConstraints);
    }

    private void childButtonActionPerformed(ActionEvent evt) {
        TreePath path = this._tt.getTree().getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(null, "Please select a row", "No selection", 0);
            return;
        }
        ObjectTreeNode selected = (ObjectTreeNode)path.getLastPathComponent();
        Object userObject = selected.getUserObject();
        if (userObject instanceof Map) {
            String key = JOptionPane.showInputDialog("Please input a key value");
            if (key == null) {
                return;
            }
            Map map = (Map)userObject;
            if (map.containsKey(key)) {
                JOptionPane.showMessageDialog(null, "The Map already contains " + key, "Key exists", 0);
                return;
            }
            map.put(key, null);
            Iterator it = map.keySet().iterator();
            int position = 0;
            while (it.hasNext() && it.next() != key) {
                ++position;
            }
            ObjectTreeNode newNode = new ObjectTreeNode(null);
            newNode.setParentKey(key);
            selected.insert(newNode, position);
            this._ottm.nodesWereInserted(selected, new int[]{position});
        } else if (userObject instanceof List) {
            List list = (List)userObject;
            int position = list.size();
            list.add(position, null);
            ObjectTreeNode newNode = new ObjectTreeNode(null);
            newNode.setParentKey(new Integer(position));
            selected.insert(newNode, position);
            this._ottm.nodesWereInserted(selected, new int[]{position});
        }
    }

    private void insertButtonActionPerformed(ActionEvent evt) {
        TreePath path = this._tt.getTree().getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(null, "Please select a row", "No selection", 0);
            return;
        }
        ObjectTreeNode selected = (ObjectTreeNode)path.getLastPathComponent();
        ObjectTreeNode parent = (ObjectTreeNode)selected.getParent();
        if (parent == null) {
            JOptionPane.showMessageDialog(null, "It is not possible to insert a node at the root", "Error", 0);
            return;
        }
        Object parentObject = parent.getUserObject();
        if (parentObject instanceof List) {
            List list = (List)parentObject;
            int position = (Integer)selected.getParentKey();
            list.add(position, null);
            ObjectTreeNode newNode = new ObjectTreeNode(null);
            newNode.setParentKey(new Integer(position));
            parent.insert(newNode, position);
            this._ottm.nodesWereInserted(parent, new int[]{position});
            int[] changes = new int[parent.getChildCount() - (position + 1)];
            for (int i = position + 1; i < parent.getChildCount(); ++i) {
                ObjectTreeNode sib = (ObjectTreeNode)parent.getChildAt(i);
                sib.setParentKey(new Integer(i));
                changes[i - (position + 1)] = i;
            }
            this._ottm.nodesChanged(parent, changes);
        } else if (parentObject.getClass().isArray()) {
            JOptionPane.showMessageDialog(null, "Don't know how to insert a node into an Array yet", "Error", 0);
        } else {
            JOptionPane.showMessageDialog(null, "It is only possible to insert a node into a List", "Error", 0);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        TreePath path = this._tt.getTree().getSelectionPath();
        if (path == null) {
            JOptionPane.showMessageDialog(null, "Please select a row", "No selection", 0);
            return;
        }
        ObjectTreeNode selected = (ObjectTreeNode)path.getLastPathComponent();
        ObjectTreeNode parent = (ObjectTreeNode)selected.getParent();
        if (parent == null) {
            this._ottm.setObject(null);
            return;
        }
        Object parentObject = parent.getUserObject();
        if (!(parentObject instanceof List) && !(parentObject instanceof Map)) {
            JOptionPane.showMessageDialog(null, "We can only delete children of java.util.List and java.util.Map", "Error", 0);
            return;
        }
        if (parentObject instanceof Map) {
            Map map = (Map)parentObject;
            Object key = selected.getParentKey();
            int position = parent.getIndex(selected);
            try {
                map.remove(key);
            }
            catch (UnsupportedOperationException uoe) {
                JOptionPane.showMessageDialog(null, "Map returned an UnsupportedOperationException trying to remove " + key, "Error", 0);
                return;
            }
            parent.remove(position);
            this._ottm.nodesWereRemoved(parent, new int[]{position}, new Object[]{selected});
        } else if (parentObject instanceof List) {
            List list = (List)parentObject;
            int position = parent.getIndex(selected);
            try {
                list.remove(position);
            }
            catch (UnsupportedOperationException uoe) {
                JOptionPane.showMessageDialog(null, "List returned an UnsupportedOperationException trying to remove " + position, "Error", 0);
                return;
            }
            parent.remove(position);
            this._ottm.nodesWereRemoved(parent, new int[]{position}, new Object[]{selected});
        }
    }

    public static void main(String[] args) {
        ArrayList<Object> a = new ArrayList<Object>();
        a.add(new String("the string"));
        a.add(new Integer(123));
        a.add(new Boolean(true));
        TreeMap<String, Object> m = new TreeMap<String, Object>();
        m.put("a string", new String("value 1"));
        m.put("a boolean", new Boolean(false));
        m.put("a byte array", new byte[]{0, 1});
        a.add(m);
        a.add(new int[]{1001, 1002, 1003});
        a.add(new ArrayList());
        a.add(null);
        HashSet<Object> s = new HashSet<Object>();
        s.add(new Integer(7));
        s.add(new Boolean(true));
        s.add(new String("a new String"));
        a.add(s);
        a.add(new Date());
        a.add(new byte[]{0, 1, 2, 3});
        JFrame top = new JFrame("Object Panel");
        top.getContentPane().setLayout(new BorderLayout());
        top.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        JButton button = new JButton("GET");
        final ObjectPanel op = new ObjectPanel();
        top.getContentPane().add(op);
        top.getContentPane().add((Component)button, "South");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println(op.getObject());
            }
        });
        top.setBounds(100, 100, 600, 400);
        top.setVisible(true);
        try {
            op.setEditable(false);
            op.setObject(a);
            op.setEditable(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ArrayRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -4882652613205132057L;

        public void setValue(Object value) {
            if (value.getClass().isArray()) {
                StringBuffer buff = new StringBuffer();
                buff.append("{");
                int length = Array.getLength(value);
                if (length > 0) {
                    buff.append(Array.get(value, 0));
                }
                for (int i = 1; i < length; ++i) {
                    buff.append(", ").append(Array.get(value, i));
                }
                buff.append("}");
                this.setText(buff.toString());
            } else {
                this.setText(value == null ? "" : value.toString());
            }
        }
    }

    private class DateEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1964260936777401751L;
        private Object _value = null;
        private JTextField _textField = new JTextField();
        private DateFormat _df = DateFormat.getDateTimeInstance();
        private int clickCountToStart = 2;

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
            }
            return true;
        }

        public Object getCellEditorValue() {
            try {
                return this._df.parse(this._textField.getText());
            }
            catch (ParseException pe) {
                System.err.println("Parse Error : " + pe);
                return this._value;
            }
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this._value = value;
            this._textField.setText(this._df.format(value));
            return this._textField;
        }
    }

    private class DateRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 7004833139749646236L;
        private DateFormat _df;

        public void setValue(Object value) {
            if (this._df == null) {
                this._df = DateFormat.getDateTimeInstance();
            }
            this.setText(value == null ? "" : this._df.format(value));
        }
    }

    private class ObjectTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -3998840936827564434L;
        private Object _key;

        public ObjectTreeNode(Object object) {
            super(object);
            this._key = null;
            if (object instanceof Collection || object instanceof Map) {
                this.setAllowsChildren(true);
            } else if (object != null && object.getClass().isArray()) {
                this.setAllowsChildren(true);
            } else {
                this.setAllowsChildren(false);
            }
        }

        public void setParentKey(Object key) {
            this._key = key;
        }

        public Object getParentKey() {
            return this._key;
        }

        public String toString() {
            return this.getParent() == null ? "root" : (this._key == null ? "null" : this._key.toString());
        }
    }

    private class ObjectTreeTableModel
    extends DefaultTreeTableModel {
        private static final long serialVersionUID = -310076954129946613L;
        private boolean _modified;
        private boolean _editable;
        private String[] _columnNames;

        public ObjectTreeTableModel() {
            super(null, true);
            this._modified = false;
            this._editable = false;
            this._columnNames = new String[]{"Key", "Class", "Value"};
        }

        public ObjectTreeTableModel(Object object) {
            super(null, true);
            this._modified = false;
            this._editable = false;
            this._columnNames = new String[]{"Key", "Class", "Value"};
            this.setObject(object);
        }

        public void setEditable(boolean editable) {
            this._editable = editable;
        }

        public void setObject(Object object) {
            ObjectTreeNode root = this.createObjectTree(object);
            this.setRoot(root);
            this.nodeStructureChanged(root);
            this._modified = false;
        }

        public boolean isModified() {
            return this._modified;
        }

        public Object getObject() {
            Object root = this.getRoot();
            return root == null ? null : ((ObjectTreeNode)root).getUserObject();
        }

        private ObjectTreeNode createObjectTree(Object object) {
            ObjectTreeNode otn;
            block5: {
                block6: {
                    block4: {
                        otn = new ObjectTreeNode(object);
                        if (object == null) {
                            return otn;
                        }
                        if (!(object instanceof Collection)) break block4;
                        Collection collection = (Collection)object;
                        Iterator it = collection.iterator();
                        int count = 0;
                        while (it.hasNext()) {
                            ObjectTreeNode child = this.createObjectTree(it.next());
                            child.setParentKey(new Integer(count++));
                            otn.add(child);
                        }
                        break block5;
                    }
                    if (!(object instanceof Map)) break block6;
                    Map map = (Map)object;
                    Iterator it = map.keySet().iterator();
                    while (it.hasNext()) {
                        Object key = it.next();
                        ObjectTreeNode child = this.createObjectTree(map.get(key));
                        child.setParentKey(key);
                        otn.add(child);
                    }
                    break block5;
                }
                if (!object.getClass().isArray()) break block5;
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ObjectTreeNode child = new ObjectTreeNode(Array.get(object, i));
                    child.setParentKey(new Integer(i));
                    otn.add(child);
                }
            }
            return otn;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            return this._columnNames[column];
        }

        public Object getValueAt(Object node, int column) {
            ObjectTreeNode otn = (ObjectTreeNode)node;
            Object object = otn.getUserObject();
            ObjectTreeNode parent = (ObjectTreeNode)otn.getParent();
            Object parentObject = null;
            if (parent != null) {
                parentObject = parent.getUserObject();
            }
            switch (column) {
                case 0: {
                    return node;
                }
                case 1: {
                    if (object == null) {
                        return "void";
                    }
                    if (object.getClass().isArray()) {
                        return object.getClass().getComponentType() + "[]";
                    }
                    if (parentObject != null && parentObject.getClass().isArray()) {
                        return parentObject.getClass().getComponentType().getName();
                    }
                    return object.getClass().getName();
                }
                case 2: {
                    return this.describe(object);
                }
            }
            return null;
        }

        private Object describe(Object object) {
            if (object == null) {
                return "";
            }
            if (object instanceof Map) {
                int size = ((Map)object).size();
                return size + " item" + (size != 1 ? "s" : "");
            }
            if (object instanceof Collection) {
                int size = ((Collection)object).size();
                return size + " item" + (size != 1 ? "s" : "");
            }
            if (object.getClass().isArray()) {
                int size = Array.getLength(object);
                return size + " item" + (size != 1 ? "s" : "");
            }
            return object;
        }

        public boolean isCellEditable(Object node, int columnIndex) {
            if (columnIndex == 0) {
                return true;
            }
            if (columnIndex == 1 && this._editable) {
                Object parentObject;
                ObjectTreeNode parent = (ObjectTreeNode)((ObjectTreeNode)node).getParent();
                return parent == null || !(parentObject = parent.getUserObject()).getClass().isArray();
            }
            if (columnIndex == 2 && this._editable) {
                Object object = ((ObjectTreeNode)node).getUserObject();
                if (object == null) {
                    return false;
                }
                if (object instanceof Collection || object instanceof Map || object.getClass().isArray()) {
                    return false;
                }
                ObjectTreeNode parent = (ObjectTreeNode)((ObjectTreeNode)node).getParent();
                if (parent != null) {
                    Object parentObject = parent.getUserObject();
                    return parentObject instanceof List || parentObject instanceof Map || parentObject.getClass().isArray();
                }
                return true;
            }
            return false;
        }

        private Object newObjectOfClass(String theClass) {
            try {
                Class<?>[] params;
                int i;
                Class<?> aClass = Class.forName(theClass);
                Constructor<?>[] constructors = aClass.getConstructors();
                if (constructors.length == 0) {
                    System.err.println(theClass + " has no constructors");
                    return null;
                }
                for (i = 0; i < constructors.length; ++i) {
                    if (!Modifier.isPublic(constructors[i].getModifiers()) || (params = constructors[i].getParameterTypes()).length != 0) continue;
                    return constructors[i].newInstance(new Object[0]);
                }
                for (i = 0; i < constructors.length; ++i) {
                    if (!Modifier.isPublic(constructors[i].getModifiers()) || (params = constructors[i].getParameterTypes()).length != 1) continue;
                    if (params[0] == Boolean.TYPE) {
                        return constructors[i].newInstance(new Boolean(false));
                    }
                    if (params[0] == (class$java$lang$String == null ? ObjectPanel.class$("java.lang.String") : class$java$lang$String) && (class$java$lang$Number == null ? ObjectPanel.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(aClass)) {
                        return constructors[i].newInstance(new String("0"));
                    }
                    if (params[0] != Character.TYPE) continue;
                    return constructors[i].newInstance(new Character('a'));
                }
                StringBuffer buff = new StringBuffer();
                for (int i2 = 0; i2 < constructors.length; ++i2) {
                    Class<?>[] params2 = constructors[i2].getParameterTypes();
                    buff.append(Modifier.toString(constructors[i2].getModifiers()) + " " + theClass + "(" + params2[0].getName());
                    for (int j = 1; j < params2.length; ++j) {
                        buff.append(", " + params2[j].getName());
                    }
                    buff.append(");\n");
                }
                System.err.println("Cannot instantiate a " + theClass);
                System.err.println("Please special case this in newObjectOfClass() using one of the following constructors");
                System.err.print(buff);
            }
            catch (Exception e) {
                System.err.println("Error instantiating the new object : " + e);
            }
            return null;
        }

        private Object convertValueToClass(Object value, Class theClass) {
            if (theClass == value.getClass()) {
                return value;
            }
            if (value instanceof String) {
                String string = (String)value;
                if ((class$java$lang$Number == null ? (class$java$lang$Number = ObjectPanel.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(theClass)) {
                    try {
                        if (theClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = ObjectPanel.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                            return new Byte(string);
                        }
                        if (value == (class$java$lang$Double == null ? (class$java$lang$Double = ObjectPanel.class$("java.lang.Double")) : class$java$lang$Double)) {
                            return new Double(string);
                        }
                        if (theClass == (class$java$lang$Float == null ? (class$java$lang$Float = ObjectPanel.class$("java.lang.Float")) : class$java$lang$Float)) {
                            return new Float(string);
                        }
                        if (theClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = ObjectPanel.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                            return new Integer(string);
                        }
                        if (theClass == (class$java$lang$Long == null ? (class$java$lang$Long = ObjectPanel.class$("java.lang.Long")) : class$java$lang$Long)) {
                            return new Long(string);
                        }
                        if (theClass == (class$java$lang$Short == null ? (class$java$lang$Short = ObjectPanel.class$("java.lang.Short")) : class$java$lang$Short)) {
                            return new Short(string);
                        }
                        if (theClass == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ObjectPanel.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                            return new BigDecimal(string);
                        }
                        if (theClass == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = ObjectPanel.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
                            return new BigInteger(string);
                        }
                        return null;
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Can't parse '" + string + "' as a " + theClass);
                        return null;
                    }
                }
                if (theClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ObjectPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return Boolean.valueOf(string);
                }
                if (theClass == (class$java$lang$Character == null ? (class$java$lang$Character = ObjectPanel.class$("java.lang.Character")) : class$java$lang$Character)) {
                    if (string.length() > 0) {
                        return new Character(string.charAt(0));
                    }
                    return null;
                }
                if (theClass == (class$java$util$Date == null ? (class$java$util$Date = ObjectPanel.class$("java.util.Date")) : class$java$util$Date)) {
                    try {
                        return DateFormat.getDateTimeInstance().parse(string);
                    }
                    catch (ParseException pe) {
                        System.err.println("Couldn't parse a date from '" + string + "' : " + pe);
                        return null;
                    }
                }
            }
            System.err.println("Don't know how to convert a " + value.getClass().getName() + " to a " + theClass.getName());
            System.err.println("Please update convertValueToClass() to support this if it is required");
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValueAt(Object aValue, Object node, int column) {
            ObjectTreeNode child = (ObjectTreeNode)node;
            Object childObject = child.getUserObject();
            ObjectTreeNode parent = (ObjectTreeNode)child.getParent();
            Object parentObject = null;
            int childPosition = -1;
            if (parent != null) {
                parentObject = parent.getUserObject();
                childPosition = parent.getIndex(child);
            }
            Object key = child.getParentKey();
            if (!(parentObject == null || parentObject instanceof List || parentObject instanceof Map || parentObject.getClass().isArray())) {
                System.err.println("I only know how to edit children of List or Map, not " + parentObject.getClass().getName());
                return;
            }
            if (column == 0) {
                System.err.println("Trying to edit the tree?!");
            } else if (column == 1) {
                String type = (String)aValue;
                if ((childObject != null || type.equals("void")) && (childObject == null || type.equals(childObject.getClass().getName()))) return;
                if (type.equals("void")) {
                    childObject = null;
                } else {
                    childObject = this.newObjectOfClass(type);
                    if (childObject == null) {
                        return;
                    }
                }
            } else {
                if (column != 2) throw new IndexOutOfBoundsException("Tried to edit column " + column);
                if (childObject == null) {
                    System.err.println("Please change the object type to a non-void class first!");
                    return;
                }
                if ((childObject = this.convertValueToClass(aValue, childObject.getClass())) == null) {
                    return;
                }
            }
            child = this.createObjectTree(childObject);
            child.setParentKey(key);
            if (parent != null) {
                if (parentObject instanceof List) {
                    List list = (List)parentObject;
                    list.set(childPosition, childObject);
                } else if (parentObject instanceof Map) {
                    Map map = (Map)parentObject;
                    map.put(key, childObject);
                } else if (parentObject.getClass().isArray()) {
                    Array.set(parentObject, (Integer)key, childObject);
                } else {
                    System.err.println("Shouldn't get here! ParentObject is a " + parentObject.getClass());
                    return;
                }
                this._modified = true;
                parent.remove(childPosition);
                parent.insert(child, childPosition);
                this.nodesChanged(parent, new int[]{childPosition});
                return;
            } else {
                this._modified = true;
                this.setRoot(child);
            }
        }

        public void nodesWereInserted(TreeNode node, int[] childIndices) {
            super.nodesWereInserted(node, childIndices);
            this._modified = true;
        }

        public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
            super.nodesWereRemoved(node, childIndices, removedChildren);
            this._modified = true;
        }

        public void nodesChanged(TreeNode node, int[] childIndices) {
            super.nodesChanged(node, childIndices);
            this._modified = true;
        }

        public void nodeChanged(TreeNode node) {
            super.nodeChanged(node);
            this._modified = true;
        }

        public void nodeStructureChanged(TreeNode node) {
            super.nodeStructureChanged(node);
            this._modified = true;
        }
    }
}

