/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.UrlEvent;
import org.owasp.webscarab.model.UrlListener;
import org.owasp.webscarab.model.UrlModel;
import org.owasp.webscarab.util.swing.AbstractTreeModel;

public class UrlTreeModelAdapter
extends AbstractTreeModel {
    protected UrlModel _model;
    private Listener _listener = new Listener();
    protected Logger _logger = Logger.getLogger(this.getClass().getName());
    private Object _root = new String("RooT");

    public UrlTreeModelAdapter(UrlModel model) {
        this._model = model;
        this._model.addUrlListener(this._listener);
    }

    public Object getRoot() {
        return this._root;
    }

    public Object getChild(Object parent, int index) {
        if (this._model == null) {
            throw new NullPointerException("Getting a child when the model is null!");
        }
        if (parent == this.getRoot()) {
            parent = null;
        }
        return this._model.getChildAt((HttpUrl)parent, index);
    }

    public int getChildCount(Object parent) {
        if (this._model == null) {
            return 0;
        }
        if (parent == this.getRoot()) {
            parent = null;
        }
        return this._model.getChildCount((HttpUrl)parent);
    }

    public boolean isLeaf(Object node) {
        if (node == this.getRoot()) {
            return false;
        }
        HttpUrl url = (HttpUrl)node;
        if (url.getParameters() != null) {
            return true;
        }
        if (url.getPath().endsWith("/")) {
            return false;
        }
        return this.getChildCount(url) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    protected TreePath urlTreePath(HttpUrl url) {
        Object root = this.getRoot();
        if (url == null || url == root) {
            return new TreePath(root);
        }
        HttpUrl[] urlPath = url.getUrlHierarchy();
        Object[] path = new Object[urlPath.length + 1];
        path[0] = root;
        System.arraycopy(urlPath, 0, path, 1, urlPath.length);
        return new TreePath(path);
    }

    private class Listener
    implements UrlListener {
        private Listener() {
        }

        public void urlAdded(final UrlEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                HttpUrl url = evt.getUrl();
                HttpUrl parent = url.getParentUrl();
                int index = UrlTreeModelAdapter.this.getIndexOfChild(parent, url);
                UrlTreeModelAdapter.this.fireChildAdded(UrlTreeModelAdapter.this.urlTreePath(parent), index, url);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            Listener.this.urlAdded(evt);
                        }
                    });
                }
                catch (Exception e) {
                    UrlTreeModelAdapter.this._logger.warning("Exception processing " + evt + " " + e);
                    e.getCause().printStackTrace();
                }
            }
        }

        public void urlChanged(UrlEvent evt) {
            if (!SwingUtilities.isEventDispatchThread()) {
                return;
            }
            HttpUrl url = evt.getUrl();
            HttpUrl parent = url.getParentUrl();
            int index = UrlTreeModelAdapter.this.getIndexOfChild(parent, url);
            UrlTreeModelAdapter.this.fireChildChanged(UrlTreeModelAdapter.this.urlTreePath(parent), index, url);
        }

        public void urlRemoved(final UrlEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                HttpUrl sibling;
                HttpUrl url = evt.getUrl();
                HttpUrl parent = url.getParentUrl();
                int pos = 0;
                int count = UrlTreeModelAdapter.this.getChildCount(parent);
                for (int i = 0; i < count && url.compareTo(sibling = (HttpUrl)UrlTreeModelAdapter.this.getChild(parent, i)) >= 0; ++i) {
                    ++pos;
                }
                UrlTreeModelAdapter.this.fireChildRemoved(UrlTreeModelAdapter.this.urlTreePath(parent), pos, url);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            Listener.this.urlRemoved(evt);
                        }
                    });
                }
                catch (Exception e) {
                    UrlTreeModelAdapter.this._logger.warning("Exception processing " + evt + " " + e);
                    e.getCause().printStackTrace();
                }
            }
        }

        public void urlsChanged() {
            if (SwingUtilities.isEventDispatchThread()) {
                UrlTreeModelAdapter.this.fireStructureChanged();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            Listener.this.urlsChanged();
                        }
                    });
                }
                catch (Exception e) {
                    UrlTreeModelAdapter.this._logger.warning("Exception processing event: " + e);
                    e.getCause().printStackTrace();
                }
            }
        }
    }
}

