/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationModel;

public class ConversationRenderer
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = -5962129823533074346L;
    private ConversationModel _conversationModel;

    public ConversationRenderer(ConversationModel conversationModel) {
        this._conversationModel = conversationModel;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        ConversationID id = (ConversationID)value;
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (id == null) {
            this.setText("");
            return this;
        }
        if (this._conversationModel == null) {
            this.setText(id.toString());
            return this;
        }
        StringBuffer text = new StringBuffer();
        text.append(id).append(" - ");
        text.append(this._conversationModel.getRequestMethod(id)).append(" ");
        text.append(this._conversationModel.getRequestUrl(id).getSHPP()).append("    ");
        text.append(this._conversationModel.getResponseStatus(id));
        this.setText(text.toString());
        return this;
    }
}

