/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.search;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.owasp.webscarab.model.AbstractConversationModel;
import org.owasp.webscarab.model.ConversationEvent;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationListener;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.plugin.AbstractPluginModel;

public class SearchModel
extends AbstractPluginModel {
    public static final String PROPERTY_FILTER = "Filter";
    public static final String PROPERTY_SEARCHES = "Searches";
    private FrameworkModel _model;
    private SearchConversationModel _conversationModel;
    private Map _searches = new TreeMap();
    private String _description = null;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public SearchModel(FrameworkModel model) {
        this._model = model;
        this._conversationModel = new SearchConversationModel(this._model);
    }

    public ConversationModel getConversationModel() {
        return this._conversationModel;
    }

    public Sync readLock() {
        return this._rwl.readLock();
    }

    public void addSearch(String description, String expression) {
        this._logger.info("Adding search " + description);
        this._searches.put(description, expression);
        this._changeSupport.firePropertyChange(PROPERTY_SEARCHES, null, null);
    }

    public String[] getSearches() {
        return this._searches.keySet().toArray(new String[this._searches.size()]);
    }

    public String getSearchExpression(String description) {
        return (String)this._searches.get(description);
    }

    public void removeSearch(String description) {
        this._searches.remove(description);
        this._changeSupport.firePropertyChange(PROPERTY_SEARCHES, null, null);
    }

    public void setFilter(String description) {
        if (this._description != null || description != null) {
            if (this._description == null || description == null) {
                this.changeFilter(description);
            } else if (!this._description.equals(description)) {
                this.changeFilter(description);
            }
        }
    }

    private void changeFilter(String description) {
        try {
            this._rwl.writeLock().acquire();
            String old = this._description;
            this._description = description;
            this._conversationModel.refilter();
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            this._changeSupport.firePropertyChange(PROPERTY_FILTER, old, description);
            this._conversationModel.fireConversationsChanged();
            this._rwl.readLock().release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSearchMatch(ConversationID id, String description, boolean matches) {
        if (matches) {
            this._model.addConversationProperty(id, "SEARCH", description);
        } else {
            String[] searches = this._model.getConversationProperties(id, "SEARCH");
            if (searches != null) {
                this._model.setConversationProperty(id, "SEARCH", null);
                for (int i = 0; i < searches.length; ++i) {
                    if (searches[i].equals(description)) continue;
                    this._model.addConversationProperty(id, "SEARCH", searches[i]);
                }
            }
        }
    }

    public boolean hasSearchMatch(ConversationID id, String description) {
        if (description == null) {
            return false;
        }
        String[] searches = this._model.getConversationProperties(id, "SEARCH");
        if (searches == null) {
            return false;
        }
        for (int i = 0; i < searches.length; ++i) {
            if (!searches[i].equals(description)) continue;
            return true;
        }
        return false;
    }

    private class SearchConversationModel
    extends AbstractConversationModel {
        private List _conversations;

        public SearchConversationModel(FrameworkModel model) {
            super(model);
            this._conversations = new ArrayList();
            model.getConversationModel().addConversationListener(new Listener());
        }

        public void refilter() {
            this._conversations.clear();
            if (SearchModel.this._description != null) {
                ConversationModel cmodel = SearchModel.this._model.getConversationModel();
                int count = cmodel.getConversationCount();
                for (int i = 0; i < count; ++i) {
                    ConversationID id = cmodel.getConversationAt(i);
                    if (!SearchModel.this.hasSearchMatch(id, SearchModel.this._description)) continue;
                    this._conversations.add(id);
                }
            }
        }

        public ConversationID getConversationAt(int index) {
            return (ConversationID)this._conversations.get(index);
        }

        public int getConversationCount() {
            return this._conversations.size();
        }

        public int getIndexOfConversation(ConversationID id) {
            return this._conversations.indexOf(id);
        }

        public Sync readLock() {
            return SearchModel.this._rwl.readLock();
        }

        public void fireConversationsChanged() {
            super.fireConversationsChanged();
        }

        private class Listener
        implements ConversationListener {
            private Listener() {
            }

            public void conversationAdded(ConversationEvent evt) {
            }

            public void conversationChanged(ConversationEvent evt) {
                ConversationID id = evt.getConversationID();
                int index = Collections.binarySearch(SearchConversationModel.this._conversations, id);
                if (SearchModel.this.hasSearchMatch(id, SearchModel.this._description)) {
                    if (index < 0) {
                        index = -index - 1;
                        try {
                            SearchModel.this._rwl.writeLock().acquire();
                            SearchConversationModel.this._conversations.add(index, id);
                            SearchModel.this._rwl.readLock().acquire();
                            SearchModel.this._rwl.writeLock().release();
                            SearchConversationModel.this.fireConversationAdded(id, index);
                            SearchModel.this._rwl.readLock().release();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (index >= 0) {
                    try {
                        SearchModel.this._rwl.writeLock().acquire();
                        SearchConversationModel.this._conversations.remove(index);
                        SearchModel.this._rwl.readLock().acquire();
                        SearchModel.this._rwl.writeLock().release();
                        SearchConversationModel.this.fireConversationRemoved(id, index);
                        SearchModel.this._rwl.readLock().release();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            public void conversationRemoved(ConversationEvent evt) {
                ConversationID id = evt.getConversationID();
                int index = Collections.binarySearch(SearchConversationModel.this._conversations, id);
                if (index > -1) {
                    try {
                        SearchModel.this._rwl.writeLock().acquire();
                        SearchConversationModel.this._conversations.remove(index);
                        SearchModel.this._rwl.readLock().acquire();
                        SearchModel.this._rwl.writeLock().release();
                        SearchConversationModel.this.fireConversationRemoved(id, index);
                        SearchModel.this._rwl.readLock().release();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            public void conversationsChanged() {
                SearchModel.this.setFilter(null);
            }
        }
    }
}

