/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.scripted;

import java.io.IOException;
import java.net.MalformedURLException;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.scripted.Scripted;

public class ScriptedObjectModel {
    private Framework _framework;
    private FrameworkModel _model;
    private Scripted _scripted;

    public ScriptedObjectModel(Framework framework, Scripted scripted) {
        this._framework = framework;
        this._model = this._framework.getModel();
        this._scripted = scripted;
    }

    public ConversationID addConversation(Response response) {
        return this._framework.addConversation(response.getRequest(), response, "Scripted");
    }

    public Request getRequest(int id) {
        return this.getRequest(new ConversationID(id));
    }

    public Request getRequest(ConversationID id) {
        Request request = this._model.getRequest(id);
        if (request == null) {
            return request;
        }
        return new Request(request);
    }

    public Response getResponse(int id) {
        return this.getResponse(new ConversationID(id));
    }

    public Response getResponse(ConversationID id) {
        Response response = this._model.getResponse(id);
        if (response == null) {
            return response;
        }
        return new Response(response);
    }

    public int getChildCount(String url) throws MalformedURLException {
        HttpUrl myUrl = null;
        if (url != null) {
            myUrl = new HttpUrl(url);
        }
        return this._model.getUrlModel().getChildCount(myUrl);
    }

    public HttpUrl getChildAt(String url, int index) throws MalformedURLException {
        HttpUrl myUrl = null;
        if (url != null) {
            myUrl = new HttpUrl(url);
        }
        return this._model.getUrlModel().getChildAt(myUrl, index);
    }

    public String getUrlProperty(String url, String property) throws MalformedURLException {
        HttpUrl myUrl = null;
        if (url != null) {
            myUrl = new HttpUrl(url);
        }
        return this._model.getUrlProperty(myUrl, property);
    }

    public int getConversationCount() {
        return this._model.getConversationModel().getConversationCount();
    }

    public ConversationID getConversationAt(int index) {
        return this._model.getConversationModel().getConversationAt(index);
    }

    public String getConversationProperty(int id, String property) {
        return this.getConversationProperty(new ConversationID(id), property);
    }

    public String getConversationProperty(ConversationID id, String property) {
        return this._model.getConversationProperty(id, property);
    }

    public Response fetchResponse(Request request) throws IOException {
        return this._scripted.fetchResponse(request);
    }

    public boolean hasAsyncCapacity() {
        return this._scripted.hasAsyncCapacity();
    }

    public void submitAsyncRequest(Request request) {
        this._scripted.submitAsyncRequest(request);
    }

    public boolean isAsyncBusy() {
        return this._scripted.isAsyncBusy();
    }

    public boolean hasAsyncResponse() {
        return this._scripted.hasAsyncResponse();
    }

    public Response getAsyncResponse() throws IOException {
        return this._scripted.getAsyncResponse();
    }
}

