/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.scripted;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.owasp.webscarab.httpclient.ConversationHandler;
import org.owasp.webscarab.httpclient.FetcherQueue;
import org.owasp.webscarab.httpclient.HTTPClientFactory;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.FrameworkModelWrapper;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Plugin;
import org.owasp.webscarab.plugin.scripted.ScriptedObjectModel;
import org.owasp.webscarab.plugin.scripted.ScriptedUI;

public class Scripted
implements Plugin,
ConversationHandler {
    private Framework _framework;
    private ScriptedUI _ui = null;
    private File _scriptFile = null;
    private String _script = null;
    private String _scriptLanguage = null;
    private BSFManager _bsfManager = new BSFManager();
    private Thread _pluginThread = null;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private boolean _running = false;
    private boolean _stopping = false;
    private boolean _runScript = false;
    private String _status = "Stopped";
    private Object _lock = new Object();
    private ScriptedObjectModel _som;
    private FrameworkModelWrapper _wrapper;
    private int _threads = 4;
    private FetcherQueue _fetcherQueue = null;
    private List _responseQueue = new ArrayList();
    private PrintStream _out = System.out;
    private PrintStream _err = System.err;

    public Scripted(Framework framework) {
        this._framework = framework;
        this._som = new ScriptedObjectModel(this._framework, this);
        this._wrapper = new FrameworkModelWrapper(this._framework.getModel());
        try {
            String defaultScript = Preferences.getPreference("Scripted.script");
            if (defaultScript != null && !defaultScript.equals("")) {
                this.loadScript(new File(defaultScript));
            } else {
                InputStream is = this.getClass().getResourceAsStream("script.bsh");
                String language = "beanshell";
                if (is == null) {
                    return;
                }
                this.loadScript(language, new InputStreamReader(is));
            }
        }
        catch (IOException ioe) {
            this._logger.warning("Error loading default script" + ioe.getMessage());
        }
    }

    public void setUI(ScriptedUI ui) {
        this._ui = ui;
        if (this._ui == null) {
            this._out = System.out;
            this._err = System.err;
        }
    }

    public void setOut(PrintStream out) {
        this._out = out != null ? out : System.out;
    }

    public void setErr(PrintStream err) {
        this._err = err;
    }

    public void loadScript(File file) throws IOException {
        if (file == null) {
            this._scriptFile = null;
            if (this._ui != null) {
                this._ui.scriptFileChanged(file);
            }
            this.setScript("", "");
            return;
        }
        String language = "Unknown";
        try {
            language = BSFManager.getLangFromFilename((String)file.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.loadScript(language, new FileReader(file));
        this._scriptFile = file;
        if (this._ui != null) {
            this._ui.scriptFileChanged(file);
        }
    }

    public void saveScript(File file) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(this._script);
        bw.close();
    }

    private void loadScript(String language, Reader reader) throws IOException {
        String line;
        this._scriptFile = null;
        this.setScript("", "");
        BufferedReader br = new BufferedReader(reader);
        StringBuffer script = new StringBuffer();
        while ((line = br.readLine()) != null) {
            script.append(line).append("\n");
        }
        br.close();
        this.setScript(language, script.toString());
    }

    public File getScriptFile() {
        return this._scriptFile;
    }

    public String getScriptLanguage() {
        return this._scriptLanguage;
    }

    public String getScript() {
        return this._script;
    }

    public void setScript(String language, String script) {
        this._scriptLanguage = language;
        this._script = script;
        if (this._ui != null) {
            this._ui.scriptLanguageChanged(language);
            this._ui.scriptChanged(script);
        }
    }

    public void analyse(ConversationID id, Request request, Response response, String origin) {
    }

    public void flush() throws StoreException {
    }

    public String getPluginName() {
        return "Scripted";
    }

    public String getStatus() {
        return this._status;
    }

    public boolean isBusy() {
        return false;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isRunning() {
        return this._running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this._pluginThread = Thread.currentThread();
        this._running = true;
        this._stopping = false;
        while (!this._stopping) {
            Object object;
            block12: {
                object = this._lock;
                synchronized (object) {
                    try {
                        this._status = "Idle";
                        this._lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this._runScript) continue;
                this._runScript = false;
                if (this._ui != null) {
                    this._ui.scriptStarted();
                }
                this._status = "Running";
                this._fetcherQueue = new FetcherQueue("Scripted", this, this._threads, 0);
                try {
                    this._bsfManager.declareBean("model", (Object)this._wrapper, this._wrapper.getClass());
                    this._bsfManager.declareBean("scripted", (Object)this._som, this._som.getClass());
                    this._bsfManager.declareBean("out", (Object)this._out, this._out.getClass());
                    this._bsfManager.declareBean("err", (Object)this._err, this._err.getClass());
                    this._bsfManager.exec(this._scriptLanguage, "Scripted", 0, 0, (Object)this._script);
                }
                catch (BSFException bsfe) {
                    if (this._ui == null) break block12;
                    this._ui.scriptError("Unknown reason", bsfe);
                }
            }
            this._fetcherQueue.stop();
            this._fetcherQueue = null;
            object = this._responseQueue;
            synchronized (object) {
                this._responseQueue.clear();
            }
            if (this._ui == null) continue;
            this._ui.scriptStopped();
        }
        this._running = false;
    }

    Response fetchResponse(Request request) throws IOException {
        return HTTPClientFactory.getInstance().fetchResponse(request);
    }

    boolean hasAsyncCapacity() {
        return this._fetcherQueue.getRequestsQueued() < this._threads;
    }

    void submitAsyncRequest(Request request) {
        this._fetcherQueue.submit(request);
    }

    boolean isAsyncBusy() {
        return this._fetcherQueue.isBusy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasAsyncResponse() {
        List list = this._responseQueue;
        synchronized (list) {
            return this._responseQueue.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestError(Request request, IOException ioe) {
        List list = this._responseQueue;
        synchronized (list) {
            this._responseQueue.add(ioe);
            this._responseQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseReceived(Response response) {
        List list = this._responseQueue;
        synchronized (list) {
            this._responseQueue.add(response);
            this._responseQueue.notify();
        }
    }

    Response getAsyncResponse() throws IOException {
        List list = this._responseQueue;
        synchronized (list) {
            while (this._responseQueue.size() == 0) {
                try {
                    this._responseQueue.wait();
                }
                catch (InterruptedException ie) {}
            }
            Object obj = this._responseQueue.remove(0);
            if (obj instanceof Response) {
                return (Response)obj;
            }
            throw (IOException)obj;
        }
    }

    public void setSession(String type, Object store, String session) throws StoreException {
    }

    public boolean stop() {
        this._running = false;
        this.stopScript();
        return !this._running;
    }

    public void stopScript() {
        if (this._pluginThread != null && this._pluginThread.isAlive()) {
            this._pluginThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript() {
        if (this._scriptLanguage != null && this._script != null) {
            this._runScript = true;
            Object object = this._lock;
            synchronized (object) {
                this._lock.notifyAll();
            }
        }
    }

    public Object getScriptableObject() {
        return null;
    }

    public Hook[] getScriptingHooks() {
        return new Hook[0];
    }
}

