/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.plugin.proxy.ListenerSpec;
import org.owasp.webscarab.plugin.proxy.Proxy;
import org.owasp.webscarab.plugin.proxy.ProxyUI;
import org.owasp.webscarab.plugin.proxy.swing.ListenerTableModel;
import org.owasp.webscarab.plugin.proxy.swing.ManualEditPanel;
import org.owasp.webscarab.plugin.proxy.swing.ProxyPluginUI;
import org.owasp.webscarab.ui.swing.SwingPluginUI;
import org.owasp.webscarab.util.W32WinInet;
import org.owasp.webscarab.util.swing.ColumnDataModel;

public class ProxyPanel
extends JPanel
implements SwingPluginUI,
ProxyUI {
    private static final long serialVersionUID = -3557927604958599392L;
    private Proxy _proxy;
    private ListenerTableModel _ltm;
    private MessageTableModel _mtm;
    private ArrayList _plugins;
    private ProxyPluginUI[] _pluginArray = new ProxyPluginUI[0];
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private JTextField addressTextField;
    private JTextField baseTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable listenerTable;
    private JTabbedPane mainTabbedPane;
    private JTable messageTable;
    private JComboBox networkComboBox;
    private JTextField portTextField;
    private JCheckBox primaryCheckBox;
    private JLabel primaryLabel;
    private JButton startButton;
    private JButton stopButton;

    public ProxyPanel(Proxy proxy) {
        this.initComponents();
        this._proxy = proxy;
        this._ltm = new ListenerTableModel(this._proxy);
        this.listenerTable.setModel(this._ltm);
        this.listenerTable.setSelectionMode(0);
        this._mtm = new MessageTableModel();
        this.messageTable.setModel(this._mtm);
        int[][] columnWidths = new int[][]{{200, 200, 200}, {50, 50, 50}, {50, 50, 50}, {250, 250, 250}};
        TableColumnModel columnModel = this.messageTable.getColumnModel();
        for (int i = 0; i < columnWidths.length; ++i) {
            columnModel.getColumn(i).setMinWidth(columnWidths[i][0]);
            columnModel.getColumn(i).setMaxWidth(columnWidths[i][1]);
            columnModel.getColumn(i).setPreferredWidth(columnWidths[i][2]);
        }
        this.networkComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Unlimited"}));
        this.networkComboBox.setSelectedItem("Unlimited");
        ListenerSpec[] proxies = this._proxy.getProxies();
        for (int i = 0; i < proxies.length; ++i) {
            this._ltm.proxyAdded(proxies[i]);
        }
        proxy.setUI(this);
        if (!W32WinInet.isAvailable()) {
            this.primaryLabel.setEnabled(false);
            this.primaryCheckBox.setEnabled(false);
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getPluginName() {
        return new String("Proxy");
    }

    public void addPlugin(ProxyPluginUI plugin) {
        if (this._plugins == null) {
            this._plugins = new ArrayList();
        }
        this._plugins.add(plugin);
        this._pluginArray = this._plugins.toArray(this._pluginArray);
        this.mainTabbedPane.add((Component)plugin.getPanel(), plugin.getPluginName());
        if (plugin instanceof ManualEditPanel) {
            this.mainTabbedPane.setSelectedIndex(this.mainTabbedPane.getTabCount() - 1);
        }
    }

    private void initComponents() {
        this.mainTabbedPane = new JTabbedPane();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.stopButton = new JButton();
        this.startButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.listenerTable = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.addressTextField = new JTextField();
        this.portTextField = new JTextField();
        this.baseTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.networkComboBox = new JComboBox();
        this.primaryLabel = new JLabel();
        this.primaryCheckBox = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.messageTable = new JTable();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.9);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.stopButton.setText("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxyPanel.this.stopButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.stopButton, gridBagConstraints);
        this.startButton.setText("Start");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxyPanel.this.startButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.startButton, gridBagConstraints);
        this.listenerTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.listenerTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        this.jLabel1.setText("Address");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        this.jLabel2.setText("Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setFont(new Font("Dialog", 0, 12));
        this.jLabel3.setText("Base URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.addressTextField.setToolTipText("Blank or \"*\" means all interfaces");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.addressTextField, gridBagConstraints);
        this.portTextField.setToolTipText("integer between 0 and 65536");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.jPanel1.add((Component)this.portTextField, gridBagConstraints);
        this.baseTextField.setToolTipText("Blank for a conventional proxy, or http://host:port for a reverse proxy.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.baseTextField, gridBagConstraints);
        this.jLabel5.setFont(new Font("Dialog", 0, 12));
        this.jLabel5.setText("Speed");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.networkComboBox.setFont(new Font("Dialog", 0, 12));
        this.networkComboBox.setMinimumSize(new Dimension(32, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.networkComboBox, gridBagConstraints);
        this.primaryLabel.setFont(new Font("Dialog", 0, 12));
        this.primaryLabel.setText("Primary?");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel1.add((Component)this.primaryLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel1.add((Component)this.primaryCheckBox, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jPanel3.setLayout(new BorderLayout());
        this.messageTable.setBackground(new Color(204, 204, 204));
        this.messageTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Time", "ID", "Method", "URL", "Status"}));
        this.messageTable.setAutoResizeMode(3);
        this.messageTable.setShowHorizontalLines(false);
        this.messageTable.setShowVerticalLines(false);
        this.jScrollPane2.setViewportView(this.messageTable);
        this.jPanel3.add((Component)this.jScrollPane2, "Center");
        this.jSplitPane1.setRightComponent(this.jPanel3);
        this.mainTabbedPane.addTab("Listeners", this.jSplitPane1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.mainTabbedPane, gridBagConstraints);
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        try {
            String address = this.addressTextField.getText();
            int port = Integer.parseInt(this.portTextField.getText().trim());
            HttpUrl base = null;
            if (!this.baseTextField.getText().equals("")) {
                base = new HttpUrl(this.baseTextField.getText());
            }
            boolean primary = this.primaryCheckBox.isSelected();
            ListenerSpec spec = new ListenerSpec(address, port, base, primary);
            spec.verifyAvailable();
            this._proxy.addListener(spec);
            this.addressTextField.setText("");
            this.portTextField.setText("");
            this.baseTextField.setText("");
        }
        catch (Exception e) {
            this._logger.severe("Error starting the listener : " + e);
            JOptionPane.showMessageDialog(null, new String[]{"Error starting proxy listener: ", e.toString()}, "Error", 0);
        }
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        int row = this.listenerTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        ListenerSpec spec = this._ltm.getListener(row);
        if (!this._proxy.removeListener(spec)) {
            this._logger.severe("Failed to stop " + spec);
        } else {
            this.addressTextField.setText(spec.getAddress());
            this.portTextField.setText(Integer.toString(spec.getPort()));
            this.baseTextField.setText(spec.getBase() == null ? "" : spec.getBase().toString());
            this.primaryCheckBox.setSelected(spec.isPrimaryProxy());
        }
    }

    public Action[] getConversationActions() {
        return null;
    }

    public Action[] getUrlActions() {
        return null;
    }

    public void proxyAdded(final ListenerSpec spec) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._ltm.proxyAdded(spec);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProxyPanel.this.proxyAdded(spec);
                }
            });
        }
    }

    public void proxyRemoved(final ListenerSpec spec) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._ltm.proxyRemoved(spec);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProxyPanel.this.proxyRemoved(spec);
                }
            });
        }
    }

    public void proxyStarted(ListenerSpec spec) {
    }

    public void proxyStartError(final ListenerSpec spec, final IOException ioe) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(this, new String[]{"Error starting proxy listener: ", spec.toString(), ioe.toString()}, "Error", 0);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProxyPanel.this.proxyStartError(spec, ioe);
                }
            });
        }
    }

    public void proxyStopped(ListenerSpec spec) {
    }

    public void requested(final ConversationID id, final String method, final HttpUrl url) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._mtm.addRow(id, method, url);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProxyPanel.this.requested(id, method, url);
                }
            });
        }
    }

    public void received(final ConversationID id, final String status) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._mtm.updateRow(id, status);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProxyPanel.this.received(id, status);
                }
            });
        }
    }

    public void aborted(final ConversationID id, final String reason) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._mtm.updateRow(id, reason);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProxyPanel.this.aborted(id, reason);
                }
            });
        }
    }

    public void setEnabled(final boolean enabled) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.startButton.setEnabled(enabled);
            this.stopButton.setEnabled(enabled);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProxyPanel.this.setEnabled(enabled);
                }
            });
        }
    }

    public ColumnDataModel[] getConversationColumns() {
        return null;
    }

    public ColumnDataModel[] getUrlColumns() {
        return null;
    }

    private class MessageTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 3090029861017879230L;
        private ArrayList _rows = new ArrayList();
        private Timer _timer = new Timer(true);
        private String[] _columns = new String[]{"Time", "ID", "Method", "URL", "Status"};

        private MessageTableModel() {
        }

        public String getColumnName(int columnIndex) {
            return this._columns[columnIndex];
        }

        public int getColumnCount() {
            return this._columns.length;
        }

        public int getRowCount() {
            return this._rows.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object[] row = (Object[])this._rows.get(rowIndex);
            return row[columnIndex];
        }

        public void addRow(ConversationID id, String method, HttpUrl url) {
            Object[] row = new Object[]{new Date(), id, method, url, null};
            this._rows.add(row);
            this.fireTableRowsInserted(this._rows.size() - 1, this._rows.size() - 1);
        }

        public void updateRow(final ConversationID id, String status) {
            for (int i = 0; i < this._rows.size(); ++i) {
                Object[] row = (Object[])this._rows.get(i);
                if (!row[1].equals(id)) continue;
                row[4] = status;
                this.fireTableCellUpdated(i, 4);
                this._timer.schedule(new TimerTask(){

                    public void run() {
                        MessageTableModel.this.removeRow(id);
                    }
                }, 5000L);
                return;
            }
        }

        public void removeRow(final ConversationID id) {
            if (SwingUtilities.isEventDispatchThread()) {
                for (int i = 0; i < this._rows.size(); ++i) {
                    Object[] row = (Object[])this._rows.get(i);
                    if (!row[1].equals(id)) continue;
                    this._rows.remove(i);
                    this.fireTableRowsDeleted(i, i);
                    return;
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MessageTableModel.this.removeRow(id);
                    }
                });
            }
        }
    }
}

