/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy;

import java.io.IOException;
import java.util.Date;
import org.owasp.webscarab.httpclient.HTTPClient;
import org.owasp.webscarab.model.Cookie;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.NamedValue;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.proxy.ProxyPlugin;

public class CookieTracker
extends ProxyPlugin {
    private FrameworkModel _model = null;
    private boolean _injectRequests = false;
    private boolean _readResponses = false;

    public CookieTracker(Framework framework) {
        this._model = framework.getModel();
        this.parseProperties();
    }

    public void parseProperties() {
        String prop = "CookieTracker.injectRequests";
        String value = Preferences.getPreference(prop, "false");
        this._injectRequests = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
        prop = "CookieTracker.readResponses";
        value = Preferences.getPreference(prop, "true");
        this._readResponses = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public String getPluginName() {
        return new String("Cookie Tracker");
    }

    public void setInjectRequests(boolean bool) {
        this._injectRequests = bool;
        String prop = "CookieTracker.injectRequests";
        Preferences.setPreference(prop, Boolean.toString(bool));
    }

    public boolean getInjectRequests() {
        return this._injectRequests;
    }

    public void setReadResponses(boolean bool) {
        this._readResponses = bool;
        String prop = "CookieTracker.readResponses";
        Preferences.setPreference(prop, Boolean.toString(bool));
    }

    public boolean getReadResponses() {
        return this._readResponses;
    }

    public HTTPClient getProxyPlugin(HTTPClient in) {
        return new Plugin(in);
    }

    private class Plugin
    implements HTTPClient {
        private HTTPClient _in;

        public Plugin(HTTPClient in) {
            this._in = in;
        }

        public Response fetchResponse(Request request) throws IOException {
            int i;
            Cookie[] cookies;
            if (CookieTracker.this._injectRequests && (cookies = CookieTracker.this._model.getCookiesForUrl(request.getURL())).length > 0) {
                StringBuffer buff = new StringBuffer();
                buff.append(cookies[0].getName()).append("=").append(cookies[0].getValue());
                for (i = 1; i < cookies.length; ++i) {
                    buff.append("; ").append(cookies[i].getName()).append("=").append(cookies[i].getValue());
                }
                request.setHeader("Cookie", buff.toString());
            }
            Response response = this._in.fetchResponse(request);
            if (CookieTracker.this._readResponses && response != null) {
                NamedValue[] headers = response.getHeaders();
                for (i = 0; i < headers.length; ++i) {
                    if (!headers[i].getName().equalsIgnoreCase("Set-Cookie") && !headers[i].getName().equalsIgnoreCase("Set-Cookie2")) continue;
                    Cookie cookie = new Cookie(new Date(), request.getURL(), headers[i].getValue());
                    CookieTracker.this._model.addCookie(cookie);
                }
            }
            return response;
        }
    }
}

