/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.owasp.webscarab.httpclient.HTTPClient;
import org.owasp.webscarab.httpclient.HTTPClientFactory;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.plugin.proxy.Proxy;
import org.owasp.webscarab.plugin.proxy.ProxyPlugin;
import org.owasp.webscarab.plugin.proxy.ScriptableConnection;
import org.owasp.webscarab.util.HtmlEncoder;

public class ConnectionHandler
implements Runnable {
    private static HashMap _factoryMap = new HashMap();
    private static char[] _keystorepass = "password".toCharArray();
    private static char[] _keypassword = "password".toCharArray();
    private ProxyPlugin[] _plugins = null;
    private Proxy _proxy;
    private Socket _sock = null;
    private HttpUrl _base;
    private HTTPClient _httpClient = null;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private InputStream _clientIn = null;
    private OutputStream _clientOut = null;
    private static String _certDir = "./certs/";

    public ConnectionHandler(Proxy proxy, Socket sock, HttpUrl base) {
        this._proxy = proxy;
        this._sock = sock;
        this._base = base;
        this._plugins = this._proxy.getPlugins();
        try {
            this._sock.setTcpNoDelay(true);
            this._sock.setSoTimeout(30000);
        }
        catch (SocketException se) {
            this._logger.warning("Error setting socket parameters");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ScriptableConnection connection = new ScriptableConnection(this._sock);
        this._proxy.allowClientConnection(connection);
        if (this._sock.isClosed()) {
            return;
        }
        try {
            this._clientIn = this._sock.getInputStream();
            this._clientOut = this._sock.getOutputStream();
        }
        catch (IOException ioe) {
            this._logger.severe("Error getting socket input and output streams! " + ioe);
            return;
        }
        ConversationID id = null;
        try {
            String from;
            Request request = null;
            if (this._base == null) {
                try {
                    request = new Request();
                    request.read(this._clientIn);
                }
                catch (IOException ioe) {
                    this._logger.severe("Error reading the initial request" + ioe);
                    try {
                        if (this._clientIn != null) {
                            this._clientIn.close();
                        }
                        if (this._clientOut != null) {
                            this._clientOut.close();
                        }
                        if (this._sock != null && !this._sock.isClosed()) {
                            this._sock.close();
                        }
                    }
                    catch (IOException ioe2) {
                        this._logger.warning("Error closing client socket : " + ioe2);
                    }
                    return;
                }
            }
            String proxyAuth = null;
            if (request != null) {
                String method = request.getMethod();
                if (method == null) {
                    return;
                }
                if (method.equals("CONNECT")) {
                    if (this._clientOut != null) {
                        try {
                            this._clientOut.write("HTTP/1.0 200 Ok\r\n\r\n".getBytes());
                            this._clientOut.flush();
                        }
                        catch (IOException ioe) {
                            this._logger.severe("IOException writing the CONNECT OK Response to the browser " + ioe);
                            try {
                                if (this._clientIn != null) {
                                    this._clientIn.close();
                                }
                                if (this._clientOut != null) {
                                    this._clientOut.close();
                                }
                                if (this._sock != null && !this._sock.isClosed()) {
                                    this._sock.close();
                                }
                            }
                            catch (IOException ioe3) {
                                this._logger.warning("Error closing client socket : " + ioe3);
                            }
                            return;
                        }
                    }
                    this._base = request.getURL();
                    proxyAuth = request.getHeader("Proxy-Authorization");
                    request = null;
                }
            }
            if (this._base != null && this._base.getScheme().equals("https")) {
                this._logger.fine("Intercepting SSL connection!");
                this._sock = this.negotiateSSL(this._sock, this._base.getHost());
                this._clientIn = this._sock.getInputStream();
                this._clientOut = this._sock.getOutputStream();
            }
            if (this._httpClient == null) {
                this._httpClient = HTTPClientFactory.getInstance().getHTTPClient();
            }
            HTTPClient hc = this._httpClient;
            if (this._plugins != null) {
                for (int i = this._plugins.length - 1; i >= 0; --i) {
                    hc = this._plugins[i].getProxyPlugin(hc);
                }
            }
            if ((from = this._sock.getInetAddress().getHostAddress()).equals("127.0.0.1")) {
                from = null;
            }
            String keepAlive = null;
            String version = null;
            do {
                id = null;
                if (request == null) {
                    request = new Request();
                    this._logger.fine("Reading request from the browser");
                    request.read(this._clientIn, this._base);
                    if (request.getMethod() == null || request.getURL() == null) {
                        return;
                    }
                    if (proxyAuth != null) {
                        request.addHeader("Proxy-Authorization", proxyAuth);
                    }
                }
                if (from != null) {
                    request.addHeader("X-Forwarded-For", from);
                }
                this._logger.fine("Browser requested : " + request.getMethod() + " " + request.getURL().toString());
                id = this._proxy.gotRequest(request);
                connection.setRequest(request);
                connection.setResponse(null);
                this._proxy.interceptRequest(connection);
                request = connection.getRequest();
                Response response = connection.getResponse();
                if (request == null) {
                    throw new IOException("Request was cancelled");
                }
                if (response != null) {
                    this._proxy.failedResponse(id, "Response provided by script");
                    this._proxy = null;
                } else {
                    try {
                        response = hc.fetchResponse(request);
                        if (response.getRequest() != null) {
                            request = response.getRequest();
                        }
                    }
                    catch (IOException ioe) {
                        this._logger.severe("IOException retrieving the response for " + request.getURL() + " : " + ioe);
                        ioe.printStackTrace();
                        response = this.errorResponse(request, ioe);
                        this._proxy.failedResponse(id, ioe.toString());
                        this._proxy = null;
                    }
                    if (response == null) {
                        this._logger.severe("Got a null response from the fetcher");
                        this._proxy.failedResponse(id, "Null response");
                        return;
                    }
                }
                if (this._proxy != null) {
                    connection.setResponse(response);
                    this._proxy.interceptResponse(connection);
                    response = connection.getResponse();
                }
                if (response == null) {
                    throw new IOException("Response was cancelled");
                }
                try {
                    if (this._clientOut != null) {
                        this._logger.fine("Writing the response to the browser");
                        response.write(this._clientOut);
                        this._logger.fine("Finished writing the response to the browser");
                    }
                }
                catch (IOException ioe) {
                    this._logger.severe("Error writing back to the browser : " + ioe);
                }
                finally {
                    response.flushContentStream();
                }
                if (response.getRequest() == null) {
                    this._logger.warning("Response had no associated request!");
                    response.setRequest(request);
                }
                if (this._proxy != null && !request.getMethod().equals("CONNECT")) {
                    this._proxy.gotResponse(id, response);
                }
                keepAlive = response.getHeader("Connection");
                version = response.getVersion();
                request = null;
                this._logger.fine("Version: " + version + " Connection: " + connection);
            } while (version.equals("HTTP/1.0") && "keep-alive".equalsIgnoreCase(keepAlive) || version.equals("HTTP/1.1") && !"close".equalsIgnoreCase(keepAlive));
            this._logger.fine("Finished handling connection");
        }
        catch (Exception e) {
            if (id != null) {
                this._proxy.failedResponse(id, e.getMessage());
            }
            this._logger.severe("ConnectionHandler got an error : " + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (this._clientIn != null) {
                    this._clientIn.close();
                }
                if (this._clientOut != null) {
                    this._clientOut.close();
                }
                if (this._sock != null && !this._sock.isClosed()) {
                    this._sock.close();
                }
            }
            catch (IOException ioe) {
                this._logger.warning("Error closing client socket : " + ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocketFactory getSocketFactory(String host) {
        HashMap hashMap = _factoryMap;
        synchronized (hashMap) {
            if (_factoryMap.containsKey(host)) {
                return (SSLSocketFactory)_factoryMap.get(host);
            }
            File p12 = new File(_certDir + host + ".p12");
            InputStream is = null;
            if (p12.exists() && p12.canRead()) {
                try {
                    is = new FileInputStream(p12);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                if (_factoryMap.containsKey(null)) {
                    return (SSLSocketFactory)_factoryMap.get(host);
                }
                p12 = new File(_certDir + "server.p12");
                if (p12.exists() && p12.canRead()) {
                    try {
                        is = new FileInputStream(p12);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                } else {
                    is = this.getClass().getClassLoader().getResourceAsStream("server.p12");
                }
                p12 = null;
            }
            if (is == null) {
                throw new NullPointerException("No keystore found!!");
            }
            KeyStore ks = null;
            KeyManagerFactory kmf = null;
            SSLContext sslcontext = null;
            try {
                ks = KeyStore.getInstance("PKCS12");
                ks.load(is, _keystorepass);
                kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, _keypassword);
                sslcontext = SSLContext.getInstance("SSLv3");
                sslcontext.init(kmf.getKeyManagers(), null, null);
                SSLSocketFactory factory = sslcontext.getSocketFactory();
                _factoryMap.put(host, factory);
                if (p12 == null) {
                    _factoryMap.put(null, factory);
                    this._logger.info("Loaded default SSL keystore for " + host);
                } else {
                    this._logger.info("Loaded custom SSL keystore for " + host);
                }
                return factory;
            }
            catch (Exception e) {
                this._logger.severe("Exception accessing keystore: " + e);
                e.printStackTrace();
                return null;
            }
        }
    }

    private Socket negotiateSSL(Socket sock, String host) throws Exception {
        SSLSocketFactory factory = this.getSocketFactory(host);
        if (factory == null) {
            throw new RuntimeException("SSL Intercept not available - no keystores available");
        }
        try {
            SSLSocket sslsock = (SSLSocket)factory.createSocket(sock, sock.getInetAddress().getHostName(), sock.getPort(), true);
            sslsock.setUseClientMode(false);
            this._logger.fine("Finished negotiating SSL - algorithm is " + sslsock.getSession().getCipherSuite());
            return sslsock;
        }
        catch (Exception e) {
            this._logger.severe("Error layering SSL over the socket: " + e);
            throw e;
        }
    }

    private Response errorResponse(Request request, Exception e) {
        Response response = new Response();
        response.setRequest(request);
        response.setVersion("HTTP/1.0");
        response.setStatus("500");
        response.setMessage("WebScarab error");
        response.setHeader("Content-Type", "text/html");
        response.setHeader("Connection", "Close");
        String template = "<HTML><HEAD><TITLE>WebScarab Error</TITLE></HEAD>";
        template = template + "<BODY>WebScarab encountered an error trying to retrieve <P><pre>" + HtmlEncoder.encode(request.toString()) + "</pre><P>";
        template = template + "The error was : <P><pre>" + HtmlEncoder.encode(e.getLocalizedMessage()) + "\n";
        StackTraceElement[] trace = e.getStackTrace();
        if (trace != null) {
            for (int i = 0; i < trace.length; ++i) {
                template = template + "\tat " + trace[i].getClassName() + "." + trace[i].getMethodName() + "(";
                template = trace[i].getLineNumber() == -2 ? template + "Native Method" : (trace[i].getLineNumber() == -1 ? template + "Unknown Source" : template + trace[i].getFileName() + ":" + trace[i].getLineNumber());
                template = template + ")\n";
            }
        }
        template = template + "</pre><P></HTML>";
        response.setContent(template.getBytes());
        return response;
    }
}

