/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.fuzz;

import java.net.MalformedURLException;
import java.util.ArrayList;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.plugin.fuzz.Parameter;

public class Signature {
    private String _method;
    private HttpUrl _url;
    private String _contentType;
    private Parameter[] _parameters;

    public Signature(Request request) {
        this._method = request.getMethod();
        this._url = request.getURL();
        if (this._url.getParameters() != null) {
            this._url = this._url.getParentUrl();
        }
        this._contentType = request.getHeader("Content-Type");
        this._parameters = Parameter.getParameters(request);
    }

    public Signature(String signature) throws MalformedURLException {
        String[] parts = signature.split(" ");
        this._method = parts[0];
        this._url = new HttpUrl(parts[1]);
        this._contentType = parts[2].substring(1, parts[2].length() - 1);
        if (this._contentType.equals("null")) {
            this._contentType = null;
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (int i = 3; i < parts.length; ++i) {
            int colon = parts[i].indexOf(":");
            String location = parts[i].substring(0, colon);
            int left = parts[i].indexOf(40, colon);
            String name = parts[i].substring(colon + 1, left);
            String type = parts[i].substring(left + 1, parts[i].length() - 1);
            Parameter param = new Parameter(location, name, type, "");
            parameters.add(param);
        }
        this._parameters = parameters.toArray(Parameter.NO_PARAMS);
    }

    public String getMethod() {
        return this._method;
    }

    public HttpUrl getUrl() {
        return this._url;
    }

    public String getContentType() {
        return this._contentType;
    }

    public Parameter[] getParameters() {
        return this._parameters;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this._method).append(" ").append(this._url).append(" ");
        buff.append("(").append(this._contentType).append(")");
        for (int i = 0; i < this._parameters.length; ++i) {
            buff.append(" ").append(this._parameters[i].getLocation()).append(":").append(this._parameters[i].getName());
            buff.append("(").append(this._parameters[i].getType()).append(")");
        }
        return buff.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Signature)) {
            return false;
        }
        Signature that = (Signature)obj;
        if (!this._method.equals(that._method)) {
            return false;
        }
        if (!this._url.equals(that._url)) {
            return false;
        }
        if (this._contentType == null && that._contentType != null) {
            return false;
        }
        if (this._contentType != null && that._contentType == null) {
            return false;
        }
        if (this._contentType != null && !this._contentType.equals(that._contentType)) {
            return false;
        }
        if (this._parameters.length != that._parameters.length) {
            return false;
        }
        for (int i = 0; i < this._parameters.length; ++i) {
            if (this._parameters[i].equals(that._parameters[i])) continue;
            return false;
        }
        return true;
    }
}

