/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.fuzz;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.owasp.webscarab.httpclient.ConversationHandler;
import org.owasp.webscarab.httpclient.FetcherQueue;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.NamedValue;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Plugin;
import org.owasp.webscarab.plugin.fuzz.FuzzFactory;
import org.owasp.webscarab.plugin.fuzz.FuzzerModel;
import org.owasp.webscarab.plugin.fuzz.Parameter;
import org.owasp.webscarab.plugin.fuzz.Signature;
import org.owasp.webscarab.util.Encoding;

public class Fuzzer
implements Plugin,
ConversationHandler {
    private FuzzerModel _model = null;
    private Framework _framework = null;
    private FuzzFactory _fuzzFactory = new FuzzFactory();
    private FetcherQueue _fetcherQueue = null;
    private int _threads = 4;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public Fuzzer(Framework framework) {
        this._framework = framework;
        this._model = new FuzzerModel(this._framework.getModel());
        this.loadFuzzStrings();
        this._fetcherQueue = new FetcherQueue("Fuzzer", this, this._threads, 0);
    }

    private void loadFuzzStrings() {
        String description;
        int i = 0;
        while ((description = Preferences.getPreference("Fuzz." + i + ".description")) != null) {
            String location = Preferences.getPreference("Fuzz." + i + ".location");
            if (location != null && !description.equals("")) {
                try {
                    URL url = new URL(location);
                    this._fuzzFactory.loadFuzzStrings(description, url.openStream());
                }
                catch (IOException ioe) {
                    this._logger.warning("Error loading \"" + description + "\" from " + location + " : " + ioe.getMessage());
                }
            }
            ++i;
        }
    }

    public FuzzFactory getFuzzFactory() {
        return this._fuzzFactory;
    }

    public FuzzerModel getModel() {
        return this._model;
    }

    public String getPluginName() {
        return new String("Fuzzer");
    }

    public void run() {
        this._model.setStatus("Started");
        this._model.setStopping(false);
        this._model.setRunning(true);
        while (!this._model.isStopping()) {
            boolean submittedRequest = this.queueRequests();
            if (submittedRequest) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this._fetcherQueue.clearRequestQueue();
        this._model.setRunning(false);
        this._model.setStatus("Stopped");
    }

    public void startFuzzing() {
        int count = this._model.getFuzzParameterCount();
        if (count > 0 && this._model.getFuzzUrl() != null) {
            this._model.setBusyFuzzing(true);
        } else {
            this._logger.warning("Can't fuzz if there are no parameters or URL");
        }
    }

    private Request constructCurrentFuzzRequest() throws MalformedURLException {
        Request request = new Request();
        request.setMethod(this._model.getFuzzMethod());
        request.setVersion(this._model.getFuzzVersion());
        int count = this._model.getFuzzHeaderCount();
        for (int i = 0; i < count; ++i) {
            request.addHeader(this._model.getFuzzHeader(i));
        }
        String url = this._model.getFuzzUrl().toString();
        String path = null;
        String fragment = null;
        String query = null;
        String cookie = null;
        ByteArrayOutputStream content = null;
        count = this._model.getFuzzParameterCount();
        for (int i = 0; i < count; ++i) {
            Parameter parameter = this._model.getFuzzParameter(i);
            Object value = this._model.getFuzzParameterValue(i);
            String location = parameter.getLocation();
            if (location.equals("Path")) {
                if (path == null) {
                    path = (String)value;
                    continue;
                }
                path = path + "/" + (value == null ? "" : (String)value);
                continue;
            }
            if (location.equals("Fragment")) {
                String frag = parameter.getName();
                frag = frag == null ? (String)value : (value == null ? frag + "=" + Encoding.urlEncode((String)value) : null);
                if (fragment == null) {
                    fragment = frag;
                    continue;
                }
                if (frag == null) continue;
                fragment = fragment + "&" + frag;
                continue;
            }
            if (location.equals("Query")) {
                String q = parameter.getName() + "=" + Encoding.urlEncode((String)value);
                if (query == null) {
                    query = q;
                    continue;
                }
                query = query + "&" + q;
                continue;
            }
            if (location.equals("Cookie")) {
                String c = parameter.getName() + "=" + (String)value;
                if (cookie == null) {
                    cookie = c;
                    continue;
                }
                cookie = cookie + "; " + c;
                continue;
            }
            if (location.equals("Body")) {
                String b = parameter.getName() + "=" + Encoding.urlEncode((String)value);
                if (content == null) {
                    content = new ByteArrayOutputStream();
                    try {
                        content.write(b.getBytes());
                    }
                    catch (IOException ioe) {}
                    continue;
                }
                try {
                    content.write(("&" + b).getBytes());
                }
                catch (IOException ioe) {}
                continue;
            }
            this._logger.severe("Skipping unknown parameter location " + location);
        }
        if (path != null) {
            url = url + "/" + path;
        }
        if (fragment != null) {
            url = url + ";" + fragment;
        }
        if (query != null) {
            url = url + "?" + query;
        }
        request.setURL(new HttpUrl(url));
        if (cookie != null) {
            request.addHeader("Cookie", cookie);
        }
        if (content != null) {
            request.setHeader("Content-Length", Integer.toString(content.size()));
            request.setContent(content.toByteArray());
        } else if (request.getMethod().equals("POST")) {
            request.setHeader("Content-Length", "0");
        }
        return request;
    }

    public void pauseFuzzing() {
        this._model.setBusyFuzzing(false);
    }

    public void stopFuzzing() {
        this._model.setBusyFuzzing(false);
    }

    private boolean queueRequests() {
        if (!this._model.isBusyFuzzing()) {
            return false;
        }
        if (this._fetcherQueue.getRequestsQueued() >= this._threads) {
            return false;
        }
        try {
            Request request = this.constructCurrentFuzzRequest();
            this._fetcherQueue.submit(request);
            if (!this._model.incrementFuzzer()) {
                this._model.setBusyFuzzing(false);
            }
        }
        catch (Exception e) {
            this._model.setBusyFuzzing(false);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void requestError(Request request, IOException ioe) {
        this._logger.warning("Caught exception : " + ioe.getMessage());
        this._model.setBusyFuzzing(false);
    }

    public void responseReceived(Response response) {
        if (response.getStatus().equals("400")) {
            this._logger.warning("Bad request");
            this._model.setBusyFuzzing(false);
            return;
        }
        Request request = response.getRequest();
        if (request == null) {
            this._logger.warning("Got a null request from the response!");
            return;
        }
        ConversationID id = this._framework.addConversation(request, response, "Fuzzer");
        this._model.addConversation(id);
    }

    public boolean stop() {
        this._model.setStatus("Stopped");
        this._model.setRunning(false);
        return !this._model.isRunning();
    }

    public void setSession(String type, Object store, String session) throws StoreException {
    }

    public void flush() throws StoreException {
    }

    public boolean isBusy() {
        return this._model.isBusy();
    }

    public boolean isRunning() {
        return this._model.isRunning();
    }

    public String getStatus() {
        return this._model.getStatus();
    }

    public boolean isModified() {
        return this._model.isModified();
    }

    public void analyse(ConversationID id, Request request, Response response, String origin) {
        Signature signature = new Signature(request);
        this._model.addSignature(signature);
        if (!response.getStatus().equals("304")) {
            byte[] content = response.getContent();
            if (content == null) {
                content = new byte[]{};
            }
            String checksum = Encoding.hashMD5(content);
            this._model.addChecksum(signature.getUrl(), checksum);
        }
    }

    public void loadTemplateFromConversation(ConversationID id) {
        Request request;
        HttpUrl url;
        if (this._model.isBusyFuzzing()) {
            this.stopFuzzing();
        }
        if ((url = (request = this._framework.getModel().getRequest(id)).getURL()).getParameters() != null) {
            url = url.getParentUrl();
        }
        this._model.setFuzzMethod(request.getMethod());
        this._model.setFuzzUrl(url.toString());
        this._model.setFuzzVersion(request.getVersion());
        while (this._model.getFuzzHeaderCount() > 0) {
            this._model.removeFuzzHeader(0);
        }
        while (this._model.getFuzzParameterCount() > 0) {
            this._model.removeFuzzParameter(0);
        }
        NamedValue[] headers = request.getHeaders();
        if (headers != null) {
            for (int i = 0; i < headers.length; ++i) {
                if (headers[i].getName().equals("Cookie")) continue;
                this._model.addFuzzHeader(this._model.getFuzzHeaderCount(), headers[i]);
            }
        }
        Parameter[] params = Parameter.getParameters(request);
        for (int i = 0; i < params.length; ++i) {
            this._model.addFuzzParameter(i, params[i], null, 0);
        }
    }

    public Object getScriptableObject() {
        return null;
    }

    public Hook[] getScriptingHooks() {
        return new Hook[0];
    }
}

