/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.extensions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.owasp.webscarab.httpclient.ConversationHandler;
import org.owasp.webscarab.httpclient.FetcherQueue;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.model.UrlModel;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Plugin;
import org.owasp.webscarab.plugin.extensions.ExtensionsModel;

public class Extensions
implements Plugin,
ConversationHandler {
    public static final int MAXLINKS = 100;
    private Framework _framework;
    private ExtensionsModel _model;
    private FetcherQueue _fetcherQueue = null;
    private int _threads = 4;
    private int _delay = 100;

    public Extensions(Framework framework) {
        this._framework = framework;
        this._model = new ExtensionsModel(framework.getModel());
        try {
            String property = "WebScarab.extensions.threads";
            String threads = Preferences.getPreference(property, "4");
            this._threads = Integer.parseInt(threads);
            property = "WebScarab.extensions.delay";
            String delay = Preferences.getPreference(property, "100");
            this._delay = Integer.parseInt(delay);
        }
        catch (NumberFormatException nfe) {
            this._threads = 4;
            this._delay = 100;
        }
    }

    public void analyse(ConversationID id, Request request, Response response, String origin) {
    }

    public void flush() throws StoreException {
    }

    public String getPluginName() {
        return "Extensions";
    }

    public Object getScriptableObject() {
        return null;
    }

    public Hook[] getScriptingHooks() {
        return new Hook[0];
    }

    public String getStatus() {
        return this._model.getStatus();
    }

    public boolean isBusy() {
        return this._model.isBusy();
    }

    public boolean isModified() {
        return this._model.isModified();
    }

    public boolean isRunning() {
        return this._model.isRunning();
    }

    public void run() {
        this._model.setRunning(true);
        this._model.setStatus("Started");
        this._model.setStopping(false);
        this._fetcherQueue = new FetcherQueue(this.getPluginName(), this, this._threads, this._delay);
        this._model.setRunning(true);
        while (!this._model.isStopping()) {
            String[] exts;
            HttpUrl origUrl = this._model.dequeueURL();
            if (origUrl == null) continue;
            if (origUrl.getPath().endsWith("/")) {
                exts = this._model.getDirectoryExtensions();
                if (origUrl.getPath().length() < 2) {
                    continue;
                }
            } else {
                exts = this._model.getFileExtensions();
            }
            for (int ix = 0; ix < exts.length; ++ix) {
                this._model.incrementExtensionsTested(origUrl);
                Request newReq = this.newRequest(origUrl, exts[ix]);
                this._fetcherQueue.submit(newReq);
            }
        }
        this._fetcherQueue.clearRequestQueue();
        this._fetcherQueue.stop();
        this._model.setRunning(false);
        this._model.setStatus("Stopped");
    }

    public void responseReceived(Response response) {
        if (response.getStatus().equalsIgnoreCase("200")) {
            this._framework.addConversation(response.getRequest(), response, this.getPluginName());
        }
    }

    public void requestError(Request request, IOException ioe) {
    }

    public void setSession(String type, Object store, String session) throws StoreException {
    }

    public boolean stop() {
        this._model.setRunning(false);
        return this._model.isRunning();
    }

    public synchronized String[] loadStrings(File file) throws IOException {
        String line;
        ArrayList<String> strings = new ArrayList<String>();
        BufferedReader input = new BufferedReader(new FileReader(file));
        while ((line = input.readLine()) != null) {
            strings.add(line);
        }
        return strings.toArray(new String[0]);
    }

    public ExtensionsModel getModel() {
        return this._model;
    }

    public void checkExtensionsUnder(HttpUrl url) {
        LinkedList links = new LinkedList();
        this.queueLinksUnder(url, links, 100);
        while (links.size() > 0) {
            this._model.enqueueURL((HttpUrl)links.remove(0));
        }
    }

    private void queueLinksUnder(HttpUrl url, List links, int max) {
        if (!this._model.isTested(url)) {
            links.add(url);
        }
        if (links.size() == max) {
            return;
        }
        UrlModel urlModel = this._model.getUrlModel();
        int count = urlModel.getChildCount(url);
        for (int i = 0; i < count; ++i) {
            HttpUrl child = urlModel.getChildAt(url, i);
            this.queueLinksUnder(child, links, max);
            if (links.size() != max) continue;
            return;
        }
    }

    public void checkExtensionsFor(HttpUrl[] urls) {
        for (int ix = 0; ix < urls.length; ++ix) {
            this._model.enqueueURL(urls[ix]);
        }
    }

    public void stopChecks() {
        System.out.println("stopChecks()");
    }

    public Request newRequest(HttpUrl url, String ext) {
        Request req = new Request();
        String path = url.getPath();
        try {
            req.setMethod("GET");
            req.setVersion("HTTP/1.0");
            if (url.getPath().endsWith("/")) {
                path = url.getPath();
                path = path.substring(0, path.length() - 1);
            }
            req.setURL(new HttpUrl(url.getScheme() + "://" + url.getHost() + ":" + url.getPort() + path + ext));
            req.setHeader("Host", url.getHost() + ":" + url.getPort());
            req.setHeader("Connection", "Close");
        }
        catch (MalformedURLException e) {
            return null;
        }
        return req;
    }
}

