/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.List;
import org.jfree.data.AbstractDataset;
import org.jfree.data.KeyedObjects2D;
import org.jfree.data.MeanAndStandardDeviation;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.StatisticalCategoryDataset;

public class DefaultStatisticalCategoryDataset
extends AbstractDataset
implements StatisticalCategoryDataset,
RangeInfo {
    private KeyedObjects2D data = new KeyedObjects2D();
    private Number minimumRangeValue = new Double(0.0);
    private Number maximumRangeValue = new Double(0.0);
    private Range valueRange = new Range(0.0, 0.0);

    public Number getMeanValue(int n, int n2) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(n, n2);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getMean();
        }
        return number;
    }

    public Number getValue(int n, int n2) {
        return this.getMeanValue(n, n2);
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        return this.getMeanValue(comparable, comparable2);
    }

    public Number getMeanValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(comparable, comparable2);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getMean();
        }
        return number;
    }

    public Number getStdDevValue(int n, int n2) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(n, n2);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getStandardDeviation();
        }
        return number;
    }

    public Number getStdDevValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(comparable, comparable2);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getStandardDeviation();
        }
        return number;
    }

    public int getColumnIndex(Comparable comparable) {
        return this.data.getColumnIndex(comparable);
    }

    public Comparable getColumnKey(int n) {
        return this.data.getColumnKey(n);
    }

    public List getColumnKeys() {
        return this.data.getColumnKeys();
    }

    public int getRowIndex(Comparable comparable) {
        return this.data.getRowIndex(comparable);
    }

    public Comparable getRowKey(int n) {
        return this.data.getRowKey(n);
    }

    public List getRowKeys() {
        return this.data.getRowKeys();
    }

    public int getRowCount() {
        return this.data.getRowCount();
    }

    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    public void add(double d, double d2, Comparable comparable, Comparable comparable2) {
        MeanAndStandardDeviation meanAndStandardDeviation = new MeanAndStandardDeviation(new Double(d), new Double(d2));
        this.data.addObject(meanAndStandardDeviation, comparable, comparable2);
        if (d + d2 > this.maximumRangeValue.doubleValue()) {
            this.maximumRangeValue = new Double(d + d2);
            this.valueRange = new Range(this.minimumRangeValue.doubleValue(), this.maximumRangeValue.doubleValue());
        }
        if (d - d2 < this.minimumRangeValue.doubleValue()) {
            this.minimumRangeValue = new Double(d - d2);
            this.valueRange = new Range(this.minimumRangeValue.doubleValue(), this.maximumRangeValue.doubleValue());
        }
        this.fireDatasetChanged();
    }

    public Number getMinimumRangeValue() {
        return this.minimumRangeValue;
    }

    public Number getMaximumRangeValue() {
        return this.maximumRangeValue;
    }

    public Range getValueRange() {
        return this.valueRange;
    }
}

