/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import org.jfree.xml.writer.SafeTagList;

public class XMLWriterSupport {
    protected static final int OPEN_TAG_INCREASE = 1;
    protected static final int CLOSE_TAG_DECREASE = 2;
    protected static final int INDENT_ONLY = 3;
    public static final boolean CLOSE = true;
    public static final boolean OPEN = false;
    private static String lineSeparator;
    private SafeTagList safeTags;
    private int indentLevel;
    private String indentString;

    public XMLWriterSupport(SafeTagList safeTagList, int n) {
        this(safeTagList, n, "    ");
    }

    public XMLWriterSupport(SafeTagList safeTagList, int n, String string) {
        if (string == null) {
            throw new NullPointerException("IndentString must not be null");
        }
        this.safeTags = safeTagList;
        this.indentLevel = n;
        this.indentString = string;
    }

    public static String getLineSeparator() {
        block2: {
            if (lineSeparator != null) break block2;
            try {
                lineSeparator = System.getProperty("line.separator", "\n");
            }
            catch (SecurityException securityException) {
                lineSeparator = "\n";
            }
        }
        return lineSeparator;
    }

    public void writeTag(Writer writer, String string) throws IOException {
        this.indent(writer, 1);
        writer.write("<");
        writer.write(string);
        writer.write(">");
        if (this.getSafeTags().isSafeForOpen(string)) {
            writer.write(XMLWriterSupport.getLineSeparator());
        }
    }

    public void writeCloseTag(Writer writer, String string) throws IOException {
        if (this.getSafeTags().isSafeForOpen(string)) {
            this.indent(writer, 2);
        } else {
            this.decreaseIndent();
        }
        writer.write("</");
        writer.write(string);
        writer.write(">");
        if (this.getSafeTags().isSafeForClose(string)) {
            writer.write(XMLWriterSupport.getLineSeparator());
        }
    }

    public void writeTag(Writer writer, String string, String string2, String string3, boolean bl) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(string2, string3);
        this.writeTag(writer, string, properties, bl);
    }

    public void writeTag(Writer writer, String string, Properties properties, boolean bl) throws IOException {
        this.indent(writer, 1);
        writer.write("<");
        writer.write(string);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            writer.write(" ");
            writer.write(string2);
            writer.write("=\"");
            writer.write(XMLWriterSupport.normalize(string3));
            writer.write("\"");
        }
        if (bl) {
            writer.write("/>");
            if (this.getSafeTags().isSafeForClose(string)) {
                writer.write(XMLWriterSupport.getLineSeparator());
            }
            this.decreaseIndent();
        } else {
            writer.write(">");
            if (this.getSafeTags().isSafeForOpen(string)) {
                writer.write(XMLWriterSupport.getLineSeparator());
            }
        }
    }

    public static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': {
                    if (n2 > 0) {
                        char c2 = stringBuffer.charAt(stringBuffer.length() - 1);
                        if (c2 != '\r') {
                            stringBuffer.append(XMLWriterSupport.getLineSeparator());
                            break;
                        }
                        stringBuffer.append('\n');
                        break;
                    }
                    stringBuffer.append(XMLWriterSupport.getLineSeparator());
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void indent(Writer writer, int n) throws IOException {
        if (n == 2) {
            this.decreaseIndent();
        }
        int n2 = 0;
        while (n2 < this.indentLevel) {
            writer.write(this.indentString);
            ++n2;
        }
        if (n == 1) {
            this.increaseIndent();
        }
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    protected void increaseIndent() {
        ++this.indentLevel;
    }

    protected void decreaseIndent() {
        --this.indentLevel;
    }

    public SafeTagList getSafeTags() {
        return this.safeTags;
    }
}

