/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api.project;

import java.io.IOException;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.modules.profiler.api.GlobalStorage;
import org.netbeans.modules.profiler.spi.project.ProjectStorageProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class ProjectStorage {
    public static AttachSettings loadAttachSettings(Lookup.Provider project) throws IOException {
        ProjectStorageProvider p = ProjectStorage.provider();
        if (p != null) {
            return p.loadAttachSettings(project);
        }
        return null;
    }

    public static void saveAttachSettings(Lookup.Provider project, AttachSettings settings) {
        ProjectStorageProvider p = ProjectStorage.provider();
        if (p != null) {
            p.saveAttachSettings(project, settings);
        }
    }

    public static FileObject getSettingsFolder(Lookup.Provider project, boolean create) throws IOException {
        if (project == null) {
            return GlobalStorage.getSettingsFolder(create);
        }
        ProjectStorageProvider p = ProjectStorage.provider();
        if (p != null) {
            return p.getSettingsFolder(project, create);
        }
        return null;
    }

    public static Lookup.Provider getProjectFromSettingsFolder(FileObject settingsFolder) {
        ProjectStorageProvider p = ProjectStorage.provider();
        if (p != null) {
            return p.getProjectFromSettingsFolder(settingsFolder);
        }
        return null;
    }

    private static ProjectStorageProvider provider() {
        return (ProjectStorageProvider)Lookup.getDefault().lookup(ProjectStorageProvider.class);
    }
}

