/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.ui.Bundle;
import org.netbeans.modules.profiler.oql.engine.api.OQLEngine;

public class HeapFragmentWalkerUI
extends JPanel {
    private static Icon ICON_BACK = Icons.getIcon((String)"GeneralIcons.Back");
    private static Icon ICON_FORWARD = Icons.getIcon((String)"GeneralIcons.Forward");
    private AbstractAction backAction;
    private AbstractAction forwardAction;
    private AbstractButton oqlControllerPresenter;
    private AbstractButton analysisControllerPresenter;
    private AbstractButton classesControllerPresenter;
    private AbstractButton instancesControllerPresenter;
    private AbstractButton summaryControllerPresenter;
    private CardLayout controllerUIsLayout;
    private HeapFragmentWalker heapFragmentWalker;
    private JPanel oqlControllerPanel;
    private JPanel analysisControllerPanel;
    private JPanel classesControllerPanel;
    private JPanel controllerUIsPanel;
    private JPanel instancesControllerPanel;
    private JPanel summaryControllerPanel;
    private ProfilerToolbar toolBar;
    private boolean analysisEnabled;
    private boolean oqlEnabled;
    private int subControllersIndex;

    public HeapFragmentWalkerUI(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
        ProfilerIDESettings pis = ProfilerIDESettings.getInstance();
        this.analysisEnabled = pis.getHeapWalkerAnalysisEnabled();
        this.oqlEnabled = OQLEngine.isOQLSupported();
        this.initComponents();
        this.updateNavigationActions();
    }

    public boolean isOQLViewActive() {
        if (this.oqlControllerPanel == null) {
            return false;
        }
        return this.oqlControllerPanel.isShowing();
    }

    public boolean isAnalysisViewActive() {
        if (this.analysisControllerPanel == null) {
            return false;
        }
        return this.analysisControllerPanel.isShowing();
    }

    public boolean isClassesViewActive() {
        return this.classesControllerPanel.isShowing();
    }

    public boolean isInstancesViewActive() {
        return this.instancesControllerPanel.isShowing();
    }

    public boolean isSummaryViewActive() {
        return this.summaryControllerPanel.isShowing();
    }

    public void showOQLView() {
        this.showOQLView(true);
    }

    public void showAnalysisView() {
        this.showAnalysisView(true);
    }

    public void showClassesView() {
        this.showClassesView(true);
    }

    public void showHistoryOQLView() {
        this.showOQLView(false);
    }

    public void showHistoryAnalysisView() {
        this.showAnalysisView(false);
    }

    public void showHistoryClassesView() {
        this.showClassesView(false);
    }

    public void showHistoryInstancesView() {
        this.showInstancesView(false);
    }

    public void showHistorySummaryView() {
        this.showSummaryView(false);
    }

    public void showInstancesView() {
        this.showInstancesView(true);
    }

    public void showSummaryView() {
        this.showSummaryView(true);
    }

    public void updateNavigationActions() {
        this.backAction.setEnabled(this.heapFragmentWalker.isNavigationBackAvailable());
        this.forwardAction.setEnabled(this.heapFragmentWalker.isNavigationForwardAvailable());
    }

    private void initComponents() {
        this.summaryControllerPanel = this.heapFragmentWalker.getSummaryController().getPanel();
        this.classesControllerPanel = this.heapFragmentWalker.getClassesController().getPanel();
        this.instancesControllerPanel = this.heapFragmentWalker.getInstancesController().getPanel();
        if (this.oqlEnabled) {
            this.oqlControllerPanel = this.heapFragmentWalker.getOQLController().getPanel();
        }
        if (this.analysisEnabled) {
            this.analysisControllerPanel = this.heapFragmentWalker.getAnalysisController().getPanel();
        }
        this.summaryControllerPresenter = this.heapFragmentWalker.getSummaryController().getPresenter();
        this.classesControllerPresenter = this.heapFragmentWalker.getClassesController().getPresenter();
        this.instancesControllerPresenter = this.heapFragmentWalker.getInstancesController().getPresenter();
        if (this.oqlEnabled) {
            this.oqlControllerPresenter = this.heapFragmentWalker.getOQLController().getPresenter();
        }
        if (this.analysisEnabled) {
            this.analysisControllerPresenter = this.heapFragmentWalker.getAnalysisController().getPresenter();
        }
        this.backAction = new AbstractAction(Bundle.HeapFragmentWalkerUI_NavigateBackName(), ICON_BACK){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapFragmentWalkerUI.this.heapFragmentWalker.navigateBack();
            }
        };
        this.backAction.putValue("ShortDescription", Bundle.HeapFragmentWalkerUI_NavigateBackDescr());
        this.forwardAction = new AbstractAction(Bundle.HeapFragmentWalkerUI_NavigateForwardName(), ICON_FORWARD){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapFragmentWalkerUI.this.heapFragmentWalker.navigateForward();
            }
        };
        this.forwardAction.putValue("ShortDescription", Bundle.HeapFragmentWalkerUI_NavigateForwardDescr());
        this.setLayout(new BorderLayout());
        this.toolBar = ProfilerToolbar.create((boolean)false);
        this.toolBar.add((Action)this.backAction);
        this.toolBar.add((Action)this.forwardAction);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.summaryControllerPresenter);
        this.toolBar.add((Component)this.classesControllerPresenter);
        this.toolBar.add((Component)this.instancesControllerPresenter);
        if (this.analysisEnabled) {
            this.toolBar.add((Component)this.analysisControllerPresenter);
        }
        if (this.oqlEnabled) {
            this.toolBar.add((Component)this.oqlControllerPresenter);
        }
        this.toolBar.addFiller();
        this.subControllersIndex = this.toolBar.getComponentCount();
        this.controllerUIsLayout = new CardLayout();
        this.controllerUIsPanel = new JPanel(this.controllerUIsLayout);
        this.controllerUIsPanel.add((Component)this.summaryControllerPanel, this.summaryControllerPresenter.getText());
        this.controllerUIsPanel.add((Component)this.classesControllerPanel, this.classesControllerPresenter.getText());
        this.controllerUIsPanel.add((Component)this.instancesControllerPanel, this.instancesControllerPresenter.getText());
        if (this.analysisEnabled) {
            this.controllerUIsPanel.add((Component)this.analysisControllerPanel, this.analysisControllerPresenter.getText());
        }
        if (this.oqlEnabled) {
            this.controllerUIsPanel.add((Component)this.oqlControllerPanel, this.oqlControllerPresenter.getText());
        }
        this.add((Component)this.toolBar.getComponent(), "North");
        this.add((Component)this.controllerUIsPanel, "Center");
        this.summaryControllerPresenter.setSelected(true);
        this.classesControllerPresenter.setSelected(false);
        this.instancesControllerPresenter.setSelected(false);
        if (this.analysisEnabled) {
            this.analysisControllerPresenter.setSelected(false);
        }
        if (this.oqlEnabled) {
            this.oqlControllerPresenter.setSelected(false);
        }
        this.summaryControllerPresenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapFragmentWalkerUI.this.showSummaryView();
            }
        });
        this.classesControllerPresenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapFragmentWalkerUI.this.showClassesView();
            }
        });
        this.instancesControllerPresenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapFragmentWalkerUI.this.showInstancesView();
            }
        });
        if (this.analysisEnabled) {
            this.analysisControllerPresenter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeapFragmentWalkerUI.this.showAnalysisView();
                }
            });
        }
        if (this.oqlEnabled) {
            this.oqlControllerPresenter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeapFragmentWalkerUI.this.showOQLView();
                }
            });
        }
        this.updateClientPresenters(this.heapFragmentWalker.getSummaryController().getClientPresenters());
        this.summaryControllerPresenter.setSelected(true);
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapFragmentWalkerUI.this.moveToPreviousView();
                HeapFragmentWalkerUI.this.updatePresentersFocus();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapFragmentWalkerUI.this.moveToNextView();
                HeapFragmentWalkerUI.this.updatePresentersFocus();
            }
        });
    }

    private void moveToNextView() {
        if (this.isSummaryViewActive()) {
            this.showClassesView();
        } else if (this.isClassesViewActive()) {
            this.showInstancesView();
        } else if (this.isInstancesViewActive()) {
            if (this.analysisEnabled) {
                this.showAnalysisView();
            } else if (this.oqlEnabled) {
                this.showOQLView();
            } else {
                this.showSummaryView();
            }
        } else if (this.isAnalysisViewActive()) {
            if (this.oqlEnabled) {
                this.showOQLView();
            } else {
                this.showSummaryView();
            }
        } else if (this.isOQLViewActive()) {
            this.showSummaryView();
        }
    }

    private void moveToPreviousView() {
        if (this.isSummaryViewActive()) {
            if (this.oqlEnabled) {
                this.showOQLView();
            } else if (this.analysisEnabled) {
                this.showAnalysisView();
            } else {
                this.showInstancesView();
            }
        } else if (this.isOQLViewActive()) {
            if (this.analysisEnabled) {
                this.showAnalysisView();
            } else {
                this.showInstancesView();
            }
        } else if (this.isClassesViewActive()) {
            this.showSummaryView();
        } else if (this.isInstancesViewActive()) {
            this.showClassesView();
        } else if (this.isAnalysisViewActive()) {
            this.showInstancesView();
        }
    }

    private void showOQLView(boolean addToHistory) {
        if (!this.isOQLViewActive()) {
            if (addToHistory) {
                this.heapFragmentWalker.createNavigationHistoryPoint();
            }
            this.controllerUIsLayout.show(this.controllerUIsPanel, this.oqlControllerPresenter.getText());
            this.updateClientPresenters(this.heapFragmentWalker.getOQLController().getClientPresenters());
        }
        this.updatePresenters();
    }

    private void showAnalysisView(boolean addToHistory) {
        if (!this.isAnalysisViewActive()) {
            if (addToHistory) {
                this.heapFragmentWalker.createNavigationHistoryPoint();
            }
            this.controllerUIsLayout.show(this.controllerUIsPanel, this.analysisControllerPresenter.getText());
            this.updateClientPresenters(this.heapFragmentWalker.getAnalysisController().getClientPresenters());
        }
        this.updatePresenters();
    }

    private void showClassesView(boolean addToHistory) {
        if (!this.isClassesViewActive()) {
            if (addToHistory) {
                this.heapFragmentWalker.createNavigationHistoryPoint();
            }
            this.controllerUIsLayout.show(this.controllerUIsPanel, this.classesControllerPresenter.getText());
            this.updateClientPresenters(this.heapFragmentWalker.getClassesController().getClientPresenters());
        }
        this.updatePresenters();
    }

    private void showInstancesView(boolean addToHistory) {
        if (!this.isInstancesViewActive()) {
            if (addToHistory) {
                this.heapFragmentWalker.createNavigationHistoryPoint();
            }
            this.controllerUIsLayout.show(this.controllerUIsPanel, this.instancesControllerPresenter.getText());
            this.updateClientPresenters(this.heapFragmentWalker.getInstancesController().getClientPresenters());
        }
        this.updatePresenters();
    }

    private void showSummaryView(boolean addToHistory) {
        if (!this.isSummaryViewActive()) {
            if (addToHistory) {
                this.heapFragmentWalker.createNavigationHistoryPoint();
            }
            this.controllerUIsLayout.show(this.controllerUIsPanel, this.summaryControllerPresenter.getText());
            this.updateClientPresenters(this.heapFragmentWalker.getSummaryController().getClientPresenters());
        }
        this.updatePresenters();
    }

    private void unifyComponentsSize(Component c1, Component c2) {
        Dimension preferredSize = new Dimension(Math.max(c1.getPreferredSize().width, c2.getPreferredSize().width), Math.max(c1.getPreferredSize().height, c2.getPreferredSize().height));
        c1.setPreferredSize(preferredSize);
        c2.setPreferredSize(preferredSize);
    }

    private void updateClientPresenters(AbstractButton[] clientPresenters) {
        while (this.toolBar.getComponentCount() > this.subControllersIndex) {
            this.toolBar.remove(this.subControllersIndex);
        }
        for (int i = 0; i < clientPresenters.length; ++i) {
            this.toolBar.add((Component)clientPresenters[i]);
        }
    }

    private void updatePresenters() {
        this.summaryControllerPresenter.setSelected(this.summaryControllerPanel.isShowing());
        this.classesControllerPresenter.setSelected(this.classesControllerPanel.isShowing());
        this.instancesControllerPresenter.setSelected(this.instancesControllerPanel.isShowing());
        if (this.analysisEnabled) {
            this.analysisControllerPresenter.setSelected(this.analysisControllerPanel.isShowing());
        }
        if (this.oqlEnabled) {
            this.oqlControllerPresenter.setSelected(this.oqlControllerPanel.isShowing());
        }
    }

    private void updatePresentersFocus() {
        if (this.summaryControllerPresenter.isSelected()) {
            this.summaryControllerPresenter.requestFocus();
        } else if (this.classesControllerPresenter.isSelected()) {
            this.classesControllerPresenter.requestFocus();
        } else if (this.instancesControllerPresenter.isSelected()) {
            this.instancesControllerPresenter.requestFocus();
        } else if (this.analysisEnabled && this.analysisControllerPresenter.isSelected()) {
            this.analysisControllerPresenter.requestFocus();
        } else if (this.oqlEnabled && this.oqlControllerPresenter.isSelected()) {
            this.oqlControllerPresenter.requestFocus();
        }
    }
}

