/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common.filters;

import java.util.ArrayList;
import java.util.Map;

public final class GlobalFilters {
    private String[] filterNames;
    private String[] filterValues;

    public GlobalFilters() {
        this.clear();
    }

    public int getFilterIndex(String filterName) {
        for (int i = 0; i < this.filterNames.length; ++i) {
            if (!this.filterNames[i].equals(filterName)) continue;
            return i;
        }
        return -1;
    }

    public void setFilterNames(String[] names) {
        if (names == null) {
            return;
        }
        this.filterNames = names;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterValue(String filterName) {
        int filterIndex = this.getFilterIndex(filterName);
        if (filterIndex == -1) {
            return null;
        }
        return this.filterValues[filterIndex];
    }

    public void setFilterValues(String[] values) {
        if (values == null) {
            return;
        }
        this.filterValues = values;
    }

    public String[] getFilterValues() {
        return this.filterValues;
    }

    public void clear() {
        this.initBuffers(0);
    }

    public void load(Map props) {
        String filterName;
        ArrayList<String> filterNamesVect = new ArrayList<String>();
        ArrayList<String> filterValuesVect = new ArrayList<String>();
        while ((filterName = (String)props.get("Filter-" + filterNamesVect.size() + "-name")) != null) {
            filterNamesVect.add(filterName);
            filterValuesVect.add(GlobalFilters.getProperty(props, "Filter-" + filterValuesVect.size() + "-value", ""));
        }
        this.filterNames = new String[filterNamesVect.size()];
        this.filterValues = new String[filterValuesVect.size()];
        for (int i = 0; i < filterNamesVect.size(); ++i) {
            this.filterNames[i] = (String)filterNamesVect.get(i);
            this.filterValues[i] = (String)filterValuesVect.get(i);
        }
    }

    public void store(Map props) {
        for (int i = 0; i < this.filterNames.length; ++i) {
            String itemPrefix = "Filter-" + i + "-";
            props.put(itemPrefix + "name", this.filterNames[i]);
            props.put(itemPrefix + "value", this.filterValues[i]);
        }
    }

    private static String getProperty(Map props, Object key, String defaultValue) {
        Object ret = props.get(key);
        return ret != null ? (String)ret : defaultValue;
    }

    private void initBuffers(int capacity) {
        this.filterNames = new String[capacity];
        this.filterValues = new String[capacity];
    }
}

