/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.openide.awt.Notification;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;

public abstract class NotificationDisplayer {
    public static NotificationDisplayer getDefault() {
        NotificationDisplayer res = (NotificationDisplayer)Lookup.getDefault().lookup(NotificationDisplayer.class);
        if (null == res) {
            Logger.getLogger(NotificationDisplayer.class.getName()).log(Level.INFO, "No NotificationDisplayer implementation available.");
            res = new SimpleNotificationDisplayer();
        }
        return res;
    }

    public Notification notify(String title, Icon icon, String detailsText, ActionListener detailsAction) {
        return this.notify(title, icon, detailsText, detailsAction, Priority.NORMAL);
    }

    public abstract Notification notify(String var1, Icon var2, String var3, ActionListener var4, Priority var5);

    public abstract Notification notify(String var1, Icon var2, JComponent var3, JComponent var4, Priority var5);

    private static class NotificationImpl
    extends Notification {
        private final StatusDisplayer.Message msg;

        public NotificationImpl(StatusDisplayer.Message msg) {
            this.msg = msg;
        }

        @Override
        public void clear() {
            this.msg.clear(0);
        }
    }

    private static class SimpleNotificationDisplayer
    extends NotificationDisplayer {
        private SimpleNotificationDisplayer() {
        }

        @Override
        public Notification notify(String title, Icon icon, String detailsText, ActionListener detailsAction, Priority priority) {
            return this.notify(title + " - " + detailsText, priority);
        }

        @Override
        public Notification notify(String title, Icon icon, JComponent balloonDetails, JComponent popupDetails, Priority priority) {
            return this.notify(title, priority);
        }

        private Notification notify(String text, Priority priority) {
            int importance = 1;
            switch (priority) {
                case HIGH: {
                    importance = 100;
                    break;
                }
                case NORMAL: {
                    importance = 50;
                    break;
                }
                case LOW: 
                case SILENT: {
                    importance = 1;
                }
            }
            StatusDisplayer.Message msg = StatusDisplayer.getDefault().setStatusText(text, importance);
            return new NotificationImpl(msg);
        }
    }

    public static enum Priority {
        HIGH,
        NORMAL,
        LOW,
        SILENT;

    }
}

