/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.core.multiview.MultiViewModel;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

class TabsComponent
extends JPanel {
    private JComponent EMPTY;
    private static final String TOOLBAR_MARKER = "MultiViewPanel";
    MultiViewModel model;
    private MouseListener buttonMouseListener = null;
    private JComponent toolbarPanel;
    JPanel componentPanel;
    private CardLayout cardLayout;
    private Set<MultiViewElement> alreadyAddedElements;
    private JToolBar bar = new JToolBar();
    private static final boolean AQUA = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private boolean toolbarVisible = true;
    private Border buttonBorder = null;

    public TabsComponent(boolean toolVis) {
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container aContainer) {
                MultiViewElement elem = TabsComponent.this.model.getActiveElement();
                JComponent vr = elem.getVisualRepresentation();
                if (vr instanceof CloneableEditorSupport.Pane) {
                    CloneableEditorSupport.Pane pane = (CloneableEditorSupport.Pane)vr;
                    JEditorPane editorPane = pane.getEditorPane();
                    if (null != editorPane && editorPane.isShowing()) {
                        return editorPane;
                    }
                    if (null == editorPane) {
                        Logger.getLogger(TabsComponent.class.getName()).log(Level.INFO, "No editor pane in " + TabsComponent.this.model.getActiveElement().getVisualRepresentation());
                    }
                }
                return super.getDefaultComponent(aContainer);
            }
        });
        Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        this.bar.setBorder(b);
        this.bar.setFloatable(false);
        this.bar.setFocusable(true);
        if ("Windows".equals(UIManager.getLookAndFeel().getID()) && !TabsComponent.isXPTheme()) {
            this.bar.setRollover(true);
        } else if (AQUA) {
            this.bar.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        this.startToggling();
        this.setToolbarBarVisible(toolVis);
    }

    public void setModel(MultiViewModel model) {
        if (this.model != null) {
            this.bar.removeAll();
        }
        this.model = model;
        this.componentPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.componentPanel.setLayout(this.cardLayout);
        this.add((Component)this.componentPanel, "Center");
        this.alreadyAddedElements = new HashSet<MultiViewElement>();
        MultiViewDescription[] descs = model.getDescriptions();
        MultiViewDescription def = model.getActiveDescription();
        GridBagLayout grid = new GridBagLayout();
        this.bar.setLayout(grid);
        AbstractButton active = null;
        int prefHeight = -1;
        int prefWidth = -1;
        for (int i = 0; i < descs.length; ++i) {
            JToggleButton button = this.createButton(descs[i]);
            model.getButtonGroup().add(button);
            GridBagConstraints cons = new GridBagConstraints();
            cons.anchor = 17;
            prefHeight = Math.max(button.getPreferredSize().height, prefHeight);
            this.bar.add((Component)button, cons);
            prefWidth = Math.max(button.getPreferredSize().width, prefWidth);
            if (descs[i] != model.getActiveDescription()) continue;
            active = button;
        }
        Enumeration<AbstractButton> en = model.getButtonGroup().getElements();
        while (en.hasMoreElements()) {
            JToggleButton but = (JToggleButton)en.nextElement();
            Insets ins = but.getBorder().getBorderInsets(but);
            but.setPreferredSize(new Dimension(prefWidth + 10, prefHeight));
            but.setMinimumSize(new Dimension(prefWidth + 10, prefHeight));
        }
        if (active != null) {
            active.setSelected(true);
        }
        this.toolbarPanel = this.getEmptyInnerToolBar();
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 13;
        cons.fill = 1;
        cons.gridwidth = 0;
        cons.weightx = 1.0;
        this.bar.add((Component)this.toolbarPanel, cons);
    }

    void switchToCard(MultiViewElement elem, String id) {
        if (!this.alreadyAddedElements.contains(elem)) {
            this.componentPanel.add((Component)elem.getVisualRepresentation(), id);
            this.alreadyAddedElements.add(elem);
        }
        this.cardLayout.show(this.componentPanel, id);
    }

    void peerComponentClosed() {
        if (this.componentPanel != null) {
            this.componentPanel.removeAll();
        }
        if (this.alreadyAddedElements != null) {
            this.alreadyAddedElements.clear();
        }
    }

    void changeActiveManually(MultiViewDescription desc) {
        Enumeration<AbstractButton> en = this.model.getButtonGroup().getElements();
        while (en.hasMoreElements()) {
            TabsButtonModel btnmodel;
            JToggleButton obj = (JToggleButton)en.nextElement();
            if (!(obj.getModel() instanceof TabsButtonModel) || !(btnmodel = (TabsButtonModel)obj.getModel()).getButtonsDescription().equals(desc)) continue;
            obj.setSelected(true);
            MultiViewElement elem = this.model.getElementForDescription(desc);
            elem.getVisualRepresentation().requestFocus();
            break;
        }
    }

    void changeVisibleManually(MultiViewDescription desc) {
        Enumeration<AbstractButton> en = this.model.getButtonGroup().getElements();
        while (en.hasMoreElements()) {
            TabsButtonModel btnmodel;
            JToggleButton obj = (JToggleButton)en.nextElement();
            if (!(obj.getModel() instanceof TabsButtonModel) || !(btnmodel = (TabsButtonModel)obj.getModel()).getButtonsDescription().equals(desc)) continue;
            obj.setSelected(true);
            break;
        }
    }

    private JToggleButton createButton(MultiViewDescription description) {
        JToggleButton button = new JToggleButton();
        Mnemonics.setLocalizedText((AbstractButton)button, (String)Actions.cutAmpersand((String)description.getDisplayName()));
        button.setModel(new TabsButtonModel(description));
        button.setRolloverEnabled(true);
        Border b = this.getButtonBorder();
        if (b != null) {
            button.setBorder(b);
        }
        if (AQUA) {
            button.putClientProperty("JButton.buttonType", "square");
            button.putClientProperty("JComponent.sizeVariant", "small");
        }
        if (this.buttonMouseListener == null) {
            this.buttonMouseListener = new ButtonMouseListener();
        }
        button.addMouseListener(this.buttonMouseListener);
        button.setToolTipText(NbBundle.getMessage(TabsComponent.class, (String)"TabButton.tool_tip", (Object)button.getText()));
        button.setFocusable(true);
        button.setFocusPainted(true);
        return button;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInnerToolBar(JComponent innerbar) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.toolbarPanel != null) {
                this.bar.remove(this.toolbarPanel);
            }
            if (innerbar == null) {
                innerbar = this.getEmptyInnerToolBar();
            }
            innerbar.putClientProperty(TOOLBAR_MARKER, "X");
            if (!AQUA) {
                innerbar.setBorder(null);
            } else {
                innerbar.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            }
            this.toolbarPanel = innerbar;
            GridBagConstraints cons = new GridBagConstraints();
            cons.anchor = 13;
            cons.fill = 1;
            cons.gridwidth = 0;
            cons.weightx = 1.0;
            this.toolbarPanel.setMinimumSize(new Dimension(10, 10));
            this.bar.add((Component)this.toolbarPanel, cons);
            this.bar.revalidate();
            this.bar.repaint();
        }
    }

    void setToolbarBarVisible(boolean visible) {
        if (this.toolbarVisible == visible) {
            return;
        }
        this.toolbarVisible = visible;
        this.bar.setVisible(visible);
    }

    JComponent getEmptyInnerToolBar() {
        if (this.EMPTY == null) {
            this.EMPTY = new JPanel();
        }
        return this.EMPTY;
    }

    void requestFocusForSelectedButton() {
        this.bar.setFocusable(true);
        Enumeration<AbstractButton> en = this.model.getButtonGroup().getElements();
        while (en.hasMoreElements()) {
            JToggleButton but = (JToggleButton)en.nextElement();
            if (!this.model.getButtonGroup().isSelected(but.getModel())) continue;
            but.requestFocus();
            return;
        }
        throw new IllegalStateException("How come none of the buttons is selected?");
    }

    void requestFocusForPane() {
        this.bar.setFocusable(false);
        this.componentPanel.requestFocus();
    }

    private Border getButtonBorder() {
        if (this.buttonBorder == null) {
            this.buttonBorder = UIManager.getBorder("nb.tabbutton.border");
        }
        return this.buttonBorder;
    }

    public static boolean isXPTheme() {
        Boolean isXP = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return isXP == null ? false : isXP;
    }

    void startToggling() {
        ActionMap map = this.bar.getActionMap();
        AbstractAction act = new TogglesGoEastAction();
        map.put("navigateRight", act);
        InputMap input = this.bar.getInputMap(1);
        act = new TogglesGoWestAction();
        map.put("navigateLeft", act);
        act = new TogglesGoDownAction();
        map.put("TogglesGoDown", act);
        map.put("navigateUp", act);
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        input.put(stroke, "TogglesGoDown");
    }

    class ButtonMouseListener
    extends MouseAdapter {
        ButtonMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getComponent();
            b.getModel().setRollover(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getComponent();
            b.getModel().setRollover(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            e.consume();
            AbstractButton b = (AbstractButton)e.getComponent();
            MultiViewModel model = TabsComponent.this.model;
            if (model != null) {
                model.getButtonGroup().setSelected(b.getModel(), true);
                model.fireActivateCurrent();
            }
        }
    }

    static class TabsButtonModel
    extends JToggleButton.ToggleButtonModel {
        private MultiViewDescription desc;

        public TabsButtonModel(MultiViewDescription description) {
            this.desc = description;
        }

        public MultiViewDescription getButtonsDescription() {
            return this.desc;
        }
    }

    private class TogglesGoDownAction
    extends AbstractAction {
        private TogglesGoDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabsComponent.this.changeActiveManually(TabsComponent.this.model.getActiveDescription());
            TabsComponent.this.model.getActiveElement().getVisualRepresentation().requestFocusInWindow();
        }
    }

    private class TogglesGoEastAction
    extends AbstractAction {
        private TogglesGoEastAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiViewDescription[] descs = TabsComponent.this.model.getDescriptions();
            MultiViewDescription active = TabsComponent.this.model.getActiveDescription();
            for (int i = 0; i < descs.length; ++i) {
                if (descs[i] != active) continue;
                int next = i + 1;
                if (next >= descs.length) {
                    next = 0;
                }
                TabsComponent.this.changeVisibleManually(descs[next]);
                TabsComponent.this.requestFocusForSelectedButton();
            }
        }
    }

    private class TogglesGoWestAction
    extends AbstractAction {
        private TogglesGoWestAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiViewDescription[] descs = TabsComponent.this.model.getDescriptions();
            MultiViewDescription active = TabsComponent.this.model.getActiveDescription();
            for (int i = 0; i < descs.length; ++i) {
                if (descs[i] != active) continue;
                int next = i - 1;
                if (next < 0) {
                    next = descs.length - 1;
                }
                TabsComponent.this.changeVisibleManually(descs[next]);
                TabsComponent.this.requestFocusForSelectedButton();
            }
        }
    }
}

