/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ui.FileObjectPropertySet;
import org.netbeans.modules.search.ui.OpenMatchingObjectsAction;
import org.netbeans.modules.search.ui.ReplaceCheckableNode;
import org.netbeans.modules.search.ui.ResultsOutlineSupport;
import org.netbeans.modules.search.ui.UiUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class MatchingObjectNode
extends AbstractNode {
    private static final String INVALID_ICON = "org/netbeans/modules/search/res/invalid.png";
    private static final String WARNING_ICON = "org/netbeans/modules/search/res/warning.gif";
    private MatchingObject matchingObject;
    private Node original;
    private OrigNodeListener origNodeListener;
    private boolean valid = true;
    private PropertyChangeListener validityListener;
    private PropertyChangeListener selectionListener;
    Node.PropertySet[] propertySets;

    public MatchingObjectNode(Node original, Children children, MatchingObject matchingObject, boolean replacing) {
        this(original, children, matchingObject, new ReplaceCheckableNode(matchingObject, replacing));
    }

    private MatchingObjectNode(Node original, Children children, MatchingObject matchingObject, ReplaceCheckableNode checkableNode) {
        super(children, Lookups.fixed((Object[])new Object[]{matchingObject, checkableNode, matchingObject.getFileObject()}));
        this.matchingObject = matchingObject;
        if (matchingObject.isObjectValid()) {
            this.original = original;
            this.setValidOriginal();
            this.origNodeListener = new OrigNodeListener();
            original.addNodeListener((NodeListener)this.origNodeListener);
        } else {
            this.setInvalidOriginal();
        }
        this.validityListener = new ValidityListener(matchingObject);
        matchingObject.addPropertyChangeListener("invalidityStatus", this.validityListener);
        this.selectionListener = new SelectionListener();
        matchingObject.addPropertyChangeListener("selected", this.selectionListener);
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        return null;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
    }

    public Transferable drag() throws IOException {
        return UiUtils.DISABLE_TRANSFER;
    }

    public Image getIcon(int type) {
        if (this.valid) {
            return this.original.getIcon(type);
        }
        MatchingObject.InvalidityStatus is = this.matchingObject.getInvalidityStatus();
        String icon = is == null || is == MatchingObject.InvalidityStatus.DELETED ? INVALID_ICON : WARNING_ICON;
        return ImageUtilities.loadImage((String)icon);
    }

    public Action[] getActions(boolean context) {
        if (!context) {
            return new Action[]{SystemAction.get(OpenMatchingObjectsAction.class), new CopyPathAction()};
        }
        return new Action[0];
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public String getHtmlDisplayName() {
        return this.original.getHtmlDisplayName();
    }

    public String getDisplayName() {
        return this.original.getDisplayName();
    }

    public String getShortDescription() {
        return this.matchingObject.getFileObject().getPath();
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenMatchingObjectsAction.class);
    }

    private void setValidOriginal() {
        this.fireIconChange();
        this.fireDisplayNameChange(null, null);
    }

    private void setInvalidOriginal() {
        if (!this.valid) {
            this.fireIconChange();
            return;
        }
        this.valid = false;
        if (this.origNodeListener != null) {
            this.original.removeNodeListener((NodeListener)this.origNodeListener);
            this.origNodeListener = null;
        }
        String oldDisplayName = this.original.getDisplayName();
        this.original = new AbstractNode(Children.LEAF);
        this.original.setDisplayName(this.matchingObject.getFileObject().getNameExt());
        this.fireIconChange();
        this.fireDisplayNameChange(oldDisplayName, this.matchingObject.getFileObject().getNameExt());
    }

    public boolean canDestroy() {
        return false;
    }

    public void clean() {
        if (this.original != null && this.origNodeListener != null && this.valid) {
            this.original.removeNodeListener((NodeListener)this.origNodeListener);
        }
        if (this.validityListener != null) {
            this.matchingObject.removePropertyChangeListener("invalidityStatus", this.validityListener);
            this.validityListener = null;
        }
        if (this.selectionListener != null) {
            this.matchingObject.removePropertyChangeListener("selected", this.selectionListener);
            this.selectionListener = null;
        }
    }

    public Node.PropertySet[] getPropertySets() {
        if (this.propertySets == null) {
            Node.PropertySet set;
            this.propertySets = new Node.PropertySet[2];
            this.propertySets[0] = set = new Node.PropertySet(){

                public Node.Property<?>[] getProperties() {
                    Node.Property[] properties = new Node.Property[]{new DetailsCountProperty()};
                    return properties;
                }
            };
            this.propertySets[1] = new FileObjectPropertySet(this.matchingObject.getFileObject());
        }
        return this.propertySets;
    }

    private class SelectionListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            MatchingObjectNode.this.fireIconChange();
            ResultsOutlineSupport.toggleParentSelected((Node)MatchingObjectNode.this);
        }
    }

    private class ValidityListener
    implements PropertyChangeListener {
        private final MatchingObject matchingObject;

        public ValidityListener(MatchingObject matchingObject) {
            this.matchingObject = matchingObject;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (this.matchingObject.getInvalidityStatus() == MatchingObject.InvalidityStatus.DELETED) {
                this.matchingObject.removePropertyChangeListener("invalidityStatus", this);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MatchingObjectNode.this.setInvalidOriginal();
                }
            });
        }
    }

    private class CopyPathAction
    extends AbstractAction {
        public CopyPathAction() {
            super(UiUtils.getText("LBL_CopyFilePathAction"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f = FileUtil.toFile((FileObject)MatchingObjectNode.this.matchingObject.getFileObject());
            if (f != null) {
                Clipboard clipboard;
                String path = f.getPath();
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (toolkit != null && (clipboard = toolkit.getSystemClipboard()) != null) {
                    StringSelection strSel = new StringSelection(path);
                    clipboard.setContents(strSel, null);
                }
            }
        }
    }

    private class OrigNodeListener
    implements NodeListener {
        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }

        public void nodeDestroyed(NodeEvent ev) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MatchingObjectNode.this.setInvalidOriginal();
                }
            });
        }

        public void propertyChange(PropertyChangeEvent evt) {
            MatchingObjectNode.this.setValidOriginal();
        }
    }

    private class DetailsCountProperty
    extends Node.Property<Integer> {
        public DetailsCountProperty() {
            super(Integer.class);
        }

        public boolean canRead() {
            return true;
        }

        public Integer getValue() throws IllegalAccessException, InvocationTargetException {
            return MatchingObjectNode.this.matchingObject.getDetailsCount();
        }

        public boolean canWrite() {
            return false;
        }

        public void setValue(Integer val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return "detailsCount";
        }
    }
}

