/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.util.Date;
import java.util.Random;
import java.util.logging.Level;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class LocalFileSystem
extends AbstractFileSystem {
    private static final long serialVersionUID = -5355566113542272442L;
    private static final int REFRESH_TIME = Integer.getInteger("org.openide.filesystems.LocalFileSystem.REFRESH_TIME", 0);
    private static final int SUCCESS = 0;
    private static final int FAILURE = 1;
    private static final int NOT_EXISTS = 3;
    private File rootFile = new File(".");
    private boolean readOnly;

    public LocalFileSystem() {
        Impl impl = new Impl(this);
        this.info = impl;
        this.change = impl;
        InnerAttrs a = new InnerAttrs(this, this.info, this.change, impl);
        this.attr = a;
        this.list = a;
        this.setRefreshTime(REFRESH_TIME);
    }

    @Deprecated
    public LocalFileSystem(FileSystemCapability cap) {
        this();
        this.setCapability(cap);
    }

    @Override
    public String getDisplayName() {
        return this.rootFile.getAbsolutePath();
    }

    private void _setSystemName(String s) throws PropertyVetoException {
        this.setSystemName(s);
    }

    public synchronized void setRootDirectory(File r) throws PropertyVetoException, IOException {
        if (!r.exists() || r.isFile()) {
            throw new FSException(NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_RootNotExist", (Object)r.getAbsolutePath()));
        }
        String oldDisplayName = this.getDisplayName();
        this._setSystemName(this.computeSystemName(r));
        this.rootFile = r;
        this.firePropertyChange("root", null, this.refreshRoot());
        this.firePropertyChange("displayName", oldDisplayName, this.getDisplayName());
    }

    public File getRootDirectory() {
        return this.rootFile;
    }

    public void setReadOnly(boolean flag) {
        if (flag != this.readOnly) {
            this.readOnly = flag;
            this.firePropertyChange("readOnly", !flag ? Boolean.TRUE : Boolean.FALSE, flag ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    @Deprecated
    public void prepareEnvironment(FileSystem.Environment environment) {
        environment.addClassPath(this.rootFile.getAbsolutePath());
    }

    protected String computeSystemName(File rootFile) {
        String retVal = rootFile.getAbsolutePath().replace(File.separatorChar, '/');
        return Utilities.isWindows() || Utilities.getOperatingSystem() == 2048 ? retVal.toLowerCase() : retVal;
    }

    protected String[] children(String name) {
        File f = this.getFile(name);
        if (f.isDirectory()) {
            return f.list();
        }
        return null;
    }

    protected void createFolder(String name) throws IOException {
        File f = this.getFile(name);
        if (name.equals("")) {
            throw new FSException(NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_CannotCreateF", (Object)f.getName(), (Object)this.getDisplayName(), (Object)f.getAbsolutePath()));
        }
        if (f.exists()) {
            throw new FSException(NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_FolderAlreadyExist", (Object)f.getName(), (Object)this.getDisplayName(), (Object)f.getAbsolutePath()));
        }
        boolean b = LocalFileSystem.createRecursiveFolder(f);
        if (!b) {
            throw new FSException(NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_CannotCreateF", (Object)f.getName(), (Object)this.getDisplayName(), (Object)f.getAbsolutePath()));
        }
    }

    @Override
    boolean isEnabledRefreshFolder() {
        return true;
    }

    private static boolean createRecursiveFolder(File f) {
        String par;
        if (f.exists()) {
            return true;
        }
        if (!f.isAbsolute()) {
            f = f.getAbsoluteFile();
        }
        if ((par = f.getParent()) == null) {
            return false;
        }
        if (!LocalFileSystem.createRecursiveFolder(new File(par))) {
            return false;
        }
        f.mkdir();
        return f.exists();
    }

    protected void createData(String name) throws IOException {
        File f = this.getFile(name);
        boolean isError = true;
        IOException creationException = null;
        String annotationMsg = null;
        try {
            boolean bl = isError = !f.createNewFile();
            boolean bl2 = isError ? true : (isError = !f.exists());
            if (isError) {
                annotationMsg = NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_DataAlreadyExist", (Object)f.getName(), (Object)this.getDisplayName(), (Object)f.getAbsolutePath());
                creationException = new SyncFailedException(annotationMsg);
            }
        }
        catch (IOException iex) {
            isError = true;
            creationException = iex;
            annotationMsg = iex.getLocalizedMessage();
        }
        if (isError) {
            ExternalUtil.annotate((Throwable)creationException, annotationMsg);
            throw creationException;
        }
    }

    protected void rename(String oldName, String newName) throws IOException {
        File of = this.getFile(oldName);
        File nf = this.getFile(newName);
        Random rndm = null;
        int retry = 0;
        while (true) {
            boolean existsNF = nf.exists();
            boolean equalsOF = nf.equals(of);
            if (Utilities.isMac()) {
                equalsOF = of.getCanonicalFile().equals(nf.getCanonicalFile());
            }
            Boolean rename = null;
            if (existsNF && !equalsOF || !(rename = Boolean.valueOf(of.renameTo(nf))).booleanValue()) {
                String msg = NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_CannotRename", (Object)oldName, (Object)this.getDisplayName(), (Object)newName, (Object)existsNF, (Object[])new Object[]{rename});
                if (retry > 10) {
                    throw new FSException(msg);
                }
                LOG.log(Level.WARNING, "Rename #{0} failed: {1}", new Object[]{retry, msg});
                if (rndm == null) {
                    rndm = new Random();
                }
                int sleep = rndm.nextInt(100) + 1;
                LOG.log(Level.INFO, "Sleeping for {0} ms", sleep);
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.FINE, null, ex);
                }
            } else {
                return;
            }
            ++retry;
        }
    }

    protected void delete(String name) throws IOException {
        File file = this.getFile(name);
        if (LocalFileSystem.deleteFile(file) != 0) {
            if (file.exists()) {
                throw new FSException(NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_CannotDelete", (Object)name, (Object)this.getDisplayName(), (Object)file.getAbsolutePath()));
            }
            FileObject thisFo = this.findResource(name);
            if (thisFo != null) {
                if (thisFo.getParent() != null) {
                    thisFo.getParent().refresh();
                }
                thisFo.refresh();
                if (thisFo.isValid()) {
                    throw new FSException(NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_CannotDelete", (Object)name, (Object)this.getDisplayName(), (Object)file.getAbsolutePath()));
                }
            }
        }
    }

    private static int deleteFile(File file) {
        boolean ret = file.delete();
        if (ret) {
            return 0;
        }
        if (!file.exists()) {
            return 3;
        }
        if (file.isDirectory()) {
            File[] arr = file.listFiles();
            for (int i = 0; i < arr.length; ++i) {
                if (LocalFileSystem.deleteFile(arr[i]) == 0) continue;
                return 1;
            }
        }
        return file.delete() ? 0 : 1;
    }

    protected Date lastModified(String name) {
        return new Date(this.getFile(name).lastModified());
    }

    protected boolean folder(String name) {
        return this.getFile(name).isDirectory();
    }

    protected boolean readOnly(String name) {
        File f = this.getFile(name);
        return !f.canWrite() && f.exists();
    }

    protected String mimeType(String name) {
        return null;
    }

    protected long size(String name) {
        return this.getFile(name).length();
    }

    protected InputStream inputStream(String name) throws FileNotFoundException {
        BufferedInputStream fis;
        File file = null;
        try {
            file = this.getFile(name);
            fis = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException exc) {
            if (file == null || !file.exists()) {
                ExternalUtil.annotate((Throwable)exc, NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_FileOutsideModified", (Object)this.getFile(name)));
            }
            throw exc;
        }
        return fis;
    }

    protected OutputStream outputStream(String name) throws IOException {
        File f = this.getFile(name);
        if (!f.exists()) {
            f.getParentFile().mkdirs();
        }
        OutputStream retVal = new BufferedOutputStream(new FileOutputStream(f));
        if (Utilities.isMac()) {
            retVal = this.getOutputStreamForMac42624(retVal, name);
        }
        return retVal;
    }

    private OutputStream getOutputStreamForMac42624(OutputStream originalStream, String name) {
        final File f = this.getFile(name);
        final long lModified = f.lastModified();
        FilterOutputStream retVal = new FilterOutputStream(originalStream){

            @Override
            public void close() throws IOException {
                super.close();
                if (f.length() == 0L && f.lastModified() == lModified) {
                    f.setLastModified(System.currentTimeMillis());
                }
            }
        };
        return retVal;
    }

    protected void lock(String name) throws IOException {
        File file = this.getFile(name);
        if (!file.canWrite() && file.exists() || this.isReadOnly()) {
            throw new FSException(NbBundle.getMessage(LocalFileSystem.class, (String)"EXC_CannotLock", null, null, (Object)file.getAbsolutePath()));
        }
    }

    protected void unlock(String name) {
    }

    protected void markUnimportant(String name) {
    }

    private File getFile(String name) {
        return new File(this.rootFile, name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        in.registerValidation(new ObjectInputValidation(){

            @Override
            public void validateObject() {
                if (LocalFileSystem.this.attr.getClass() == DefaultAttributes.class) {
                    Impl impl = new Impl(LocalFileSystem.this);
                    LocalFileSystem.this.attr = new InnerAttrs(LocalFileSystem.this, impl, impl, impl);
                }
            }
        }, 0);
    }

    private static class InnerAttrs
    extends DefaultAttributes {
        static final long serialVersionUID = 1257351369229921993L;
        LocalFileSystem lfs;

        public InnerAttrs(LocalFileSystem lfs, AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list) {
            super(info, change, list);
            this.lfs = lfs;
        }

        @Override
        public Object readAttribute(String name, String attrName) {
            if (attrName.equals("java.io.File")) {
                return FileUtil.normalizeFile(this.lfs.getFile(name));
            }
            return super.readAttribute(name, attrName);
        }
    }

    public static class Impl
    implements AbstractFileSystem.List,
    AbstractFileSystem.Info,
    AbstractFileSystem.Change {
        static final long serialVersionUID = -8432015909317698511L;
        private LocalFileSystem fs;

        public Impl(LocalFileSystem fs) {
            this.fs = fs;
        }

        @Override
        public String[] children(String name) {
            return this.fs.children(name);
        }

        @Override
        public void createFolder(String name) throws IOException {
            this.fs.createFolder(name);
        }

        @Override
        public void createData(String name) throws IOException {
            this.fs.createData(name);
        }

        @Override
        public void rename(String oldName, String newName) throws IOException {
            this.fs.rename(oldName, newName);
        }

        @Override
        public void delete(String name) throws IOException {
            this.fs.delete(name);
        }

        @Override
        public Date lastModified(String name) {
            return this.fs.lastModified(name);
        }

        @Override
        public boolean folder(String name) {
            return this.fs.folder(name);
        }

        @Override
        public boolean readOnly(String name) {
            return this.fs.readOnly(name);
        }

        @Override
        public String mimeType(String name) {
            return this.fs.mimeType(name);
        }

        @Override
        public long size(String name) {
            return this.fs.size(name);
        }

        @Override
        public InputStream inputStream(String name) throws FileNotFoundException {
            return this.fs.inputStream(name);
        }

        @Override
        public OutputStream outputStream(String name) throws IOException {
            return this.fs.outputStream(name);
        }

        @Override
        public void lock(String name) throws IOException {
            this.fs.lock(name);
        }

        @Override
        public void unlock(String name) {
            this.fs.unlock(name);
        }

        @Override
        public void markUnimportant(String name) {
            this.fs.markUnimportant(name);
        }
    }
}

